/**********************************************************************
  code.eval.c : Part of Stack Machine Code
  (built-in Parts)
  
  Coded by Shigeru Hitomi  Mar. 2nd, 1993
  Modified by Keisuke Takebe 1999/09/22
  ***********************************************************************/

#include <stdio.h>
#include "defs.h"
#include "prototype.h"
#include "code.h"
#include "y.tab.h"

BOOLEAN in_eval = FALSE;

extern FILE    *fin;
extern MEMORY  *fin_mp;
extern int      lineno;

Object  *
eval_program(nargs, objs)
     int             nargs;
     Object         *objs[];
{
  Datum      *save_stackp    = stackp;
  Datum      *save_stackbase = stackbase;
  Inst       *save_mainprog  = mainprog;
  Inst       *save_progbase  = mainprogbase;
  Inst       *save_prog      = prog;
  Inst       *save_progp     = progp;
  Inst       *save_pc        = pc;
  Frame      *save_framebase = framebase;
  Frame      *save_fp = fp;
  MEMORY     *save_mp = fin_mp;
  Object     *obj     = objs[0];
  int         offset1 = 0, offset2 = 0;

  if (obj == NULL || TypeofOBJ(obj) != STRING_T)
    execerror("illegal program", 0);

  in_eval = TRUE;

  mainprogbase = progp;
  stackbase    = stackp;
  framebase    = fp;

  /* local block : running programs */ {
    register int    i;
    int             lines = IndexSize(obj->dim, obj->index);
    int             save_lineno = lineno;
    FILE           *mfin = fin;	/* push(fin)    */
    fin = (FILE *) 0;		/* nouse fin, use fin_mp */
    lineno = 0;

    for (i = 0; i < lines; i++) {
      char  *program = ((char **) obj->val)[i];

      fin_mp = (MEMORY *) mopen(program);

      run();

      if ( fin_mp != NULL ) {
	mclose(fin_mp);
	fin_mp = NULL;
      }
    }
    lineno = save_lineno;
    fin = mfin;		/* pop(fin)    */
  }

  offset1      = prog     - save_prog;
  offset2      = mainprog - save_mainprog; /* when mainprog-area has been
					    reallocated, mainprog and
					    save_mainprog are not the same. */
  prog         = save_prog     + offset1;
  progp        = save_progp    + offset1;
  pc           = save_pc       + offset1;
  mainprogbase = save_progbase + offset2;
  stackbase    = save_stackbase;
  stackp       = save_stackp;
  framebase    = save_framebase;
  fp     = save_fp;
  fin_mp = save_mp;

  in_eval = FALSE;

  return (Object *) 0;
}

/**********************************************************************
	End of Stack Machine Code
***********************************************************************/
