/**********************************************************************
	file.c :  Part of Stack Machine Code

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"
#include "syscom.h"
#include "code.h"

/*************  CPU type  **************
 BigEndian    - 680x0 or SPARC (EWS)
 LittleEndian - 80x86(PC) or Alpha(DEC)
****************************************/
#define OLD_FORMAT	0
#define NEW_FORMAT	1

static int     FileFormat = NEW_FORMAT;
static int     DataType   = OLD_BIG_ENDIAN;
static int     aDataSize  = 4;
extern char    FNAME[];
#define EXECin(name)		/* name */


char    *
write_type(format, type, byte)
     char           *format, *type;
     int		byte;
{
  static char  str[64];

  if (equal(format, "new"))
    FileFormat = NEW_FORMAT;
  else if (equal(format, "old"))
    FileFormat = OLD_FORMAT;

  if(equal(format, "new") || equal(format, "old")) {
    if (equal(type, "BigEndian") || equal(type, "ws"))
      DataType = ChangeDataType(BigEndian);
    else if (equal(type, "LittleEndian") || equal(type, "pc"))
      DataType = ChangeDataType(LittleEndian);
    else
      execerror("write_type(),", "illegal byte-order type");
    if(byte == 2 || byte == 4 || byte == 8)
      aDataSize = ChangeDataSize(byte);
    else
      execerror("write_type(),", "illegal size of 'a data'");
			
  }

  strcpy(str, (FileFormat == NEW_FORMAT) ? "new" : "old");
  strcat(str, (DataType == BigEndian) ? "/BigEndian" : "/LittleEndian");

  if (FileFormat == NEW_FORMAT) {
    char            tmp[32];
    sprintf(tmp, "/%d[bytes]", aDataSize);
    strcat(str, tmp);
  } else
    strcat(str, "/4[bytes]");

  return( str );
}


static int
get_index()
{
  int             numb;
  Datum           ind;
  ind = pop_obj();
  if (ind.obj == NULL || TypeofOBJ(ind.obj) != SCALAR_T)
    execerror("illegal index type", 0);
  numb = (int) (*(double *) ind.obj->val);
  if (numb < 0)
    execerror("illegal index", 0);
  return numb;
}

static char   *
read_old_file(fname, numb, length)
     char           *fname;	/* data file name  */
     int             numb;	/* number of block */
     int            *length;	/* data point      */
{
  int             dpt, size, before;
  h_type          head;	/* old header type */
  float          *fdata;

  load_header(fname, &head);
  *length = head.data_num;

  size = head.rec_leng * REC_SIZE;
  fdata = (float *) emalloc(size);

  before = syscom.buff_leng;  /* take */
  syscom.buff_leng = size;  /* take */

  dpt = load_data(fdata, fname, numb+1);
  if (dpt == -1)
    execerror("data file read error :", fname);
  if (dpt == -2)
    execerror("data point too large :", fname);

  /*	
	printf(" \"%s\":[%d] ---> series(%d points)\n", fname, numb,
	*length);
	*/

  syscom.buff_leng = before;  /* take */

  return (char *) fdata;
}

static char   *
read_old_file2(fname, dim, length)
     char   *fname;	/* data file name  */
     int    *dim;
     int    *length;	/* data point      */
{
  
  int    numb, max;
  int    dpt, size, before;
  h_type head;	/* old header type */
  float  *fdata, *tmp;
  
  load_header(fname, &head);

  max = *dim = head.rec_num;
  size = head.data_num;

  if ( max == 1 ) {
    *length = head.data_num;
    *dim = 1;
  } else {
    *length = head.rec_num;
    *(length+1) = head.data_num;
    *dim = 2;
  }

  fdata = (float *) emalloc( head.rec_leng * max * REC_SIZE );
  
  before = syscom.buff_leng;  /* take */
  syscom.buff_leng = head.data_num;    /* take */

  for ( numb = 0, tmp = fdata; numb < max; numb++, tmp += size ) {
    dpt = load_data( tmp, fname, numb+1);

    if (dpt == -1)
      execerror("data file read error :", fname);
    if (dpt == -2)
      execerror("data point too large :", fname);
  }    
  /*
    printf(" \"%s\":[%d] ---> series(%d points)\n", fname, numb,
    *length);
    printf(" %x \n", tmp );
    */
  syscom.buff_leng = before;  /* take */
  
  return (char *) fdata;
}

static void
write_old_file(buf, fname, numb, length)
     Buffer         *buf;	/* write data        */
     char           *fname;	/* data file name    */
     int             numb;	/* number of blocks  */
     int             length;	/* data points       */
{
  register int    i;
  int             dpt, siz;
  float          *fdata;

  if (access(fname, 0) != 0) {
    m_file(fname);
    stor_init(fname, 1 ); /* type = 1 : MS-DOS format */
  }

  siz = (length % 64 == 0) ? length : (length / 64 + 1) * 64;
  fdata = (float *) calloc(siz, sizeof(float));
  for (i = 0; i < length; i++)
    fdata[i] = (float) buf[i];
  dpt = stor_data(fdata, length, fname, numb+1);
  efree((char*)fdata);
  if (dpt == -1)
    execerror("data file write error :", fname);
  if (dpt == -2)
    execerror("data size mismatch :", fname);
  
  /*
    printf(" \"%s\":[%d] <--- series(%d points)\n", fname, numb,
    length);
    */  
}

static void
write_old_file2( buf, fname, numb, length )
     Buffer         *buf;	/* write data        */
     char           *fname;	/* data file name    */
     int             numb;	/* number of blocks  */
     int             length;	/* data points       */
{
  int i;
  Buffer *tmp;

  for ( i = 0, tmp = buf; i < numb ; i++, tmp+=length )
    write_old_file( tmp, fname, i, length );
}

static char   *
inv_cast(buf, elsize, length)
     Buffer         *buf;	/* charactor type bufffer */
     int             elsize;	/* size of a data element [byte] */
     int             length;	/* total number of data   */
{
  register int    i;
  char           *data = NULL;

  switch (elsize) {
    case 2 /* [byte] */ :
      data = (char *) emalloc(length * sizeof(short));
      for (i = 0; i < length; i++)
	((short *) data)[i] = (short) buf[i];
      break;
    case 4 /* [byte] */ :
      data = (char *) emalloc(length * sizeof(float));
      for (i = 0; i < length; i++)
	((float *) data)[i] = (float) buf[i];
      break;
    case 8 /* [byte] */ :
      data = (char *) emalloc(length * sizeof(double));
      for (i = 0; i < length; i++)
	((double *) data)[i] = (double) buf[i];
      break;
    default:
      execerror("unknown data size", "");
      break;
  }
  return (char *) data;
}

static Buffer *
casting(buf, elsize, length)
     char           *buf;	/* charactor type bufffer */
     int             elsize;	/* size of a data element [byte] */
     int             length;	/* total number of data   */
{
  register int    i;
  short          *short_data;
  float          *float_data;
  double         *double_data;
  Buffer         *data = NULL;

  switch (elsize) {
    case 2 /* [byte] */ :
      short_data = (short *) buf;
      data = (Buffer *) AllocBuffer(length);
      for (i = 0; i < length; i++)
	data[i] = (Buffer) short_data[i];
      break;
    case 4 /* [byte] */ :
      float_data = (float *) buf;
      data = (Buffer *) AllocBuffer(length);
      for (i = 0; i < length; i++)
	data[i] = (Buffer) float_data[i];
      break;
    case 8 /* [byte] */ :
      double_data = (double *) buf;
      data = (Buffer *) AllocBuffer(length);
      for (i = 0; i < length; i++)
	data[i] = (Buffer) double_data[i];
      break;
    default:
      execerror("unknown data size", "");
      break;
  }
  return data;
}


static Buffer *
loading_data(fname, numb, head, exist_index)
     char           *fname;	/* data file name      */
     int             numb;	/* number of blocks    */
     Header         *head;
     int             exist_index;	/* exist flag of index */
{
  char           *buf = NULL;
  Buffer         *data;
  int             length, old_dim;

  if (access(fname, 0) != 0)
    execerror("not exist file", fname);

  if (LoadHeader(fname, head) == -1)
    execerror("failed to read header", fname);

  switch (head->type_flag) {
    case 0:
    case 1:
      if (!exist_index) {
	buf = (char *) read_old_file2(fname, &old_dim, head->index);
	head->dim = old_dim;
      } else {
	buf = (char *) read_old_file(fname, numb, head->index);
	head->dim = 1;
      }
      head->data_size = sizeof(float);
      break;

    case BigEndian:
    case LittleEndian:
      if (exist_index) {
	buf = (char *) LoadData(fname, numb, head);
	if (buf == NULL)
	  execerror("failed to evaluate", fname);
	--head->dim;
	CopyIndex(head->index,SubIndex(head->index),head->dim);
      } else {
	buf = (char *) ReadFile(fname, head);
	if (buf == NULL)
	  execerror("failed to evaluate", fname);
      }
      break;
    default:
      execerror("unknown file", fname);
  }
  length = IndexSize(head->dim, head->index);
  data = (Buffer *) casting(buf, head->data_size, length);
  efree(buf);
  return data;
}

static void
saving_data(fname, numb, dim, index, buf, exist_index)
     char           *fname;	/* data file name      */
     int             numb;	/* number of blocks    */
     int             dim;	/* dimension of data   */
     int            *index;	/* index-size of data  */
     Buffer         *buf;	/* saving data         */
     int             exist_index;	/* exist flag of index */
{
  int             length, status;
  char           *data;
  switch (FileFormat) {
    case NEW_FORMAT:
      data = inv_cast(buf, aDataSize, IndexSize(dim, index));
      if (exist_index)

	status = StoreData(fname, numb, dim, index, data);
      else
	status = WriteFile(fname, dim, index, data);
      efree(data);
      if (status == -1)
	execerror("data file write error :", fname);
      break;
    case OLD_FORMAT:
      if ( exist_index ) {
	length = IndexSize(dim, index);
	write_old_file(buf, fname, numb, length);
      } else {
	if ( dim > 1 ) {
	  numb = index[0];
	  length = IndexSize( dim-1, index+1 );
	  write_old_file2(buf, fname, numb, length);
	} else {
	  numb = 0;
	  length = index[0];
	  write_old_file(buf, fname, 0, length);
	}
      }
      break;
  }
}

void
load()
{
  Datum           d;
  int             exist_index = *(int *)pc++;
  int             numb = 1; /* file index is started 1 */
  Buffer         *buf;
  char           *fname;
  Header          head;

  EXECin("load");
  d = pop_obj();
  if (d.obj == NULL || TypeofOBJ(d.obj) != STRING_T)
    execerror("failed to evaluate filename", 0);
  fname = *(char **) d.obj->val;

  if (exist_index)
    numb = get_index();

  buf = loading_data(fname, numb, &head, exist_index);
  d.obj = newacc(buf, head.dim, head.index, &Series);
  efree((char*)buf);
  push_obj(d);
}

void
store()
{
  Datum           d1, d2;
  int             exist_index = *(int *)pc++;
  int             numb = 1;	/* file index is started 1 */
  Buffer         *buf;
  char           *fname;
  int             dim, index[MAX_INDEX];
  BOOLEAN		store_type;

  EXECin("store");
  d1 = pop_obj();	/* file name */
  d2 = pop_obj(); /* object */
  if (d1.obj == NULL || TypeofOBJ(d1.obj) != STRING_T)
    execerror("failed to evaluate filename", 0);
  store_type = (TypeofOBJ(d2.obj) == SERIES_T) ;
  store_type = store_type || (TypeofOBJ(d2.obj) == SNAPSHOT_T) ;
  if (d2.obj == NULL || store_type == FALSE)
    execerror("illegal stored type", 0);
  if (exist_index)
    numb = get_index();

  fname = *(char **) d1.obj->val;

  /* Buffer */ {
    int             n = *(int *) d2.obj->val;
    buf = (Buffer *) ReadBuffer(n, &dim, index);
    if (buf == NULL)
      execerror("failed to evaluate series", 0);
  }

  saving_data(fname, numb, dim, index, buf, exist_index);
  FreeBuffer(buf);
  push_obj(d2);
}


/**********************************************************************
	END OF STACK MACHINE CODE
***********************************************************************/
