/**********************************************************************
  flow.c : Part of Stack Machine Code
  (if, while)
  
  Coded by Shigeru Hitomi  May. 4. 1992
  Last Modified by Keisuke Takebe  1999/09/24
  ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include "defs.h"
#include "prototype.h"
#include "code.h"
#include "y.tab.h"

/* by take */
#define ADJUST_RELOCATION {\
  int offset = prog - save_prog;\
  save_prog = prog;\
  origin += offset;}


void
continuer()
{
  continuing = 1;
}

void
breaker()
{
  breaking = 1;
}

int
is_true(obj)
     Object         *obj;
{
  register int    i;
  char           *s;
  Buffer         *buf;
  int             n, bn, dim, index[MAX_INDEX];

  switch (TypeofOBJ(obj)) {
  case SCALAR_T:
    return (int) (*(double *) obj->val);
    break;
  case STRING_T:
    n = IndexSize(obj->dim, obj->index);
    for (i = 0; i < n; i++) {
      s = ((char **) obj->val)[i];
      if (*s == '\0' )
	return FALSE;
    }
    return TRUE;
    break;
  case SERIES_T or SNAPSHOT_T:
    bn = *(int *) obj->val;
    if ((buf = ReadBuffer(bn, &dim, index)) == NULL)
      execerror("failed to evaluate a series/snapshot", 0);
    n = IndexSize(dim, index);
    for (i = 0; i < n; i++) {
      if (buf[i] == 0.0)
	break;
    }
    FreeBuffer(buf);
    return (i == n) ? TRUE : FALSE;
    break;
  default:
    return FALSE;
    break;
  }
}


void
forcode()
{
  Datum  d;
  Inst  *save_prog = prog;
  Inst  *origin    = pc-1;
  int    condition = *(int *)&pc[0];
  int    increment = *(int *)&pc[1];
  int    bodypart  = *(int *)&pc[2];
  int    nextstmt  = *(int *)&pc[3];
  int    bool;

  execute(origin + 5);		/* initialize */
  ADJUST_RELOCATION;
  execute(origin + condition);	/* condition  */
  ADJUST_RELOCATION;
  d = pop_obj();
  bool = is_true(d.obj);
  while (bool) {
    execute(origin + bodypart);
    ADJUST_RELOCATION;
    continuing = 0;		/* reset continuing flag */
    if (returning || breaking)
      break;
    execute(origin + increment); /* increment  */
    ADJUST_RELOCATION;
    execute(origin + condition); /* condition  */
    ADJUST_RELOCATION;
    d = pop_obj();
    bool = is_true(d.obj);
  }
  if (!returning)
    pc = origin + nextstmt;	/* next statement */
  breaking = 0;			/* reset breaking flag */
}

void
whilecode()
{
  Datum  d;
  Inst  *save_prog = prog;
  Inst  *origin    = pc-1;
  int    bodypart  = *(int *)&pc[0];
  int    nextstmt  = *(int *)&pc[1];

  int    bool;

  execute(origin + 3);		/* condition */
  ADJUST_RELOCATION;

  d    = pop_obj();
  bool = is_true(d.obj);
  while (bool) {
    execute(origin + bodypart);	/* body */
    ADJUST_RELOCATION;

    continuing = 0;		/* reset continuing flag */
    if (returning || breaking)
      break;
    execute(origin + 3);	/* condition */
    ADJUST_RELOCATION;

    d    = pop_obj();
    bool = is_true(d.obj);
  }
  if (!returning)
    pc = origin + nextstmt;	/* next statement */
  breaking = 0;			/* reset breaking flag */
}

void
dowhilecode()
{
  Datum  d;
  Inst  *save_prog = prog;
  Inst  *origin    = pc-1;
  int    condition = *(int *)&pc[0];
  int    nextstmt  = *(int *)&pc[1];

  do {
    execute(origin + 3);	/* body part */
    ADJUST_RELOCATION;

    continuing = 0;		/* reset continuing flag */
    if (returning || breaking)
      break;
    execute(origin + condition);
    ADJUST_RELOCATION;

    d = pop_obj();
  } while(is_true(d.obj));

  if (!returning)
    pc = origin + nextstmt;
  breaking = 0;			/* reset breaking flag */
}

void
ifcode()
{
  Datum  d;
  Inst  *save_prog = prog;
  Inst  *origin    = pc-1;
  int    thenpart  = *(int *)&pc[0];
  int    elsepart  = *(int *)&pc[1];
  int    nextstmt  = *(int *)&pc[2];
  int    bool      = 0;

  execute(origin + 4);		/* condition */
  ADJUST_RELOCATION;

  d    = pop_obj();
  bool = is_true(d.obj);
  if (bool) 
    execute(origin + thenpart);
  else if (elsepart)
    execute(origin + elsepart);
  ADJUST_RELOCATION;

  if (!returning)
    pc = origin + nextstmt;
}
/**********************************************************************
  End of Stack Machine Code
  ***********************************************************************/
