/**********************************************************************
	code.h : Part of STACK MACHINE CODE

			Coded by Shigeru Hitomi  Mar. 4, 1992
***********************************************************************/

#ifndef _CODE_H_
#define _CODE_H_

#ifndef EXTERN
#define EXTERN extern
#define _CODE_DEFINE_EXTERN_
#endif

#define RelativeAddr(p) (p - subprog)
#define AbsoluteAddr(p) (p + subprog)


EXTERN Datum    stack[NSTACK];	/* the stack                          */
EXTERN Datum   *stackp;		/* next free spot on stack            */
EXTERN Datum	*stackbase;	/* entry of current stack             */

#ifdef	_CODE_DEFINE_EXTERN_
EXTERN Inst    *mainprog;	/* the machine                        */
EXTERN Inst    *subprog;	/* the machine                        */
EXTERN int	MAINPROGSIZ;	/* machine code area size             */
EXTERN int	SUBPROGSIZ;	/* machine code area size             */
EXTERN int	PROGSIZ;
#else
EXTERN Inst    *mainprog = 0;	/* the machine                        */
EXTERN Inst    *subprog = 0;	/* the machine                        */
EXTERN int	MAINPROGSIZ = NPROG;	/* machine code area size     */
EXTERN int	SUBPROGSIZ = NPROG;	/* machine code area size     */
EXTERN int	PROGSIZ;
#endif

EXTERN Inst    *prog;		/* the mechine */
EXTERN Inst    *progp;		/* next free spot for code generation */
EXTERN Inst    *pc;		/* program counter during execution   */
EXTERN Inst    *mainprogbase;	/* start of current subprogram        */
EXTERN Inst    *subprogbase;	/* start of current subprogram        */
EXTERN int      returning;	/* 1 if return stmt seen              */
EXTERN int      breaking;	/* 1 if break stmt seen               */
EXTERN int      continuing;	/* 1 if continue stmt seen            */

EXTERN Frame    frame[NFRAME];
EXTERN Frame	*framebase;
EXTERN Frame   *fp;		/* frame pointer                      */

#ifdef _CODE_DEFINE_EXTERN_
#undef _CODE_DEFINE_EXTERN_
#undef EXTERN
#endif

#endif				/* _CODE_H_ */
/**********************************************************************
	End of STACK MACHINE CODE
***********************************************************************/
