/******************************************************************
**                                                               **
**      File Name : module.c                                     **
**                                                               **
**            SATELLITE System Module Control Routine            **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include "defs.h"

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>  /* for access */
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "prototype.h"
#include "code.h"
#include "y.tab.h"
#include "module.h"

#ifndef X_OK
#define X_OK            1	/* is it executable by caller */
#endif

extern char    *current_dir;
extern FILE    *fin;

static int      MAX_MODULE  = 30;
ModuleInfo     *module_info = NULL;
CommandInfo    *com_info = NULL, *com_work = NULL;
MessageInfo   **msg_info = NULL, *msg_work = NULL;
ErrorInfo     **err_info = NULL, *err_work = NULL;

static int  regist_module _ANSI_ARGS_((char *name, char *cmd_file,
				       char *msg_file, char *err_file,
				       char *pro_dir, char *login,
				       char *logout));
void
init_module()
{
  static int      OLD_SIZE = 0;
  int             i;
  unsigned        size;

  size = MAX_MODULE * sizeof(ModuleInfo);
  if (module_info == NULL) {
    module_info = (ModuleInfo *) emalloc(size);
    Bzero(module_info, size);
  } else
    module_info = (ModuleInfo *) realloc(module_info, size);

  size = MAX_MODULE * sizeof(MessageInfo *);
  if (msg_info == NULL) {
    msg_info = (MessageInfo **) emalloc(size);
    size = sizeof(MessageInfo);
    for (i = 0; i < MAX_MODULE; i++)
      msg_info[i] = (MessageInfo *) emalloc(size);
  } else {
    msg_info = (MessageInfo **) realloc(msg_info, size);
    size = sizeof(MessageInfo);
    for (i = OLD_SIZE; i < MAX_MODULE; i++)
      msg_info[i] = (MessageInfo *) emalloc(size);
  }

  size = MAX_MODULE * sizeof(ErrorInfo *);
  if (err_info == NULL) {
    err_info = (ErrorInfo **) emalloc(size);
    size = sizeof(ErrorInfo);
    for (i = 0; i < MAX_MODULE; i++)
      err_info[i] = (ErrorInfo *) emalloc(size);
  } else {
    err_info = (ErrorInfo **) realloc(err_info, size);
    size = sizeof(ErrorInfo);
    for (i = OLD_SIZE; i < MAX_MODULE; i++)
      err_info[i] = (ErrorInfo *) emalloc(size);
  }
  OLD_SIZE = MAX_MODULE;
}

void
define_information(sp)
Symbol         *sp;
{
  if (!(fin == stdin && istty(0)))
    return;
  puts("");
  puts("\t+----------------------+ Information +--------------------+");
  printf("\t   %% set Command_Path \"%s/%s\"\n", SL_BIN_DIR, sp->name);
  puts("\t  ( Command_Path, Command_File, Error_File, Message_File ) ");
  puts("\t  (      [ Setup_File, Clean_File ]                      ) ");
  puts("\t+---------------------------------------------------------+");
  fflush(stdout);
}

void
define_module()
{
  static char     cmd_file[DIR_LENGTH] = "";
  static char     msg_file[DIR_LENGTH] = "";
  static char     err_file[DIR_LENGTH] = "";
  static char     login[DIR_LENGTH] = "";
  static char     logout[DIR_LENGTH] = "";
  static char     pro_dir[DIR_LENGTH] = "";
  char            name[DIR_LENGTH];
  Symbol         *keywd = (Symbol *) * pc++;
  Symbol         *sp = (Symbol *) * pc++;
  int             type = (int) keywd->type;

  if (type == DEFINE) {
    char           *mdl = sp->name;
    if (*pro_dir == '\0')
      execerror("not defined command directory", mdl);
    if (*cmd_file == '\0')
      execerror("not defined command register file", mdl);
    if (*msg_file == '\0')
      execerror("not defined message file", mdl);
    if (*err_file == '\0')
      execerror("not defined error message file", mdl);
    regist_module(sp->name, cmd_file, msg_file, err_file,
		  pro_dir, login, logout);
    /* Initialize */ {
      *cmd_file = *msg_file = *err_file = '\0';
      *login = *logout = *pro_dir = '\0';
    }
    return;	/* module definition ... done. */
  }
  if (sp->obj != NULL && sp->obj->method->objtype == STRING_T)
    strcpy(name, *(char **) sp->obj->val);

  switch (type) {
  case COM_FILE:
    strcpy(cmd_file, name);
    break;
  case MSG_FILE:
    strcpy(msg_file, name);
    break;
  case ERR_FILE:
    strcpy(err_file, name);
    break;
  case COM_DIR:
    strcpy(pro_dir, name);
    break;
  case SETUP:
    strcpy(login, name);
    break;
  case CLEAN:
    strcpy(logout, name);
    break;
  default:
    fatal("programming miss.");
  }
  return;
}

void
print_module()
{
  Symbol         *sp = (Symbol *) * pc++;
  char           *name = sp->name;
  int             i, module_num = -1;

  for (i = 0; i < MAX_MODULE; i++) {
    if (equal(name, module_info[i].name)) {
      module_num = i;
      break;
    }
  }
  if (module_num == -1)
    execerror("illegal module name", name);

  printf("define %s {\n", name);
  printf("\tset Command_Path  \"%s\"\n",
	 module_info[module_num].pro_dir);
  printf("\tset Command_File  \"%s\"\n",
	 module_info[module_num].cmd_file);
  printf("\tset Message_File  \"%s\"\n",
	 module_info[module_num].msg_file);
  printf("\tset Error_File    \"%s\"\n",
	 module_info[module_num].err_file);
  printf("\tset Setup_File    \"%s\"\n",
	 module_info[module_num].login);
  printf("\tset Clean_File    \"%s\"\n",
	 module_info[module_num].logout);
  printf("}\n");
}


#if 0
Object         *
DefineModule(narg, objs)
     int      narg;
     Object  *objs[];
{
  if (narg != 1)
    execerror("DefineModule", "argument mismatch");


  regist_module(name, cmd_file, msg_file, err_file, pro_dir, login, logout)
}
#endif

static int
regist_module(name, cmd_file, msg_file, err_file, pro_dir, login, logout)
     char  *name, *cmd_file, *msg_file, *err_file;
     char  *pro_dir, *login, *logout;
{
  int             i, module_num = MAX_MODULE;

  for (i = 0; i < MAX_MODULE; i++) {
    if (equal(name, module_info[i].name)) {
      module_num = i;
      break;
    }
    if (module_info[i].flag == UNDEFINE) {
      if (module_num > i)
	module_num = i;
    }
  }
  if (module_num >= MAX_MODULE)
    return (-1);

  /*
   * fprintf(stderr, "module_no = %d\n", module_num);
   */
  module_info[module_num].flag = DEFINED;
  strcpy(module_info[module_num].name, name);

  /***** Command File Directory *****/
  if (strlen(pro_dir) == 0)
    strcpy(pro_dir, current_dir);
  if (pro_dir[strlen(pro_dir) - 1] != '/')
    strcat(pro_dir, "/");
  strcpy(module_info[module_num].pro_dir, pro_dir);

  /***** Command File *****/
  if (cmd_file[0] != '/')
    strcpy(module_info[module_num].cmd_file, pro_dir);
  else
    strcpy(module_info[module_num].cmd_file, "");
  strcat(module_info[module_num].cmd_file, cmd_file);

  /***** Message File *****/
  if (msg_file[0] != '/')
    strcpy(module_info[module_num].msg_file, pro_dir);
  else
    strcpy(module_info[module_num].msg_file, "");
  strcat(module_info[module_num].msg_file, msg_file);

  /***** Error Message File *****/
  if (err_file[0] != '/')
    strcpy(module_info[module_num].err_file, pro_dir);
  else
    strcpy(module_info[module_num].err_file, "");
  strcat(module_info[module_num].err_file, err_file);

  /***** Set Up Program Name *****/
  if (login[0] != '\0' && login[0] != '/')
    strcpy(module_info[module_num].login, pro_dir);
  else
    strcpy(module_info[module_num].login, "");
  strcat(module_info[module_num].login, login);

  /***** Cleaning Program Name *****/
  if (logout[0] != '\0' && logout[0] != '/')
    strcpy(module_info[module_num].logout, pro_dir);
  else
    strcpy(module_info[module_num].logout, "");
  strcat(module_info[module_num].logout, logout);

  return (0);
}


int
install_module()
{
  FILE           *fp;
  int             i, module_num = -1;
  Symbol         *sp = (Symbol *) * pc++;
  char           *name = (char *) sp->name;

  for (i = 0; i < MAX_MODULE; i++) {
    if (equal(name, module_info[i].name)) {
      module_num = i;
      break;
    }
  }
  if (module_num == -1)
    return (-1);

  if ((fp = fopen(module_info[module_num].cmd_file, "r")) == NULL)
    execerror("can't open command-register-file", name);

  {
    /*
     * int             n = cmd_delete(module_num); printf("delete
     * command = %d\n", n);
     */
    module_info[module_num].cmd_num = cmd_read(fp, module_num);
  }
  fclose(fp);

  if ((fp = fopen(module_info[module_num].msg_file, "r")) == NULL)
    execerror("can't open message-file", name);
  /*
   * msg_delete(module_num);
   */
  msg_info[module_num] = NULL;
  msg_read(fp, module_num);
  fclose(fp);

  if ((fp = fopen(module_info[module_num].err_file, "r")) == NULL)
    execerror("can't open error-message-file", name);
  /*
   * err_delete(module_num);
   */
  err_info[module_num] = NULL;
  err_read(fp, module_num);
  fclose(fp);

  /* Execute Setup Command */
  if (module_info[module_num].login[0] != '\0' &&
      access(module_info[module_num].login, X_OK) != -1) {
    intersh(module_info[module_num].login, 0);
  }
  /* */
  module_info[module_num].flag = LOADED;

  /* Display */
  {
    char           *name = module_info[module_num].name;
    int             cn = module_info[module_num].cmd_num;
    printf("  * SYSTEM MODULE %c[7m * %-10s* %c[m", ESC, name, ESC);
    printf("   : %3d External Functions ... Install Ok.\n", cn);
  }
  return 0;
}

void
free_child()
{
  register int    i;
  char           *proc;
  if (module_info == NULL)
    return;
  for (i = 0; i < MAX_MODULE; i++) {
    if (module_info[i].flag == UNDEFINE)
      break;
    /* Execute Clearn up Command */
    proc = module_info[i].logout;
    if (proc[0] != '\0' && access(proc, X_OK) != -1) {
      intersh(proc, 0);
    }
  }
}
