/**********************************************************************
        mdl.exec.c : Parts of Stack Machine Code
			(UNIX parts)

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/

/*
 * Safer version of system for interactive programs
 */

/**********************************************************************
	INCLUDES
***********************************************************************/
#include <stdio.h>
#include <signal.h>
#include <string.h>

#include "defs.h"

#include "code.h"
#include "prototype.h"
#include "y.tab.h"

#define EXTERN extern
#include "syscom.h"

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if 0
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
#endif

#if 0
#ifdef HAVE_VFORK
#define FORK_FUNC vfork()
#define FORK "vfork"
#else
#define FORK_FUNC fork()
#define FORK "fork"
#endif
#else
#define FORK_FUNC fork()
#define FORK "fork"
#endif

/**********************************************************************
	DIFINITIONS
***********************************************************************/

#ifndef  X_OK
#define  X_OK    1		/* test for execute (search) permission */
#endif

/* #define ARGC 20 */

#ifdef DEBUG
#define DEBUGF(a)	fprintf a
#else
#define DEBUGF(a)
#endif

extern int  tty;
BOOLEAN     in_module;

static int    ChildProcess    _ANSI_ARGS_((char *bin, char **argv));
static void   put_p           _ANSI_ARGS_((int narg, char *argv[]));
static void   PushReturnValue _ANSI_ARGS_((void));

/**********************************************************************
	FUNCTION
***********************************************************************/

void
InModule()
{
  in_module = TRUE;
}


int
exec()
{				/* run command line s */
  int     narg, status;
  char    *p, oneline[ONELINE], *argv[ARGC+1], *bin;
  Symbol  *sym = (Symbol *) *pc++;
  Object  *obj = getobj(sym);
  int	  ModuleNumber;
  
  in_module = FALSE;
  
  /* Raw Command Line [ModuleNumber,Bin,Parameters] */
  strcpy(oneline, *(char **)obj->val);
  splits(oneline, argv, ARGC );

#ifdef DEBUG
    {
      int i;
      for ( i = 0; argv[i] != NULL; i++ ) {
	fprintf(stderr, "[%s]", argv[i]);
	fflush(stderr);
      }
      fprintf(stderr,"\n");
    }
#endif

  /* Number of arguments (parameters) */
  narg = *(int *)pc++;
  if (narg > NARG)
    narg = NARG;
  
  ModuleNumber = atoi(argv[0]);
  bin = argv[1];

  /* Put parameters on the system common area */
  put_p(narg, argv + 1);

  
  /*
   *	 /usr/local/bin/SYSTEM/a.out -----> a.out  
   */
  for (p = argv[1] + strlen(argv[1]); *p != '/' && p >= argv[1]; --p)
    /* nothing */ ;
  if (*p == '/')
    argv[1] = p + 1;/* after write to syscom */

  if (access(bin, X_OK) != 0)
    execerror("Commnad not found or Permission denied.", argv[1]);
  
  fflush(stdout), fflush(stderr);

  status = ChildProcess(bin, argv + 1);

  if (status > 0)	/* Display Error Message, not return */
    ExecError(ModuleNumber, argv[1], status);
  
  PushReturnValue();
  return status;
}

static int
ChildProcess(bin, argv)
    char  *bin, **argv;
{
  int  status, pid;
  RETSIGTYPE  (*istat) (), (*qstat) (), (*tstat) ();
  
  istat = (RETSIGTYPE (*) ()) signal(SIGINT,  SIG_IGN);
  qstat = (RETSIGTYPE (*) ()) signal(SIGQUIT, SIG_IGN); /* take */
  tstat = (RETSIGTYPE (*) ()) signal(SIGTERM, SIG_IGN); /* take */

  switch (pid = FORK_FUNC)  {
  case -1:
    signal(SIGINT,  istat);
    signal(SIGQUIT, qstat); /* take */
    signal(SIGTERM, tstat); /* take */

    perror("fork failed");
    return pid;
  case 0:	/* Child Process */
#ifdef DEBUG
    fprintf(stderr,"in ChildProcess >> ");
    fprintf(stderr,"%s\n",bin);
    fflush(stderr);
#endif
    /* close(0), dup(tty); close(1), dup(tty); */
    close(2); dup(tty); close(tty);

    signal(SIGQUIT, SIG_DFL);
    signal(SIGTERM, SIG_DFL);
    signal(SIGINT,  SIG_DFL); /* take */

    execvp(bin, argv);
    perror("failed to execute child");
    _exit(0);  /* by take */
    
    break;
  default: /* Parent Process */
    signal(SIGQUIT, qstat); /* */
    signal(SIGTERM, tstat);
    break;
  }
  
  /* Waitting for Child Process */
  status = waitfor(pid);
  if (status == - SIGINT) { /* Interrupt Child Process  */
    intcatch();	/* long jump  ----->  run() */	
  }  
  signal(SIGINT,  (RETSIGTYPE (*)()) intcatch);
/*  signal(SIGINT,  istat); */
  
  return status;
}


static void
put_p(narg, argv)
    int  narg;
    char *argv[];
{
  int    i;
  Datum  d;
  Object *argm[NARG+1];
  
  if (narg > NARG)
    narg = NARG;
  argm[narg] = NULL;
  for (i = narg; i > 0; i--) {
    d = pop_obj();
    argm[i - 1] = d.obj;
  }
#ifdef DEBUG
  fflush(stderr); fprintf(stderr,"put_p:" );
#endif
  syscom.narg = syscom.parm_num = narg;
  for (i = 0; i < narg; i++) {
    if ( argv[i+1] != NULL ) {
      strncpy(syscom.strings[i], argv[i + 1], ONE_LINE);
      syscom.strings[i][ONE_LINE-1] = '\0';
    } else
      strcpy(syscom.strings[i], "\0");
    /* if undefined symbol, set string */

#ifdef DEBUG
    fprintf(stderr,"[%s]", syscom.strings[i] );
#endif
    syscom.values[i] = 0.0;
    if (argm[i] == NULL || argm[i]->method == NULL )
      continue;
    
    switch (argm[i]->method->objtype) {
    case STRING_T:
      strcpy(syscom.types[i], "string");
      strncpy(syscom.strings[i], ((char **) argm[i]->val)[0], ONE_LINE);
      syscom.strings[i][ONE_LINE-1] = '\0';
      break;
    case SCALAR_T:
      strcpy(syscom.types[i], "scalar");
      syscom.values[i] = *(double *) argm[i]->val;
      break;
    case SNAPSHOT_T:
      strcpy(syscom.types[i], "snapshot");
      syscom.values[i] = (double) (*(int *) argm[i]->val);
      break;
    case SERIES_T:
      strcpy(syscom.types[i], "series");
      syscom.values[i] = (double) (*(int *) argm[i]->val);
      break;
    default:
      break;
    }
  }
  
  if (narg != NARG)
    for (i = narg; i < NARG; i++) {
      strcpy(syscom.types[i], "");
      *syscom.strings[i] = '\0';
      syscom.values[i]   = 0.0;
    }

#ifdef DEBUG
  fprintf(stderr,"\n" ); fflush(stderr);
#endif
  /* clear return_type for PushReturnValue() */
  strcpy(syscom.return_type, "");
  syscom.return_values[0] = 0.0;

  write_syscom();
}


static void
PushReturnValue()
{
  Datum           d;
  char           *type;
  read_syscom();
  type = syscom.return_type;
  DEBUGF((stderr,"type = %s\n", syscom.return_type));
  DEBUGF((stderr,"syscom.return_values[0] = %f\n", syscom.return_values[0]));
  
  if (equal(type, "scalar")) {
    double         *sc = &syscom.return_values[0];
    d.obj = newacc(sc, 0, NULL, &Scalar);
  } else if (equal(type, "series")) {
    int             id = (int) syscom.return_values[0];
    d.obj = BufftoObj(id, &Series);
  } else if (equal(type, "snapshot")) {
    int             id = (int) syscom.return_values[0];
    d.obj = BufftoObj(id, &Snapshot);
  } else if (equal(type, "string")) {
    char           *str = syscom.return_strings[0];
    d.obj = newacc(&str, 0, NULL, &String);
  } else if (equal(type, "")) {
    d.obj = (Object *)NULL;
  } else
    execerror("illegal return value", "");
  push_obj(d);
}

/**********************************************************************
  End of Stack Machine Code (UNIX parts)
  ***********************************************************************/
