/******************************************************************
**                                                               **
**      File Name : read_file.c                                  **
**                                                               **
**                   System File Read Routine                    **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "defs.h"
#include "prototype.h"
#include "module.h"

/* #define	ARG	20 */
extern ModuleInfo   *module_info;
extern CommandInfo  *com_info, *com_work;
extern MessageInfo **msg_info, *msg_work;
extern ErrorInfo   **err_info, *err_work;


int
cmd_delete(moduleNo)
     int             moduleNo;
{
  CommandInfo    *p = com_info, *pre = NULL, *here;
  register int    n = 0;

  while (p != NULL) {
    here = p;
    p = p->next;
    if (here->module_num == moduleNo) {
      if (pre == NULL)
	com_info = p;
      else {
	pre->next = p;
      }
      efree((char*)here);
      n++;
    } else
      pre = here;
  }
  return n;
}



int
cmd_read(fp, no)
     FILE           *fp;
     int             no;
{
  register char  *in_ptr;
  register int    prm_no, i = 0;
  int             count = 0;
  char            inbuf[ONELINE], *argv[ARG], work[ONELINE];


  while (fgets(inbuf, ONELINE, fp) != NULL) {
    if (isdigit(inbuf[0]) == 0)
      continue;			/* not number --> comment line */

    /* '\n' -> NULL */
    inbuf[strlen(inbuf) - 1] = '\0';

    if (separate(inbuf, argv, ARG, "#") < 6)
      continue;

    com_work = com_info;
    com_info = (CommandInfo *) emalloc(sizeof(CommandInfo));
    i = 0;			/* number of arguv[] */

    /* Module No. */
    com_info->module_num = no;

    /* Command Group */
    com_info->group = atoi(argv[i++]);

    /* Command Name (Name1) */
    strcpy(com_info->name1, argv[i++]);

    /* Program Name (Name2) */
    strcpy(com_info->name2, argv[i++]);

    /* Command Parameter */
    com_info->parameter = atoi(argv[i++]);

    /* Parameter Strings & Messages */
    strcpy(com_info->param_str, argv[i++]);

    in_ptr = argv[i++];
    for (prm_no = 0; prm_no < com_info->parameter; prm_no++) {
      i = 0;
      while (*in_ptr != ',' && *in_ptr != '\0' && *in_ptr != '\n') {
	work[i++] = *in_ptr++;
      }
      work[i] = '\0';
      com_info->msg_no[prm_no] = atoi(work);
      if (*in_ptr != '\0' && *in_ptr != '\n')
	in_ptr++;
    }

    com_info->next = com_work;
    count++;
  }
  return (count);
}


void
msg_read(fp, no)
     FILE           *fp;
     int             no;
{
  register char  *ptr;
  register int    i;
  int             line_no = 0;
  char            inbuf[ONELINE], str[10], line[ONELINE];

  while (fgets(inbuf, ONELINE, fp) != NULL) {
    msg_work = msg_info[no];
    ptr = inbuf;
    while (isspace(*ptr) != 0)
      ptr++;
    if (*ptr != '#' && *ptr != '\n' && *ptr != '\0') {
      i = 0;
      while (isdigit(*ptr) != 0)
	str[i++] = *ptr++;
      str[i] = '\0';
      while (isspace(*ptr) != 0)
	ptr++;
      line_no = atoi(str);
      i = 0;
      while (*ptr != '\n' && *ptr != '\0' && i < ONELINE)
	line[i++] = *ptr++;
      line[i] = '\0';
    }
    msg_info[no] = (MessageInfo *) emalloc(sizeof(MessageInfo));
    msg_info[no]->no = line_no;
    msg_info[no]->str = (char *) emalloc(strlen(line) + 1);
    strcpy(msg_info[no]->str, line);
    msg_info[no]->next = msg_work;
  }
}



void
err_read(fp, no)
     FILE           *fp;
     int             no;
{
  register char  *ptr;
  register int    i;
  int             line_no = 0;
  char            inbuf[ONELINE], str[10], line[ONELINE];

  while (fgets(inbuf, ONELINE, fp) != NULL) {
    err_work = err_info[no];
    ptr = inbuf;
    while (isspace(*ptr) != 0)
      ptr++;
    if (*ptr != '#' && *ptr != '\n' && *ptr != '\0') {
      i = 0;
      while (isdigit(*ptr) != 0)
	str[i++] = *ptr++;
      str[i] = '\0';
      while (isspace(*ptr) != 0)
	ptr++;
      line_no = atoi(str);
      i = 0;
      while (*ptr != '\n' && *ptr != '\0' && i < ONELINE)
	line[i++] = *ptr++;
      line[i] = '\0';
    }
    err_info[no] = (ErrorInfo *) emalloc(sizeof(ErrorInfo));
    err_info[no]->no = line_no;
    err_info[no]->str = (char *) emalloc(strlen(line) + 1);
    strcpy(err_info[no]->str, line);
    err_info[no]->next = err_work;
  }
}
