#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>

#include "defs.h"
#include "cursor.h"
#include "module.h"
#include "prototype.h"
  
  
/* #define	ARGC	20 */

extern FILE *fin;

static int  END_POS = 0;
static int  ParaNest = 0;

static int  isclosed_brace  _ANSI_ARGS_((char *prmptr));
static int  getprm          _ANSI_ARGS_((int mdl, int prm_num, int *msg,
					 char *def, char *comline,
					 char *prmptr, char *allline));
static int  input_message   _ANSI_ARGS_((int mdl, int *msg, int cprm,
					 char **defv, char *str));
static char is_ommited      _ANSI_ARGS_((char *str, char *comline));
static int  catprm          _ANSI_ARGS_((char *str, char **defv,
					 int nprm, char *comline ));

static void
reprint(comline)
    char  *comline;
{
  extern int      prompt_len;

  /* Allocation of Message Line */
  CursorMove(CurINDEX,0);
  CursorMove(CurREV_INDEX,0);
  
  /* Reprint */
  CursorMove(CurBEGIN_LINE,0);
  CursorMove(CurFORWARD, prompt_len);
  ClearText(ClrFORWARD);
  xprintf("%s", comline);
}


int
ismodule( comline, allline, first )
    char *comline, *allline;
    int first;
{
  char            pro[COM_LENGTH], def[ONELINE];
  int             msg[NUM_PARM];
  int             mdl, grp, prm_num;
  int             found, flag;
  char           *next, com[ONELINE];
  
  next = GetToken(comline, com, sizeof(com));
  found = load_inform(com, pro, msg, def, &mdl, &grp, &prm_num);
  if (!found) {	/* For Assignment statement */
    while (isspace(*next))
      next++;
    if (*next != '=')
      return FALSE;
    next++;
    while (isspace(*next))
      next++;
    next = GetToken(next, com, sizeof(com));
    found = load_inform(com, pro, msg, def, &mdl, &grp, &prm_num);
  }
  if (found) {		/* SATELLITE COMMAND */
    if(istty(0) && fin == stdin && first ) {
      reprint(allline);
    }
    END_POS = strlen(allline);
    if (first)
      ParaNest = 0;
    ParaNest++;
    flag = getprm(mdl, prm_num, msg, def, comline, next, allline );
    ParaNest--;
    if ( flag == 1 )
      return -1;
    return TRUE;
  }
  return FALSE;
}


static char *
begin_kakko(prmptr)
    char  *prmptr;
{
  int     len;
  char    *p = prmptr;
  
  while (isspace(*p))
    p++;
  
  if (*p == '(')
    return p;
  
  len = strlen(prmptr);
  switch (*p) {
  case '\0':
    strcat(p, "(");
    break;
  case ';': /* case '&': */
    insertc(p, 0, '(');
    break;
  default:
    p = prmptr;
    if (isspace(*p))
      *p = '(';
    else
      return NULL;
    break;
  }
  if(istty(0) && fin == stdin) {
    if (len != 0)
      CursorMove(CurBACKWARD, len);
    xprintf("%s", prmptr), flush();
  }
  return p;		/* kakko position */
}


static void
end_kakko(prmptr, sep)
    char *prmptr, sep;
{
  char   sepa[3];
  
#ifdef CORE
  printf("\n%s\nclosed %d\n", prmptr, isclosed_brace(prmptr));
#endif

  if ( isclosed_brace(prmptr) == 0 ) {
    sprintf( sepa, "%c", sep);
  } else {
    sprintf( sepa, ")%c",sep);
  }
  strcat( prmptr, sepa );

  if(istty(0) && fin == stdin)
    xprintf("%s", sepa), flush();
}


static int
isclosed_brace(prmptr)
    char *prmptr;
{
  char *p;
  int n = 0;
  
  for (p = prmptr; *p != '\0' && *p != '(' ; p++);
  if ( *p == '(' ) {
    n = 1;
    p++;
  }  
  for ( ; *p != '\0' && n > 0; p++) {
    if ( *p == '"' ) {
      p++;
      while ( *p != '\0' && *p != '"' ) {
	if ( *p == '\\' ) p++;
	p++;
      }
    }
    if (*p == '(')
      n++;
    else if (*p == ')')
      n--;
  }
  return n;
}  


/* appended by take 1993.09.30 for recursive parameter inputs */
static int
check_prm_num( p, comline )
    char *p, *comline;
{
  int inBrace = 0;
  int n = 0, i;
  char *str = p, *tmp = p;
  
  if ( *str != '\0' ) {
    ++n;
    while ( *str != '\0' && inBrace >= 0 ) {
      while ( isspace(*str) ) {
	tmp = ++str;
      }
      switch(*str) {
      case '+': case '-': case '*': case '%':
      case '^': case '=': case '~': case '/':
	tmp = ++str;
	break;
      case '(':
	if ( istty(0) && fin == stdin && str > tmp )
	  if ( ismodule( tmp, comline, 0 ) == -1 ) {
	    str = tmp;
	    inBrace--;
	    n--;
	    break;
	  }
	++inBrace;
	tmp = ++str;
	break;
      case ')':
	--inBrace;
	++str;
	break;
      case '"':
	for ( ++str; *str != '\0' && *str != '"'; str++ )
	  if ( *str == '\\' && ( *(str+1) == '"' || *(str+1) == '\\' ))
	    str++;
	if ( *str == '\0' && END_POS < ONELINE-1 ) {
	  *str = '"';
	  *(str+1) = '\0';
	  if ( istty(0) && fin == stdin )
	    xprintf("%c",'"'), flush();
	}
	tmp = ++str;
	break;
      case ',':
	++str;
	if ( inBrace == 0 ) {
	  ++n;
	  tmp = str;
	}
	break;
      default:
	++str;
      }
    }
    if ( istty(0) && fin == stdin && inBrace >= 0 && str > tmp ) 
      if ( ismodule( tmp, comline, 0 ) == -1 )
	n--;

    str = p+strlen(p);

    for ( i = 0, --str; *str == ',' && str >= p; str--, i++ );
    str++;
    if ( inBrace >= 0 )
      n -= i;
    END_POS -= i;

    if ( istty(0) && fin == stdin ) {
      del_backward(strlen(comline),i);
      for ( i = 0; i < inBrace; i++ )
	xprintf(")"), flush();
    }
    for ( ; inBrace > 0 && END_POS < ONELINE-1; inBrace--, END_POS++ )
      *(str++) = ')';
    *str = '\0';
  }

  return n;
}


static int
getprm(mdl, prm_num, msg, def, comline, prmptr, allline )
    int  mdl, prm_num, *msg;
    char *def, *comline, *prmptr, *allline;
/**********************************************************
  input	mdl	: Module Name
  prm_num	: Number of All Parameter
  msg[]	: Message Numbers
  def	: Default Parameters (string)
  prmptr	: input parameters
  
  output	prmptr = keybuffer[(command)(parameter)];
  : modified parameters
  ************************************************************/
{
  int       n, cprm = 0, ok, pos, lock;
  char      *defv[ARGC], *p, sep;
  char      is_ommited();
  Key	    key;
  
  /* default parameter */
  n = separate(def, defv, ARGC, ",");
  if(n != prm_num && prm_num != 0) {
    warning("WARNING ... Error in Command Entry File ", 0);
    prm_num = n;
  }
  
  do {
    END_POS = strlen(allline);
    p = begin_kakko(prmptr);
    if (p == NULL)
      return (-1);
    
    if ((sep = is_ommited(prmptr, allline)) != '\0' )
      catprm( p+1, defv, prm_num, allline );
    
    cprm = check_prm_num(p+1, allline); /* take */

    if ( !istty(0) || fin != stdin || isclosed_brace(prmptr) <= 0 )
      break;

    if (cprm < prm_num) {
      if (cprm != 0 && p[strlen(p)-1] != ',' && END_POS < ONELINE-1) {
	strcat(comline, ",");
	if (istty(0) && fin == stdin)
	  xprintf(",");
      }
      if (END_POS+strlen(defv[cprm]) < ONELINE-2) {
	strcat(comline, defv[cprm]);
	xprintf("%s", defv[cprm]);
      }

      /* PRINT INPUT MESSAGE */
      ok = input_message(mdl, msg, cprm, defv, prmptr);
      if (ok == FALSE)
	return (-1);
      
      /* GET PARAMETERS */
      pos = strlen(allline) - strlen(defv[cprm]);
      lock = (int)( p - allline + 1 );
      do {
	key = getcon(allline, lock, pos);
	
	if (key == BS) {
	  if (ParaNest > 1) {
	    pos = strlen(allline);
	    del_backward(pos,pos-(int)(comline-allline));
	    *comline = '\0';
	    return 1;
	  } else {
	    pos = strlen(allline);
	    del_backward(pos,pos-lock);
	    pos = lock;
	    *(p+1) = '\0';	
	    continue;
	  }
	}
	if(key != ASCII)
	  sl_beep(1,1);
      } while(key == PREV || key == NEXT );
    }
  } while (cprm < prm_num);
  
  if (ParaNest > 1)
    sep = '\0';
  
  end_kakko(comline, sep);

  if (istty(0) && fin == stdin)
    clear_nextline();
  flush();
  if (cprm < prm_num) {
    warning("WARNING ... specified command requires more parameters ", 0);
    fflush(stderr);
  }
  return 0;
}


static int
input_message(mdl, msg, cprm, defv, str)
    int    mdl, *msg, cprm;
    char   **defv, *str;
{
  char  message[ONELINE];
            
  /* LOAD MESSAGE */
  if (load_msg(mdl, msg[cprm], message) == FALSE) {
    puts("Parameter Message NOT FOUND!");
    printf("Message No. %d\n", msg[cprm]);
    /*
     * streamptr = NULL;
     */
    return (FALSE);
  }

  /* DISPLAY INPUT-MESSAGE */
  disp_msg(message);
  
  return (TRUE);
}


static char
is_ommited(str, comline)
    char           *str, *comline;
{
  char            c;
  int             i, j;
  
  while ( *str != '\0' && *str != ';' ) {
    if ( *str == '"' ) {
      for ( ++str; *str != '\0' && *str != '"' ; str++ )
	if ( *str == '\\' && ( *(str+1) == '"' || *(str+1) == '\\' ) )
	  str++;
      if ( *str == '\0' )
	str--;
    }
    str++;
  }

  if ( *str == '\0' )
    return '\0';
  
  c = *str;
  for (i = 0; str[i] != '\0'; i++)
    /* nothing */ ;

  *str = '\0';

  if(istty(0) && fin == stdin) {
    j = strlen(comline);
    goto_pos(j,j-i+1);
    clear_forward(j-i+1,j);
  }

  return c;
}


static int
catprm( str, defv, nprm, comline )
    char *str, **defv, *comline;
    int  nprm;
{
  register int             i, cprm;
  char *pos;
  
  cprm = check_prm_num( str, comline ); /* take */

  if ( nprm <= cprm )
    return cprm;
  
  pos = str+strlen(str)-1;
  if ( *pos == ')' )
    *pos = '\0';

  for (i = cprm; defv[i] != NULL; i++) {
    if (i != 0 && *str != '\0') 
      strcat(str, ",");
    strcat(str, defv[i]);
  }
  
  if(istty(0) && fin == stdin) {
    for (i = cprm; defv[i] != NULL; i++) {
      if (i != 0 && *str != '\0') 
	xprintf(",");
      xprintf("%s", defv[i]), flush();
    }
  }
  return i;
}


#if 0
static void
display(comline)
    char  *comline;
{
  CursorPush();
  CursorMove(INDEX,0);
  CursorMove(INDEX,0);
  CursorMove(INDEX,0);
  CursorMove(BEGIN_LINE,0);
  ClearText(ClrFORWARD);
  printf("[%s]", comline);
  CursorPop();
}
#endif
