/******************************************************************
**                                                               **
**      File Name : inform.c                                     **
**                                                               **
**                 Command Information Procedure                 **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "defs.h"
#include "module.h"
#include "prototype.h"

extern ModuleInfo  *module_info;
extern CommandInfo *com_info, *com_work;
/*
 * extern MessageInfo   **msg_info, *msg_work;
 * extern ErrorInfo     **err_info, *err_work;
 */

int
isextern(command)
     char *command;
{
  CommandInfo    *p = com_info;

  while (p != NULL) {
    if (equal(command, p->name1))
      return TRUE;
    p = p->next;
  }
  return FALSE;
}


char           *
execname(command)
     char           *command;
{
  CommandInfo    *p;
  char           *pro_name, *path, *name, mn[10];
  int             siz;

  for (p = com_info; p != NULL; p = p->next) {
    if (equal(command, p->name1)) {
      path = module_info[p->module_num].pro_dir;
      name = p->name2;
      if(equal(name, "*"))	/* internal function */
	break;
      sprintf(mn, "%d,", p->module_num);
      siz = strlen(mn) + strlen(path) + strlen(name) + 1;
      pro_name = (char *) emalloc(siz);
      strcpy(pro_name, mn);
      strcat(pro_name, path);
      strcat(pro_name, name);
      return pro_name;
    }
  }
  return NULL;
}


int
load_inform(command, pro_name, msg_num, prm_str, mdl_num, grp_num, prm_num)
     char           *command, *pro_name, *prm_str;
     int            *msg_num;
     int            *mdl_num, *grp_num, *prm_num;
     /**********************************************************
       input
       command   : command name
       pro_name  : program name
       msg_num   : parameter message
       prm_str   : default command line
       mdl_num   : Module number
       grp_num   : Group number
       prm_num   : parameter number
       output
       1      : Found
       0      : Not Found
       ***********************************************************/
{
  CommandInfo *com_pre = NULL;
  int             i;


  pro_name[0] = '\0';
  prm_str [0] = '\0';

  com_work = com_info;

  while (com_info != NULL) {
    if (equal(command, com_info->name1)) {
      *mdl_num = com_info->module_num;
      *grp_num = com_info->group;
      strcpy(pro_name, com_info->name2);
      *prm_num = com_info->parameter;
      strcpy(prm_str, com_info->param_str);
      for (i = 0; i < *prm_num; i++) {
	msg_num[i] = com_info->msg_no[i];
      }

      if (com_info != com_work) {
	com_pre->next = com_info->next;
	com_info->next = com_work;
      }
      return (1);
    }
    com_pre = com_info;
    com_info = com_info->next;
  }

  com_info = com_work;
  return (0);

}


int
stor_inform(pro_name, prm_str)
     char           *pro_name, *prm_str;
     /**********************************************************
       input
       pro_name  : program name
       prm_str   : default command line
       output
       0      : Succeed
       -1      : Failed
       ***********************************************************/
{
  CommandInfo *com_pre = NULL;


  com_work = com_info;

  while (com_info != NULL) {
    if (equal(pro_name, com_info->name2)) {
      strcpy(com_info->param_str, prm_str);

      if (com_info != com_work) {
	com_pre->next = com_info->next;
	com_info->next = com_work;
      }
      return (0);
    }
    com_pre = com_info;
    com_info = com_info->next;
  }

  com_info = com_work;
  return (-1);

}
