/******************************************************************
**                                                               **
**      File Name : msg.c                                        **
**                                                               **
**             Parameter & Error Message Print Procedure         **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "prototype.h"
#include "module.h"
#include "cursor.h"

#define BELL	0x07

/* in mdl.defn.c */
extern ModuleInfo     *module_info;
extern CommandInfo    *com_info, *com_work;
extern MessageInfo   **msg_info, *msg_work;
extern ErrorInfo     **err_info, *err_work;


int
load_msg(mdl_num, msg_num, str)
     int             mdl_num, msg_num;
     char           *str;
     /**********************************************************
       Load Parameter Message
       
       INPUT:
       mdl_num : Module Number
       msg_num : Message Number
       
       OUTPUT:
       str     : Message String
       ********************************************************/
{
  *str = '\0';
  msg_work = msg_info[mdl_num];

  while (msg_info[mdl_num] != NULL) {
    if (msg_info[mdl_num]->no == msg_num) {
      strcpy(str, msg_info[mdl_num]->str);
      break;
    }
    msg_info[mdl_num] = msg_info[mdl_num]->next;
  }
  msg_info[mdl_num] = msg_work;

  return ((*str != '\0') ? TRUE : FALSE);
}



void
disp_msg(str)
     char  *str;
{
  CursorMove(CurINDEX,0);	/* cursor down */
  CursorMove(CurREV_INDEX,0);   /* cursor up */    	

  CursorPush();		/* cursor information save */

  CursorMove(CurINDEX,0);       /* cursor down */
  CursorMove(CurBEGIN_LINE,0);	/* cursor move top of line */
  ClearText (ClrFORWARD);	/* clear */

  xprintf("   ... %s", str);

  CursorPop();		/* set cursor */

  flush();
}



int
load_err(mdl_num, msg_num, str)
     int             mdl_num, msg_num;
     char           *str;
     /**********************************************************
       Display Error Message
       INPUT:
       mdl_num : Module Number
       msg_num : Message Number
       OUTPUT:
       str     : Error Message
       ********************************************************/
{
  *str = '\0';
  err_work = err_info[mdl_num];

  while (err_info[mdl_num] != NULL) {
    if (err_info[mdl_num]->no == msg_num) {
      strcpy(str, err_info[mdl_num]->str);
      break;
    }
    err_info[mdl_num] = err_info[mdl_num]->next;
  }
  err_info[mdl_num] = err_work;

  return ((*str != '\0') ? TRUE : FALSE);
}



void
ExecError(mdl_num, bin, msg_num)
     int             mdl_num, msg_num;
     char		*bin;
     /**********************************************************
       Display Error Message
       msg_num : Message Number
       *********************************************************/
{
  char            *err_msg = 0, str[ONE_LINE];


  err_work = err_info[mdl_num];

  while (err_info[mdl_num] != NULL) {
    if (err_info[mdl_num]->no == msg_num) {
      err_msg = err_info[mdl_num]->str;
      break;
    }
    err_info[mdl_num] = err_info[mdl_num]->next;
  }
  err_info[mdl_num] = err_work;

  sprintf(str, "%c[7mError [<%s:%s> No.%d]%c[m%c", 
	  ESC, module_info[mdl_num].name, bin, msg_num, ESC, BELL);
  execerror(str, err_msg);
}
