/******************************************************************
**      File Name : module.h                                     **
**                                                               **
**           External Header for SATELLITE CONTROLLER            **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/

#ifndef _MODULE_H_
#define _MODULE_H_

#define PARM_LENGTH     64	/* One Parameter Length */
#define COM_LENGTH      32	/* Command Name Length */
#define NUM_PARM        16	/* Number of Parameter */

#if !defined(ONE_LINE) || !defined(FILE_LENGTH)
#include "macro.h"
#endif

#define UNDEFINE	0
#define DEFINED		1
#define LOADED		2

/***** Module Information *****/
typedef struct mod_info {
	int             flag;
	int             cmd_num;
	char            name[PARM_LENGTH];
	char            cmd_file[FILE_LENGTH];
	char            msg_file[FILE_LENGTH];
	char            err_file[FILE_LENGTH];
	char            pro_dir[DIR_LENGTH];
	char            login[FILE_LENGTH];
	char            logout[FILE_LENGTH];
}               ModuleInfo;


/***** Command Information *****/
typedef struct com_info {
	int             module_num;
	int             group;
	char            name1[COM_LENGTH];
	char            name2[COM_LENGTH];
	int             parameter;
	char            param_str[ONE_LINE];
	int             msg_no[NUM_PARM];
	struct com_info *next;
}               CommandInfo;


/***** Parameter Message *****/
typedef struct msg_info {
	int             no;
	char            *str;
	struct msg_info *next;
}               MessageInfo;


/***** Error Message *****/
typedef struct err_info {
	int             no;
	char            *str;
	struct err_info *next;
}               ErrorInfo;

/* in mdl.info.c */
extern int   isextern     _ANSI_ARGS_((char *command));
extern char *execname     _ANSI_ARGS_((char *command));
extern int   load_inform  _ANSI_ARGS_((char *command, char *pro_name,
				       int *msg_num, char *prm_str,
				       int *mdl_num, int *grp_num,
				       int *prm_num));
extern int   stor_inform  _ANSI_ARGS_((char *pro_name, char *prm_str));

#endif	/* _MODULE_H_ */
