/*
 *  ip.c:  TCP/UDP IP Υͥĥ뤿δؿ
 *
 *  Ashida Hiroyuki, assie@bpel.tutics.tut.ac.jp
 *
 */

#include "defs.h"

#include   <stdio.h>
#include   <string.h>
#include   <errno.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include   <sys/types.h>
#endif
#include   <sys/socket.h>
#include   <netinet/in.h>

#ifdef HAVE_ARPA_INET_H
#include   <arpa/inet.h>
#endif
#include   <netdb.h>

#ifndef   INADDR_NONE
#define   INADDR_NONE   0xffffffff
#endif    /* INADDR_NONE */

#ifdef HAVE_STRERROR
# if defined(sun) && !defined(SOLARIS)
/* SunOS 4.1.3_U1 doesn't have strerror().  Use sys_errlist
 * instead. */
# undef HAVE_STRERROR
# endif
#endif

#ifndef HAVE_STRERROR
extern const char *const sys_errlist[];
# define strerror(x) (sys_errlist[x])
#endif

#ifndef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#   define CONST const
#else
#   define _ANSI_ARGS_(x)       ()
#   define CONST
#endif
#endif

/* in error.c */
#ifdef __STDC__
extern void Sperror _ANSI_ARGS_((char *fmt, ...));
#else
extern void Sperror _ANSI_ARGS_((va_decl va_alist));
#endif

/*
 * connect_socket -- 󤷤, åȤ˥ͥĥ
 *
 *    : ͥ󤷤å 
 *            顼ʤ ZERO ֤
 */
static  int
connect_socket ( host, service, protocol )
  char* host ;      
  char* service ;   
  char* protocol ; 
{
  struct  hostent  *phe ;   /* ۥȾؤΥݥ   */
  struct  servent  *pse ;   /* ӥؤΥݥ */
  struct  protoent *ppe ;   /* ץȥؤΥݥ */

  struct  sockaddr_in sin ;  /* an Internet endpoint address */
  int     sd, type ;         /* åΤ, Υ */

  bzero( (char *)&sin, sizeof(sin)) ; 
  sin.sin_family = AF_INET ; 

  if (( pse = getservbyname( service, protocol )) != NULL ) 
    sin.sin_port = pse->s_port ;   /* ݡֹ */
  else {
    Sperror( "can't get \"%s\" service entry\n", service ) ;
    return 0 ; 
  }

  /* Map host name to IP address, allowing for dotted decimal */
  /* 
   * ۥȥ͡फ IP ɥ쥹 
   * libresolv 󥯤Ƥ, ɥᥤ̾Ǥλ꤬ǽ 
   */
  if (( phe = gethostbyname( host ) ) != NULL )    
    bcopy ( phe->h_addr, (char*)&sin.sin_addr, phe->h_length ) ; 
  else if ( (sin.sin_addr.s_addr = inet_addr(host)) == INADDR_NONE ) {
    Sperror( "can't get \"%s\" service entry\n", service ) ;
    return 0  ; 
  }

  /* Map protocol name to protocol number */
  if ( ( ppe=getprotobyname( protocol )) == NULL ) {
    Sperror( "can't get \"%s\" protocol entry", protocol ) ; 
    return 0  ; 
  }

  /* Use protocol to choose a socket type */
  if ( strcmp(protocol, "udp") == 0 ) 
    type = SOCK_DGRAM ; 
  else 
    type = SOCK_STREAM ; 

  /* Allocate a socket */
  sd = socket( PF_INET, type, ppe->p_proto ) ; 
  if( sd < 0 ) {
    Sperror( "can't create socket: %s", strerror(errno) ) ; 
    return 0  ; 
  }

  /* Connect the socket */
  if( connect( sd, (struct sockaddr *)&sin, sizeof(sin)) < 0 ) {
    Sperror( "can't connect to %s ", host, service  ) ; 
    return 0  ;
  }

  return  sd ;
}


/*
 * passivesock 
 * allocate & bind a server socket using TCP or UDP
 */
int
passivesock( service, protocol, qlen )
     char  *service ;     /* server associated with the desired port */
     char  *protocol ;    /* name of protocol to user ( "tcp" or "udp" ) */
     int   qlen ;         /* maximun length of the server request queue */
{
  struct servent  *pse ;   /* pointer to servie informatoin entry */
  struct protoent *ppe ;   /* pointer to protocol information entry */
  
  struct  sockaddr_in  sin ;  /* an Internet endpoint address */
  int     sd, type ;          /* socket descriptor and socket type */

  u_short  portbase = 0 ;     /* port base, for non-root service */

  bzero( (char *)&sin, sizeof(sin) ) ; 
  sin.sin_family      = AF_INET ; 
  sin.sin_addr.s_addr = INADDR_ANY ;

  /* Map service name to port number */
  if (( pse = getservbyname( service, protocol )) != NULL )
    sin.sin_port = htons( ntohs((u_short)pse->s_port) + portbase ) ; 
  else if ( ( sin.sin_port = htons((u_short)atoi(service))) == 0 ) {
    Sperror( "can't get \"%s\" service entry\n", service ) ;    
    return 0 ;
  }

  /* Map protocol name to protocol number */
  if ( ( ppe=getprotobyname( protocol )) == NULL ) {
    Sperror( "can't get \"%s\" protocol entry", protocol ) ; 
    return 0  ; 
  }

  /* Use protocol to choose a socket type */
  /* Use protocol to choose a socket type */
  if ( strcmp(protocol, "udp") == 0 ) 
    type = SOCK_DGRAM ; 
  else 
    type = SOCK_STREAM ; 

  /* Allocate a socket */
  sd = socket( PF_INET, type, ppe->p_proto ) ; 
  if( sd < 0 ) {
    Sperror( "can't create socket: %s", strerror(errno) ) ; 
    return 0 ; 
  }
  
  /* bind to socket */
  if( bind( sd, (struct sockaddr *)&sin, sizeof(sin)) < 0 ) {
    Sperror( "can't bind to %s port: %s", service, strerror(errno) ) ;
    return 0 ;
  }
  if( type == SOCK_STREAM && listen(sd,qlen) < 0 ) {
    Sperror( "can't listen to %s port: %s", service, strerror(errno) ) ;
    return 0 ; 
  }

  return  sd ;
}


/*
 * PassiveTCP -- ѤΥåȤ֤ؿ
 */
int
PassiveTCP( service, qlen )
  char*  service ;   /* ӥ͡ */
  int    qlen ; 
{
  return  passivesock( service, "tcp", qlen ) ; 
}

/*
 * PassiveUDP -- ѤΥåȤ֤ؿ
 */
int
PassiveUDP( service, qlen )
  char*  service ;   /* ӥ͡ */
  int    qlen ; 
{
  return  passivesock( service, "udp", qlen ) ; 
}


/*
 * ConnectTCP -- TCP ǥͥĥؿ
 *
 * :   ͥ󤷤åȤ֤ 
 */
int
ConnectTCP( host, service )
  char*  host ;      /* Υۥ̾ */
  char*  service ;   /* ӥ͡ */
{
  return  connect_socket( host, service, "tcp" ) ; 
}


/*
 * ConnectUDP -- UDP ǥͥĥؿ
 *
 * :   ͥ󤷤åȤ֤ 
 */
int
ConnectUDP( host, service )
  char*  host ;      /* Υۥ̾ */
  char*  service ;   /* ӥ͡ */
{
  return  connect_socket( host, service, "udp" ) ; 
}

