/**********************************************************************
	obj.bltin.c : Part of Stack Machine Code
			(operater parts)
	
			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#include <stdio.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"
#include "obj.bltin.h"

static Object *
bltin_new()
{
  Object         *blt;

  blt = (Object *) emalloc(sizeof(Object));
  blt->link = 0;
  blt->val = (VFUNC *) emalloc(sizeof(VFUNC));
  *(VFUNC *) blt->val = NULL;
  blt->method = Builtin.method;
  return blt;
}

static Object *
bltin_copy(to, from)
     Object	*to, *from;
{
  if(to == NULL || TypeofOBJ(to) != TypeofOBJ(from)) {
    if(to != NULL)
      (* to->method->destroy)(to);
    to = (* from->method->new)();
  }

  (* to->method->setvalue)(to, from->val, 0, NULL);
  return to;
}

static void
bltin_setvalue(blt, ptr, dim, index)
     Object         *blt;
     VFUNC           ptr;
     int		dim, *index;
{
  *(VFUNC *) blt->val = ptr;
}

static void
bltin_destroy(blt)
     Object         *blt;
{
  if(blt->link == 0)
    efree((char*)blt);
  else
    blt->link --;

}
/**********************************************************************
  End of Stack Machine Code (operater parts)
  ***********************************************************************/

static Object *
bltin_opcode(vptr, s, obj)
     VFUNC          *vptr;
     char           *s;
     Object         *obj[];
{
  VFUNC           builtin = *vptr;

  (*builtin) (NULL);
  return obj[0];
}
