/**********************************************************************
	scalar.c : Part of Stack Machine Code
			(operater parts)
	
			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/

#include <stdio.h>
#include <math.h>
#include "defs.h"
#include "prototype.h"
#include "operator.h"
#include "y.tab.h"
#include "obj.scalar.h"

#include <assert.h>

static double *getscalar   _ANSI_ARGS_((Object *obj));
/*
static Object *calc_string _ANSI_ARGS_((DFUNC operator, char *s,
					Object *sc, Object*st));
*/
static Object *calc_buffer _ANSI_ARGS_((DFUNC operator, char *s,
					Object *sc, Object *sr));


static Object *
scalar_new()
{
  Object         *sc;

  sc = (Object *) emalloc(sizeof(Object));
  sc->link = 0;
  sc->dim = 0;
  sc->index = NULL;
  sc->val = (double *) emalloc(sizeof(double));
  *(double *) sc->val = 0.0;
  sc->method = Scalar.method;

  return sc;
}

static Object *
scalar_copy(to, from)
     Object       *to, *from;
{
  if (to == NULL || TypeofOBJ(to) != TypeofOBJ(from)) {
    if (to != NULL)
      (*to->method->destroy) (to);
    to = (*from->method->new) ();
  }
  (*to->method->setvalue) (to, (double*)from->val, 0, NULL);
  return to;
}


static void
scalar_setvalue(sc, val, dim, index)
     Object         *sc;
     double         *val;
     int		dim, *index;
{
  if (val != NULL)
    *((double *) sc->val) = (double) (*val);
  else
    execerror("scalar_setvalue: NULL Pointer assignment", 0);
}

static void
scalar_destroy(sc)
     Object         *sc;
{
  if (sc == NULL)
    return;
  if (sc->link == 0) {
    efree((char*)(sc->val));
    efree((char*)(sc));
  } else {
#ifdef DEBUG
    fprintf(stderr,"scalar_destroy(): [%lx]not freed\n",
	    (unsigned long)sc);
#endif
    sc->link--;
  }
}


/*--------------------------------------------------------------------*/
static Object *
scalar_opcode(dptr, s, obj)
     DFUNC          *dptr;
     char           *s;
     Object         *obj[];
{
  DFUNC         operator = *dptr;
  double       *dp, x = 0, y = 0;
  Object       *acc = NULL;

  dp = getscalar(obj[0]);
  if (dp == NULL)		/* Null argument : Never Happen */
    execerror("scalar", "null argument or not scalar type");
  x = *dp;

  dp = getscalar(obj[1]);
  if (dp != NULL)
    y = *dp;

  if (obj[1] == NULL || dp != NULL) {
    /* one argument or arg2 is scalar type */
    double          d = (*operator) (x, y);
    check_result(s, TRUE);
    acc = newacc(&d, 0, NULL, &Scalar);
  } else if (TypeofOBJ(obj[1]) == SERIES_T ||
	     TypeofOBJ(obj[1]) == STRING_T ||
	     TypeofOBJ(obj[1]) == SNAPSHOT_T) { 
    acc = calc_buffer(operator, s, obj[0], obj[1]);
    /* return series object */
#if 0
  } else if (TypeofOBJ(obj[1]) == STRING_T){
    acc = calc_string(operator, s, obj[0], obj[1]); 
#endif
  } else
    execerror("scalar", "illegal object type");

  return acc;
}

static Object *
calc_buffer(operator, s, sc, sr)
     DFUNC           operator;
     char           *s;
     Object         *sc, *sr;
{
  Buffer         *buf;
  int             index[5], dim, i, dpt;
  double          d = *(double *) sc->val;
  Object       *acc;

  buf = getbuffer(sr, &dim, index);
  assert(buf);

  dpt = IndexSize(dim, index);
  for (i = 0; i < dpt; i++)
    buf[i] = (*operator) (d, buf[i]);
  check_result(s, TRUE);

  if(dpt == 1)
    acc = newacc(buf, 0, NULL, &Scalar);
  else
    acc = newacc(buf, dim, index, &Series);
  FreeBuffer(buf);
  return acc;
}

#if 0
static Object *
calc_string(operator, s, sc, st)
     DFUNC           operator;
     char           *s;
     Object         *sc, *st;
{
  register int	i, n;
  double          d = *(double *) sc->val;
  Buffer		*buf;
  Object       *acc;

  n = IndexSize(st->dim, st->index);
  buf = AllocBuffer(n);
  for (i = 0; i < n; i++) { 
    /*   
       printf( "val: %s  -> result of atof: %d\n", 
       ((char **)st->val)[i], atof(((char **)st->val)[i]) ) ; 
       */
    buf[i] = (*operator) (d, atof(((char **)st->val)[i]));
  }
  check_result(s, TRUE);

  if(n == 1)
    acc = newacc(buf, 0, NULL, &Scalar);
  else
    acc = newacc(buf, st->dim, st->index, &Series);
  FreeBuffer(buf);
  return acc;
}
#endif


static double *
getscalar(obj)
     Object         *obj;
{
  if (obj == NULL)
    return NULL;

  if (TypeofOBJ(obj) != SCALAR_T)
    return NULL;

  return (double *) obj->val;
}


static void
scalar_print(fmt, obj)
     char		*fmt;
     Object         *obj;
{
  print_number(fmt, "%.8g", *(double *) obj->val);
}

static Object * 
scalar_read()
{				/* read into variable */
  double          val = 0;

  switch (scanf("%lf", &val)) { 
  case EOF:
    break;
  case 0:
    execerror("non-number read into scalar object",0);
    break;
  default:
    /* success */
    break;
  }
  return newacc(&val, 0, NULL, &Scalar);
}

/**********************************************************************
        End of Stack Machine Code (operater parts)
***********************************************************************/
