/**********************************************************************
  obj.snap.c : Part of Stack Machine Code
  (operater parts)
  
  Coded by Shigeru Hitomi  Sep. 18, 1992
  ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"
#include "obj.snap.h"


static Object *
snap_new()
{
  Object         *obj;
  obj = (*Series.method->new) ();
  obj->method = Snapshot.method;
  return obj;
}

static Object *
snap_copy(to, from)
     Object       *to, *from;
{
  return (*Series.method->copy) (to, from);
}


static void
snap_setvalue(sr, buf, dim, index)
     Object         *sr;
     Buffer         *buf;
     int             dim, *index;
{
  (*Series.method->setvalue) (sr, buf, dim, index);
}

static void
snap_destroy(sr)
     Object         *sr;
{
  (*Series.method->destroy) (sr);
}


static Object *
snap_array(obj, sub_dim, sub_index)
     Object         *obj;	/* snapshot object        */
     int             sub_dim;/* number of index      */
     int            *sub_index;	/* a specified location */
{
  Object         *acc;
  int             no = *(int *) obj->val;
  int             p, dim, index[MAX_INDEX];
  Buffer         *bufp = ReadBuffer(no, &dim, index);
  if (bufp == NULL)
    execerror("failed to evaluate a snapshot", 0);
  if (dim != sub_dim)
    execerror("snapshot, dimension mismatch,", 0);
  if (!RegularIndex(sub_index, index, dim))
    execerror("out of index's range", 0);
  p = Index(sub_index, dim, index);
  acc = newacc(&bufp[p], 0, 0, &Scalar);
  FreeBuffer(bufp);
  return acc;
}



static void
snap_array_asgn(sr, sub_dim, sub_index, vobj)
     Object         *sr;
     int             sub_dim;
     int            *sub_index;
     Object         *vobj;
{
  int             no = *(int *) sr->val; /* buffer number */
  int             p, dim, index[MAX_INDEX];
  Buffer         *bufp = ReadBuffer(no, &dim, index);
  if (bufp == NULL)
    execerror("failed to read a internal buffer", 0);
  if (dim != sub_dim)
    execerror("dimension mismatch, snapshot", 0);
  if (!RegularIndex(sub_index, index, dim))
    execerror("out of index's range, snapshot", 0);
  p = Index(sub_index, dim, index);
  if (TypeofOBJ(vobj) != SCALAR_T)
    execerror("not scalar type object", 0);
  bufp[p] = *(double *) vobj->val;
  if (WriteBuffer(no, dim, index, bufp) == -1)
    execerror("failed to write a internal buffer", 0);
  FreeBuffer(bufp);
}

/*--------------------------------------------------------------------*/

static Object *
snap_opcode(dptr, s, obj)
     DFUNC          *dptr;
     char           *s;
     Object         *obj[];
{
  Object         *acc;
  if (obj[1] != NULL &&
      (TypeofOBJ(obj[1]) == SNAPSHOT_T || 
       TypeofOBJ(obj[1]) == SERIES_T)) {
    if (obj[0]->dim != obj[1]->dim)
      execerror("dimension mismatch, snapshot", 0);
    if (!EqualIndex(obj[0]->index, obj[1]->index, obj[1]->dim))
      execerror("index mismatch, snapshot", 0);
  }
  acc = (*Series.method->opcode) (dptr, s, obj);
  return acc;
}


static void
snap_print(fmt, obj)
     char		*fmt;
     Object         *obj;
{
  register int    i;
  Buffer         *buf;
  int		id = *(int *) obj->val;
  int             dim2, index2[MAX_INDEX], length;
  BOOLEAN		isTTY = TRUE; /*isTTY = istty(1);*/

  if((buf = ReadBuffer(id, &dim2, index2)) == NULL)
    execerror("failed to print snapshot", 0);

  length = IndexSize(dim2, index2);
  for (i = 0; i < length; i++) {
    if(isTTY) {
      index_header(i, dim2, index2, fmt, &Snapshot);
      if (fmt != NULL)
	putchar(' ');
    } else {
      putchar('\n');
    }
    print_number(fmt, "%12.4g", buf[i]);
  }
  FreeBuffer(buf);
}

static Object *
snap_read()
{				/* read into variable */
  Object         *acc = (*Series.method->read) ();
  acc->method = Snapshot.method;
  return acc;
}

/**********************************************************************
        End of Stack Machine Code (operater parts)
***********************************************************************/
