/**********************************************************************
	operator.c : Part of Stack Machine Code
			(operator parts)
	
			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#include <stdio.h>
#include <math.h>
#include <errno.h>

#include "defs.h"
#include "prototype.h"
#include "operator.h"

#define RANGE	2147483648.	/* (2^32)/2 */

extern int      errno;

#if 0
int
matherr(x)
     register struct exception *x;
{
  switch (x->type) {
  case DOMAIN:
    /* change sqrt to return sqrt(-arg1), not NaN */
    if (!strcmp(x->name, "sqrt")) {
      x->retval = sqrt(-x->arg1);
      return (0);		/* print message and set errno */
    } /* fall through */
  case SING:
    /*
     * all other domain or sing exceptions, print message and
     * abort
     */
    fprintf(stderr, "domain exception in %s\n", x->name);
    return(1);
    /* abort(); */
    break;
  }
  return (0);			/* all other exceptions, execute default
				 * procedure */
}
#endif

void
check_result(s, reset)
     char           *s;
     int             reset;
{
  char            mes[100];
  static int      warnings = FALSE;
  if (reset)
    warnings = FALSE;
  switch (errno) {		/* check result of library call */
  case EDOM:
    errno = 0;
    execerror(s, "argument out of domain");
  case ERANGE:
    errno = 0;
    if (warnings)
      break;
    sprintf(mes, "WARNING ... %s result out of range", s);
    warning(mes, 0);
    warnings = TRUE;
    break;
  default:
    break;
  }
}

double
add(a, b)
     double          a, b;
{
  return a + b;
}

double
sub(a, b)
     double          a, b;
{
  return a - b;
}

double
mul(a, b)
     double          a, b;
{
  return a * b;
}

double
Div(a, b)
     double          a, b;
{
  if (b == 0.0)
    execerror("division by zero", (char *) 0);
  return a / b;
}

double
mod(a, b)
     double          a, b;
{
  if (b == 0.0)
    execerror("division by zero", (char *) 0);
  return (double) ((long) a % (long) b);
}


double
negate(a)
     double          a;
{
  return -a;
}

double
gt(a, b)
     double          a, b;
{
  return (double) (a > b);
}

double
lt(a, b)
     double          a, b;
{
  return (double) (a < b);
}

double
ge(a, b)
     double          a, b;
{
  return (double) (a >= b);
}

double
le(a, b)
     double          a, b;
{
  return (double) (a <= b);
}

double
eq(a, b)
     double          a, b;
{
  return (double) (a == b);
}

double
ne(a, b)
     double          a, b;
{
  return (double) (a != b);
}

double
logic_and(a, b)
     double          a, b;
{
  return (double) (a != 0.0 && b != 0.0);
}

double
logic_or(a, b)
     double          a, b;
{
  return (double) (a != 0.0 || b != 0.0);
}

double
not(a)
     double          a;
{
  return (double) (a == 0.0);
}

double
integer(d)
     double          d;
{
  double sgn, y;

  sgn = ( d < 0.0 ) ? -1.0 : 1.0;

  y = floor(fabs(d));

  if ( y != 0.0 )
    y *= sgn;

  return y;
}

#if defined(TITAN) || defined(titan)
/*** appended for TITAN by take ***/

double
tasin(x)
     double x;
{
  return asin(x);
}

double
tacos(x)
     double x;
{
  return acos(x);
}

double
tatan(x)
     double x;
{
  return atan(x);
}

double
tfabs(x)
     double x;
{
  return fabs(x);
}

double
tsqrt(x)
     double x;
{
  return sqrt(x);
}

double
texp(x)
     double x;
{
  return exp(x);
}

double
tlog10(x)
     double x;
{
  return log10(x);
}

double
tlog(x)
     double x;
{
  return log(x);
}

double
ttan(x)
     double x;
{
  return tan(x);
}

double
tcos(x)
     double x;
{
  return cos(x);
}

double
tsin(x)
     double x;
{
  return sin(x);
}

/********************/
#endif

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

double
tatan2(y, x)
     double          y, x;
{
  double ret = 0.0;

  if ( x != 0.0 ) {
    if ( y == 0.0 )
      ret = ( x > 0.0 ) ? 0.0 : M_PI;
    else {
      x = Div(y, x);
      ret = atan(x);
    }
  } else {
    if ( y != 0 )
      ret = ( y > 0.0 ) ? M_PI/2.0 : -M_PI/2.0;
    else {
      ret = 0.0;

      errno = 0;
      warning("WARNING ... atan2( 0, 0 ) instruction is illegal", (char *) 0 );
    }
  }
  return ret;
}

double
sctest(x, y)
     double          x, y;
{
  printf("x = %f, y = %f\n", x, y);
  return x;
}

double
tpow(x,y)
     double x,y;
{
  return (y != 0.0) ? pow(x,y) : 1.0;
}

double
Exp2(x)
     double x;
{
  return (x != 0.0) ? pow(2.0, x) : 1.0;
}

double
Log2(x)
     double x;
{
  return log(x)/log(2.0); 
}

double
sign(x)
     double x;
{
  if ( x != 0.0 )
    return (x > 0.0) ? 1.0 : -1.0;

  return 0.0;
}

/**********************************************************************
        End of Stack Machine Code (operator parts)
***********************************************************************/
