#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"

void
print_number(fmt, def, d)
     char           *fmt, *def;
     double          d;
{
  char            c = (fmt == NULL) ? '\0' : fmt[strlen(fmt) - 1];
  switch (c) {
  case 'e' or 'f' or 'g':
    printf(fmt, d);
    break;
  case 'd' or 'c':
    printf(fmt, (int) d);
    break;
  default:
    printf(def, d);
    break;
  }
}


static int
numberOfItems(index_width, length, space_width)
     int             index_width, length, space_width;
{
  extern int      COLUMNS;	/* Window Width */
  int             m, columns = COLUMNS - index_width;

  m = columns / (length + space_width);
  m = (m > 5 && m % 2 == 1) ? m - 1 : m; /* odd --> even number */
  m = (m == 0) ? 1 : m;		/* 0   --> 1           */
  return m;
}

Buffer  *
getbuffer(obj, dim, index)
     Object         *obj;
     int            *dim, *index;
{
  register int	i;
  int             type, id, n;
  char		*s;
  Buffer		*buf;
  if (obj == NULL)
    return NULL;

  type = TypeofOBJ(obj);
  switch (type) {
  case SERIES_T or SNAPSHOT_T:{
    id = *(int *) obj->val;
    buf = ReadBuffer(id, dim, index);
    s = (type == SERIES_T) ? "series" : "snapshot";
    if (buf == NULL)
      execerror("failed to evaluate", s);
    return buf;
  }
  case STRING_T:{
    n = IndexSize(obj->dim, obj->index);
    buf = AllocBuffer(n);
    for (i = 0; i < n; i++) {
      /*
	 printf( "val: %s  -> result of atof: %lf\n", 
	 ((char **)obj->val)[i], atof(((char **)obj->val)[i]) ) ; 
	 */
      buf[i] = atof(((char **) obj->val)[i]);
    }
    *dim = obj->dim;
    CopyIndex(index, obj->index, obj->dim);
    return buf;
  }
  default:
    return NULL;
  }
}

static int
formatting(fmt, index_width)
     char           *fmt;
     int             index_width;
{
  int             obj_width = 0;
  if (fmt != NULL)
    sscanf(fmt + 1, "%d", &obj_width);
  if (obj_width == 0)
    obj_width = 12;
  else if (obj_width < 0)
    obj_width = -obj_width;
  return numberOfItems(index_width + 3, obj_width, /* space */ 1);
}


void
index_header(i, dim2, index2, fmt, class)
     int             i, dim2, index2[];
     char           *fmt;
     Object         *class;
{
  register int    j;
  static int      preindex, items, width[MAX_INDEX];
  int             index[MAX_INDEX];

  if (i == 0) {			/* initialize */
    char            tmp[32];
    int             index_width = 0;

    for (j = 0; j < dim2; j++) {
      sprintf(tmp, "%d", index2[j] - 1);
      width[j] = strlen(tmp);
      index_width += width[j] + 2; /* '[' and ']' */
    }
    items = formatting(fmt, index_width);
    preindex = 0;
  }
  rIndex(i, index, dim2, index2); /* i -----> index */
  if (class == &Series && dim2 != 1 && index[0] != preindex)
    putchar('\n');
  if (index[dim2 - 1] % items == 0) {
    putchar('\n');
    for (j = 0; j < dim2; j++) {
      printf("[%*d]", width[j], index[j]);
      if (j == 0 && class == &Series)
	putchar(':');
    }
    printf("%% ");
  }
  preindex = index[0];
}
