/******************************************************************
**                                                               **
**      File Name : cursor.h                                     **
**                                                               **
**                  Cursor Controll Routine                      **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#ifndef _CURSOR_H_
#define _CURSOR_H_

#undef ESC
#define	ESC		0x1B
#define NL              0x0d
#define CR              0x0a
#define DEL             0x7f
#define BS              0x08
#define TAB		0x09
#define UP_KEY          0x41
#define DOWN_KEY        0x42
#define RIGHT_KEY       0x43
#define LEFT_KEY        0x44
#define CTL_A		0x01
#define CTL_B           0x02
#define CTL_C           0x03
#define CTL_D           0x04
#define CTL_E		0x05
#define CTL_F		0x06
#define CTL_G		0x07
#define CTL_H		0x08
#define CTL_I		0x09
#define CTL_J		0x0a
#define CTL_K		0x0b
#define CTL_L		0x0c
#define CTL_M		0x0d
#define CTL_N		0x0e
#define CTL_O		0x0f
#define CTL_P		0x10
#define CTL_Q		0x11
#define CTL_R		0x12
#define CTL_S		0x13
#define CTL_T		0x14
#define CTL_U		0x15
#define CTL_V		0x16
#define CTL_W		0x17
#define CTL_X		0x18
#define CTL_Y		0x19
#define CTL_Z		0x1a
#define BELL		0x07

/* for ADDRESS */
#define NIL		(char *)(0x01)

typedef enum {
  GETIN, COMMAND, PARAM
} GetType;
typedef enum {
  ON, OFF
} Toggle;
typedef enum {
  CurUP, CurDOWN, CurBACKWARD, CurFORWARD, CurNEXT_LINE,
  CurINDEX, CurREV_INDEX,
  CurTOP_LINE, CurBOTTOM_LINE, CurBEGIN_LINE, CurEND_LINE
} CurDir;
typedef enum {
  CurREVERSE,
  CurNORMAL
} CharAtt;
typedef enum {
  ClrALL, ClrBACKWARD, ClrFORWARD
} ClrDir;
typedef enum {
  ASCII, PREV, NEXT, BACK, QUIT, WESC
} Key;

/**************************/
/**  Definition of Macro **/
/**************************/

#define GetWchar()	(void)getchar(),(void)getchar()

/**************************/
/**  functions            */
/**************************/

extern Key  getcon   _ANSI_ARGS_((char *str, int lock, int ipos));

extern void     CursorGoto         _ANSI_ARGS_((int x, int y));
extern void     CursorMove         _ANSI_ARGS_((CurDir dir, int num));
extern void     CursorColor        _ANSI_ARGS_((CharAtt color));
/* extern void     CursorAddress   _ANSI_ARGS_((int x, int y)); */
extern void     ClearText          _ANSI_ARGS_((ClrDir dir));
extern void     CursorDisplay      _ANSI_ARGS_((Toggle sw));
extern void     CursorPush         _ANSI_ARGS_((void));
extern void     CursorPop          _ANSI_ARGS_((void));

#endif /* _CURSOR_H_ */
