/******************************************************************
**                                                               **
**      File Name : cursor.c                                     **
**                                                               **
**                  Cursor Controll Routine                      **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include "defs.h"

#include <stdio.h>
#include <string.h>

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef HAVE_MEMSET
#define Bzero(s1,siz)           memset((char *)(s1), 0, siz)
#else
#define Bzero(s1,siz)           bzero((char *)(s1),siz)
#endif

#if 0
#if defined(SYSV) || defined(SVR4)
#include <termio.h>
#undef HAVE_TERMCAP_H
#undef HAVE_SGTTY_H
#endif
#endif

#ifdef __FreeBSD__
#include <sgtty.h>
#include <termcap.h>
#undef HAVE_TERMIO_H
#undef HAVE_TERMCAP_H
#endif

#ifdef HAVE_TERMIO_H
#include <termio.h>
#undef HAVE_SGTTY_H
#undef HAVE_TERMCAP_H     
#else  /* HAVE_TERMIO_H */
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#undef HAVE_SGTTY_H
#else  /* HAVE_TERMCAP_H */
#ifdef HAVE_SGTTY_H 
#include  <sgtty.h> 
#undef HAVE_TERMCAP_H  
#endif /* HAVE_SGTTY_H */
#undef HAVE_TERMIO_H
#endif /* HAVE_TERMCAP_H */
#endif /* HAVE_TERMIO_H */

#include "prototype.h"
#include "cursor.h"


static char  line_buf[2048] = {""};

int          LINES = 25, COLUMNS = 80;


#ifdef HAVE_LIBTERMCAP
char *termname = NULL;
char *TTY_goto;
char *TTY_move[20];
char *TTY_attr[3];
char *TTY_clr[4];
char *TTY_curpush;
char *TTY_curpop;
char *TTY_cursw[2];

static int
store_termcap_entry( tcmd, tstring )
     char *tcmd;
     char **tstring;
{
  int   status = 0, len;
  char  termcapentry[2048] = {""};
  char *bufptr;
  char *entry;

  if ( termname != NULL ) {
    tgetent(termcapentry, termname);
    bufptr = termcapentry;
    
    if (( entry = tgetstr( tcmd, &bufptr) ) != NULL ) {
      if ( ( len = strlen(entry) ) > 0 ) {
	*tstring = (char *)malloc(sizeof(char)* len +1 );
	strcpy( *tstring, entry );
      }else {
	*tstring = NULL;
	status = -1;
      }
    } else {
      *tstring = NULL; /* no entry ? */
      status = -1;
    }
  } else
    status = -1;

#ifdef DEBUG
  if ( status != -1 )
    fprintf(stderr,"[%s]", tcmd );
  else
    fprintf(stderr,"<%s>", tcmd );
#endif
  return status;
}


int
TerminalInitialize()
{
  int status = 0;

  /* this function should be called only at once */

  if (( termname = getenv("TERM") ) != NULL) {
#ifdef DEBUG
    fprintf(stderr,"termcap: " );
#endif
    store_termcap_entry( "cm", &TTY_goto );
    store_termcap_entry( "up", &TTY_move[CurUP] );
    store_termcap_entry( "do", &TTY_move[CurDOWN] );
    store_termcap_entry( "le", &TTY_move[CurBACKWARD] );
    store_termcap_entry( "nd", &TTY_move[CurFORWARD] );
    store_termcap_entry( "nw", &TTY_move[CurNEXT_LINE] );
    store_termcap_entry( "sf", &TTY_move[CurINDEX] );
    store_termcap_entry( "sr", &TTY_move[CurREV_INDEX] );
    store_termcap_entry( "UP", &TTY_move[CurTOP_LINE] );
    store_termcap_entry( "DO", &TTY_move[CurBOTTOM_LINE] );
    store_termcap_entry( "LE", &TTY_move[CurBEGIN_LINE] );
    store_termcap_entry( "RI", &TTY_move[CurEND_LINE] );
    store_termcap_entry( "mr", &TTY_attr[CurREVERSE] );
    store_termcap_entry( "me", &TTY_attr[CurNORMAL] );
    store_termcap_entry( "dl", &TTY_clr[ClrALL] );
    store_termcap_entry( "cb", &TTY_clr[ClrBACKWARD] );
    store_termcap_entry( "ce", &TTY_clr[ClrFORWARD] );
    store_termcap_entry( "sc", &TTY_curpush );
    store_termcap_entry( "rc", &TTY_curpop );
    store_termcap_entry( "vs", &TTY_cursw[ON] );
    store_termcap_entry( "vi", &TTY_cursw[OFF] );
#ifdef DEBUG
    fprintf(stderr,"\n" );
#endif
  } else
    status = -1;

  return status;
}

#endif /* HAVE_LIBTERMCAP */


void
ClearDisplayBuffer()
{
  fflush(stdout);
  Bzero(line_buf, 2048);
}

void
CursorGoto(x, y)
     int             x, y;
{

#ifdef  HAVE_LIBTERMCAP
  char  *sbuf;

  sbuf = tgoto(TTY_goto,x,y); 
#else
  char   sbuf[20];
  sprintf(sbuf, "%c[%d,%dH", ESC, x, y);
#endif

  put_line(sbuf);
}


void
CursorMove(dir, num)
     CurDir          dir;
     int             num;
     /**********************************************************
       Cursor Move
       
       dir : direction
       = 'u' : cursor up       , = 'U' : top line
       = 'd' : cursor down     , = 'D' : bottom line
       = 'b' : cursor backward , = 'B' : beginning of line
       = 'f' : cursor forward  , = 'F' : end of line
       = 'n' : next line
       = 'i' : index
       = 'r' : reverse index
       
       num : number
       ***********************************************************/
{
  
#ifdef  HAVE_LIBTERMCAP
  static char sbuf[2048];
  register int i = 0;

  switch (dir) {
  case CurUP:
    if (num > 0) {
      if ( num == 1 ) 
	strcpy(sbuf, TTY_move[CurUP]);
      else {
	if ( TTY_move[CurTOP_LINE] != NULL )
	  sprintf(sbuf,TTY_move[CurTOP_LINE], num);
	else {
	  strcpy(sbuf, TTY_move[CurUP]);
	  for ( i = 1; i < num; i++ )
	    strcat(sbuf, TTY_move[CurUP]);
	}
      }
    }
    break;
  case CurDOWN:
    if (num > 0) {
      if ( num == 1 ) 
	strcpy(sbuf, TTY_move[CurDOWN]);
      else {
	if ( TTY_move[CurBOTTOM_LINE] != NULL )
	  sprintf(sbuf,TTY_move[CurBOTTOM_LINE], num);
	else {
	  strcpy(sbuf, TTY_move[CurDOWN]);
	  for ( i = 1; i < num; i++ )
	    strcat(sbuf, TTY_move[CurDOWN]);
	}
      }
    }
    break;
  case CurFORWARD:
    if (num > 0) {
      if ( num == 1 ) 
	strcpy(sbuf, TTY_move[CurFORWARD]);
      else {
	if ( TTY_move[CurEND_LINE] != NULL )
	  sprintf(sbuf,TTY_move[CurEND_LINE], num);
	else {
	  strcpy(sbuf, TTY_move[CurFORWARD]);
	  for ( i = 1; i < num; i++ )
	    strcat(sbuf, TTY_move[CurFORWARD]);
	}
      }
    }
    break;
  case CurBACKWARD:
    if (num > 0) {
      if ( num == 1 ) 
	strcpy(sbuf, TTY_move[CurBACKWARD]);
      else {
	if ( TTY_move[CurBEGIN_LINE] != NULL )
	  sprintf(sbuf,TTY_move[CurBEGIN_LINE], num);
	else {
	  strcpy(sbuf, TTY_move[CurBACKWARD]);
	  for ( i = 1; i < num; i++ )
	    strcat(sbuf, TTY_move[CurBACKWARD]);
	}
      }
    }
    break;
  case CurTOP_LINE:
    if ( TTY_move[CurTOP_LINE] != NULL )
      sprintf(sbuf,TTY_move[CurTOP_LINE],    LINES);
    else {
      strcpy(sbuf, TTY_move[CurUP]);
      for ( i = 1; i < LINES; i++ )
	strcat(sbuf, TTY_move[CurUP]);
    }
    break;
  case CurBOTTOM_LINE:
    if ( TTY_move[CurBOTTOM_LINE] != NULL )
      sprintf(sbuf,TTY_move[CurBOTTOM_LINE], LINES);
    else {
      strcpy(sbuf, TTY_move[CurDOWN]);
      for ( i = 1; i < LINES; i++ )
	strcat(sbuf, TTY_move[CurDOWN]);
    }
    break;
  case CurEND_LINE:
    if ( TTY_move[CurEND_LINE] != NULL )
      sprintf(sbuf,TTY_move[CurEND_LINE], COLUMNS);
    else {
      strcpy(sbuf, TTY_move[CurFORWARD]);
      for ( i = 1; i < COLUMNS; i++ )
	strcat(sbuf, TTY_move[CurFORWARD]);
    }
    break;
  case CurBEGIN_LINE:
    if ( TTY_move[CurBEGIN_LINE] != NULL )
      sprintf(sbuf,TTY_move[CurBEGIN_LINE], COLUMNS);
    else {
      strcpy(sbuf, TTY_move[CurBACKWARD]);
      for ( i = 1; i < COLUMNS; i++ )
	strcat(sbuf, TTY_move[CurBACKWARD]);
    }
    break;
  case CurNEXT_LINE:
    strcpy(sbuf, (TTY_move[CurNEXT_LINE] != NULL) ?
	   TTY_move[CurNEXT_LINE]: TTY_move[CurDOWN]);
    break;
  case CurINDEX:        strcpy(sbuf, TTY_move[CurINDEX]);      break;
  case CurREV_INDEX:    strcpy(sbuf, TTY_move[CurREV_INDEX]);  break;
  }
  put_line(sbuf);
#else
  static  char sbuf[20];

  switch (dir) {
  case CurUP:       if (num > 0) sprintf(sbuf, "%c[%dA", ESC, num);     break;
  case CurDOWN:     if (num > 0) sprintf(sbuf, "%c[%dB", ESC, num);     break;
  case CurFORWARD:  if (num > 0) sprintf(sbuf, "%c[%dC", ESC, num);     break;
  case CurBACKWARD: if (num > 0) sprintf(sbuf, "%c[%dD", ESC, num);     break;
  case CurTOP_LINE:              sprintf(sbuf, "%c[%dA", ESC, LINES);   break;
  case CurBOTTOM_LINE:           sprintf(sbuf, "%c[%dB", ESC, LINES);   break;
  case CurEND_LINE:              sprintf(sbuf, "%c[%dC", ESC, COLUMNS); break;
  case CurBEGIN_LINE:            sprintf(sbuf, "%c[%dD", ESC, COLUMNS); break;
  case CurNEXT_LINE:             sprintf(sbuf, "%cE", ESC); break;
  case CurINDEX:                 sprintf(sbuf, "%cD", ESC); break;
  case CurREV_INDEX:             sprintf(sbuf, "%cM", ESC); break;
  }
  put_line(sbuf);
#endif
}



void
CursorColor(color)
     CharAtt         color;
     /**********************************************************
       Character Attribute
       
       parameter
       color : character color
       = 'r' : Reverse
       = 'n' : Normal
       ***********************************************************/
{
#ifdef HAVE_LIBTERMCAP
  switch (color) {
  case CurREVERSE:
  case CurNORMAL:
    put_line(TTY_attr[color]);
    break;
  }
#else
  char            sbuf[20];
  *sbuf = '\0';
  switch (color) {
  case CurREVERSE:
    sprintf(sbuf, "%c[7m", ESC);
    break;
  case CurNORMAL:
  default:
    sprintf(sbuf, "%c[0m", ESC);
    break;
  }
  put_line(sbuf);
#endif
}


#if 0
void
CursorAddress(pl, pc)
     int             pl, pc;
     /**********************************************************
       Direct Cursor Addressing
       
       pl : line   ( y )
       pc : column ( x )

       maybe not used!
       ***********************************************************/
{
  char  sbuf[20];

  sprintf(sbuf, "%c[%d;%dH", ESC, pl, pc);
  put_line(sbuf);
}
#endif


void
ClearText(dir)
     ClrDir          dir;
     /**********************************************************
       Clear Text
       
       dir : direction
       = 'A' : Clear Full Screen
       = 'B' : cursor backward
       = 'F' : cursor forward
       ***********************************************************/
{
#ifdef HAVE_LIBTERMCAP
  switch (dir) {
  case ClrALL:
  case ClrBACKWARD:
  case ClrFORWARD:
    put_line(TTY_clr[dir]);
    break;
  }
#else
  char            sbuf[20];

  *sbuf = '\0';
  switch (dir) {
  case ClrALL:
    sprintf(sbuf, "%c[2J", ESC);
    break;
  case ClrBACKWARD:
    sprintf(sbuf, "%c[1K", ESC);
    break;
  case ClrFORWARD:
    sprintf(sbuf, "%c[0K", ESC);
    break;
  }
  put_line(sbuf);
#endif
}

void
CursorDisplay(sw)
     Toggle          sw;
{
#ifdef HAVE_LIBTERMCAP
  switch (sw) {
  case  ON:
  case OFF:
    if ( TTY_cursw[sw] != NULL )
      puts(TTY_cursw[sw]);
    break;
  }
#else
  switch (sw) {
  case  ON: printf("%c[5l", ESC); break;
  case OFF: printf("%c[5h", ESC); break;
  }
#endif
  fflush(stdout);
}


void
CursorPush()
{
#ifdef HAVE_LIBTERMCAP  
  if ( TTY_curpush != NULL )
    put_line(TTY_curpush);
  else {
    char  sbuf[20];
    sprintf(sbuf, "%c7", ESC);
    put_line(sbuf);
  }
#else
  char  sbuf[20];
  sprintf(sbuf, "%c7", ESC);
  put_line(sbuf);
#endif
}

void
CursorPop()
{
#ifdef HAVE_LIBTERMCAP  
  if ( TTY_curpop != NULL )
    put_line(TTY_curpop);
  else {
    char  sbuf[20];
    sprintf(sbuf, "%c8", ESC);
    put_line(sbuf);
  }
#else
  char  sbuf[20];
  sprintf(sbuf, "%c8", ESC);
  put_line(sbuf);
#endif
}


void
flush()
{
  write(1, line_buf, strlen(line_buf));
  fflush(stdout);
  *line_buf = '\0';
}

void
errflush(fp)
     FILE *fp;
{
  if(fp == (FILE *)(-1))
    return;

  write(2, line_buf, strlen(line_buf));
  fprintf(fp, "%s", line_buf);
  fflush(fp);
  *line_buf = '\0';
}

/* VARARGS */
void
#ifdef __STDC__
xprintf(char *fmt, ...)
#else
     xprintf(va_alist)
     va_dcl
#endif
{
  char	sbuf[1024], *p, *sval, cval;
  int	ival;
  double 	dval;
  va_list         va;

#ifdef __STDC__
  va_start(va, fmt);
#else
  char           *fmt;

  va_start(va);
  fmt = va_arg(va, char *);
#endif

  for(p = fmt; *p; p++) {
    if(*p != '%') {
      sbuf[0] = *p, sbuf[1] = '\0';
      put_line(sbuf);
      continue;
    }
    switch(*++p) {
    case 'c':
      /* char -------> int */
      cval = va_arg(va, int);
      sbuf[0] = cval, sbuf[1] = '\0';
      break;
    case 'd':
      ival = va_arg(va, int);
      sprintf(sbuf, "%d", ival);
      break;
    case 'f':
      dval = va_arg(va, double);
      sprintf(sbuf, "%f", dval);
      break;
    case 's':
      sval = va_arg(va, char *);
      strcpy(sbuf, sval);
      break;
    default:
      sbuf[0] = *p, sbuf[1] = '\0';
      break;
    }
    put_line(sbuf);
  }
  va_end(va);
}

void
put_line(sbuf)
     register char *sbuf;
{
  if ( sbuf == NULL) return;
  if (*sbuf == '\0') return;

  if(strlen(line_buf) + strlen(sbuf) >= sizeof(line_buf))
    flush();
  strcat(line_buf, sbuf);
}
