#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "defs.h"
#include "prototype.h"

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#else
#include <sys/dir.h>
#endif

/* #define ARG		20 */
#define	DIRSIZE		FILE_LENGTH


int
filecheck(path, name)
     char   *path, *name;
{
  static int      n;
  static char     filename[DIRSIZE];
  int             i = 0;

  DIR            *dirp;
#ifdef HAVE_DIRENT_H
  struct dirent  *dp;
#else
  struct direct  *dp;
#endif

  if (*name != '\0') {
    n = 0;
    strcpy(filename, name);
  }
  if ((dirp = opendir(path)) == NULL) {
    sl_beep(2, 2);
    return (n);
  }
  while ((dp = readdir(dirp)) != NULL)
    if (strncmp(dp->d_name, filename, strlen(filename)) == 0) {
      if (++i > n) {
	++n;
	strcpy(name, dp->d_name);
	break;
      } else {
	/*
	 * printf("[%s]", dp->d_name); 
	 */
      }
    }
  closedir(dirp);

  if (dp == NULL)
    n = 0;

  return (n);
}


void
splitdir(path, dir)
     char *path, *dir;
{
  int             i;

  if (*path != '/')
    catstr("./", path);

  for (i = strlen(path); i > 0; --i) {
    if (path[i] == '/')
      break;
  }

  strcpy(dir, &path[++i]);
  path[i] = '\0';
}


int
filesearch(str, first)
     char  *str;
     int    first;
/*******************************************************
		INPUT:
			str:	filename
			first:	search flag
				(1) first search
				(0) continue
		OUTPUT:
			str:	full-name of file
*******************************************************/
{
  char            dir[DIRSIZE], path[ONELINE];
  int             tail, inode;


  strcpy(path, str);
  splitdir(path, dir);
  tail = strlen(str) - strlen(dir);
  str[tail] = '\0';

  if (!first)
    *dir = '\0';

  inode = filecheck(path, dir);
  strcat(str, dir);

  return inode;
}




#if 0 
main(argc, argv)
char           *argv[];
int             argc;
{
  char            name[256], tmp[256], *p;
  int             n = 0;

  while (1) {
    scanf("%s", name);
    strcpy(tmp, name);
    while (file(p)) {
      printf("filename[%s]\n", tmp);
      tmp[0] = NULL;
    }
  }
}
#endif
