/******************************************************************
**                                                               **
**      File Name : ioctl.c                                      **
**                                                               **
**                Console Input Procedure                        **
**                  ( Using ANSI ESC )                           **
**           ( This procedure is 4.xBSD & System V. )            **
**                                                               **
**      TEST PROGRAM:                                            **
**             cc (-DBSD) -DTEST key.c cursor.c file.c util.c    **
**	INCLUDE FILE :  cursor.h defs.h 			 **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include "defs.h"

#include <stdio.h>
#include <string.h>

#if 0
#if defined(SYSV) || defined(SVR4)
#include <termio.h>
#undef HAVE_TERMCAP_H
#undef HAVE_SGTTY_H
#endif
#endif

#if defined(__FreeBSD__)
#include <sgtty.h>
#include <termcap.h>
#undef HAVE_TERMIO_H
#undef HAVE_TERMCAP_H
#endif

#if defined(__NetBSD__)
#include <sgtty.h>
#include <termios.h>
#undef HAVE_TERMIO_H
#undef HAVE_TERMCAP_H
#endif

#if defined(__APPLE__)
#include <sgtty.h>
#undef HAVE_TERMIO_H
#endif

#ifdef HAVE_TERMIO_H
#include <termio.h>
#undef HAVE_SGTTY_H
#undef HAVE_TERMCAP_H     
#else  /* HAVE_TERMIO_H */
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#undef HAVE_SGTTY_H
#else  /* HAVE_TERMCAP_H */
#ifdef HAVE_SGTTY_H 
#include  <sgtty.h> 
#undef HAVE_TERMCAP_H  
#endif /* HAVE_SGTTY_H */
#undef HAVE_TERMIO_H
#endif /* HAVE_TERMCAP_H */
#endif /* HAVE_TERMIO_H */

#ifndef O_CBREAK
#define        O_CBREAK        0x00000002     /* half-cooked mode */
#endif
#ifndef CBREAK
#define        CBREAK          O_CBREAK
#endif

#include <ctype.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <assert.h>

#include "prototype.h"


#if ( defined(HAVE_SGTTY_H) || defined(HAVE_TERMCAP_H) ) && \
     !defined(HAVE_TERMIO_H)	/* BSD I/O CONTROL */
/************************************************************
 *                 BSD I/O CONTROL                          *
 * #include <sgtty.h>                                       *
 ************************************************************/
static struct sgttyb oldb, newb;

void
pushConsoleIO()
{
  ioctl(0, TIOCGETP, &oldb);

  newb = oldb;
  newb.sg_flags |= CBREAK;/* Ctrl+D */
  /* Echo Off & CR + LF --> CR */
/*  newb.sg_flags &= ~(ECHO | CRMOD); */
  newb.sg_flags &= ~(ECHO);

#ifdef NOUSE			/* comment out */
  newt.t_intrc = -1;	/* ctrl+C */
  newt.t_quitc = -1;	/* ctrl+\ */
  newl.t_suspc = -1;	/* ctrl+Z */
  newl.t_dsuspc = -1;	/* ctrl+Y */
  newl.t_flushc = -1;	/* ctrl+O */
  newl.t_lnextc = -1;	/* ctrl+V */
#endif				/* comment out */

  ioctl(0, TIOCSETP, &newb);
  push_console(TRUE);
}

void
popConsoleIO()
{
  if (push_console(TELL))
    ioctl(0, TIOCSETP, &oldb);

  push_console(FALSE);
}


int
istty(fd)
     int	fd;
{
  struct sgttyb   ttyb;
  return ioctl(fd, TIOCGETP, &ttyb) == 0;
}

#else				/* SYSTEM V I/O CONTROL */


/*************************************************************
 *              SYSTEM V I/O CONTOROL STRUCTURE              *
 * #include <termio.h>                                       *
 * #define NCC 8                                             *
 * struct termio {                                           *
 *      unsigned short  c_iflag;   /X* INPUT        FLAG *X/ *
 *      unsigned short  c_oflag;   /X* OUTPUT       FLAG *X/ *
 *      unsigned short  c_cflag;   /X* CONTROL      FLAG *X/ *
 *      unsigned short  c_lflag;   /X* LINE CONTROL FLAG *X/ *
 *      char            c_line;    /X* LINE CONTROL      *X/ *
 *      unsigned char   c_cc[NCC]; /X* CONTROL CHARACTOR *X/ *
 * };                                                        *
 *************************************************************/

static struct termio oldt, newt;

void
pushConsoleIO()
{
  ioctl(0, TCGETA, &oldt);
  newt = oldt;

  /* CBREAK & NO_ECHO */
  newt.c_lflag &= ~(ICANON | ECHO);	/* RESET */
  newt.c_cc[4] = 1;	/* MIN : get ONE charactor */
  newt.c_cc[5] = 1;	/* TIME */

  /* Mapping */
  /* CR + LF --> CR */
  newt.c_iflag |= INLCR;
  /* CR + LF <-- CR */
  newt.c_oflag |= ONLCR;

  ioctl(0, TCSETAW, &newt);
  push_console(TRUE);
}

void
popConsoleIO()
{
  if (push_console(TELL))
    ioctl(0, TCSETAW, &oldt);
  push_console(FALSE);
}

/*
     Istty() returns 1 if stdin(standard input) is associated with a terminal
     device, 0 otherwise.
*/
int
istty(fd)
int	fd;
{
  struct termio   tty;
  return ioctl(fd, TCGETA, &tty) == 0;
}

#endif				/* end of SYSTEM V I/O CONTROL */


/************************************************************
 *              Signal Processing                           *
 * #include <signal.h>                                      *
 ************************************************************/

BOOLEAN
push_console(f)
     BOOLEAN  f;
{
  static BOOLEAN     status = FALSE;
  switch (f) {
  case TELL:
    return status;
  case TRUE or FALSE:
    return status = f;
  default:
    fprintf(stderr, "illegal console status");
    assert(0);
  }
  return FALSE;		/* not reached */
}


#if 0	/* NO USE */
void
tstp()
{				/* for ^Z */
  puts("Stopped The SATELLITE Job ... ");
  fflush(stdout);
#ifdef  TIOCSETN
  ioctl(0, TIOCSETN, &oldb);
#else
  ioctl(0, TCSETA, &old);
#endif

  signal(SIGTSTP, SIG_DFL);
  sigsetmask(sigblock(0) & ~(1 << (SIGTSTP - 1)));
  kill(getpid(), SIGTSTP);
  sigblock(1 << (SIGTSTP - 1));
  signal(SIGTSTP, tstp);
  fflush(stdout);

  /* Foreground Job */
  printf("... Resume The SATELLITE Job ");
  fflush(stdout);
#ifdef TIOCSETN
  ioctl(0, TIOCSETN, &newb);
#else
  ioctl(0, TCSETA, &new);
#endif
}
#endif

/* typedef char * ioctl_t; */
/* Third arg of ioctl */
typedef void   *ioctl_t;
#define SHIN	0


void
GetSize(lins, cols)
     int *lins, *cols;
{
  /*
   * cols = Val(T_co); lins = Val(T_li);
   */

#if defined(TIOCGWINSZ) && !defined(TIOCGSIZE)
  {
    struct winsize  ws;	/* from 4.3 */

    if (ioctl(SHIN, TIOCGWINSZ, (ioctl_t) & ws) != -1) {
      if (ws.ws_col)
	*cols = ws.ws_col;
      if (ws.ws_row)
	*lins = ws.ws_row;
    }
  }
#elif defined(TIOCGSIZE)
  {
    struct ttysize  ts;	/* from Sun */

    if (ioctl(SHIN, TIOCGSIZE, (ioctl_t) & ts) != -1) {
      if (ts.ts_cols)
	*cols = ts.ts_cols;
      if (ts.ts_lines)
	*lins = ts.ts_lines;
    }
  }
#else
  *cols = 80;
  *lins = 24;
#endif

  if ( *cols > 255 ) *cols = 255; /* failsafe by take */
  if ( *lins > 127 ) *lins = 127; /* failsafe by take */
  /*
   * return (Val(T_co) != *cols || Val(T_li) != *lins);
   */
}
