/******************************************************************
**                                                               **
**      File Name : key.c                                        **
**                                                               **
**                Console Input Procedure                        **
**                  ( Using ANSI ESC )                           **
**           ( This procedure is 4.xBSD & System V. )            **
**                                                               **
**      TEST PROGRAM:                                            **
**             cc (-DBSD) -DTEST key.c cursor.c file.c util.c    **
**	INCLUDE FILE :  cursor.h defs.h 			 **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include <stdio.h>
#include <string.h>

#include "defs.h"

#ifdef __FreeBSD__
#include <sgtty.h>
#include <termcap.h>
#undef HAVE_TERMIO_H
#undef HAVE_TERMCAP_H
#endif

#ifdef HAVE_TERMIO_H
#include <termio.h>
#undef HAVE_SGTTY_H
#undef HAVE_TERMCAP_H     
#else  /* HAVE_TERMIO_H */
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#undef HAVE_SGTTY_H
#else  /* HAVE_TERMCAP_H */
#ifdef HAVE_SGTTY_H 
#include  <sgtty.h> 
#undef HAVE_TERMCAP_H  
#endif /* HAVE_SGTTY_H */
#undef HAVE_TERMIO_H
#endif /* HAVE_TERMCAP_H */
#endif /* HAVE_TERMIO_H */


#include <ctype.h>
#include <signal.h>
#include <assert.h>

#include "prototype.h"
#include "cursor.h"

extern char     PATH[ONELINE];
extern int      prompt_len;
extern int      LINES, COLUMNS;


static char     COPY_BUFFER[ONELINE];

int             I, END_POS;
char           *STR;


static Toggle functionkey _ANSI_ARGS_((int lock, int *i, Key *code));


static Toggle
functionkey(lock, i, code)
     int             lock, *i;
     Key            *code;
{
  Toggle          escape = ON;


  /* ESC + 0x5b + @ */
  switch (getc(stdin)) {
  case UP_KEY:			/* [UP] KEY */
    *code = PREV;
    return (escape);

  case DOWN_KEY:		/* [DOWN] KEY */
    *code = NEXT;
    return (escape);

  case LEFT_KEY:		/* [<-] KEY */
    if (*i > lock) {
      backward((*i)--);
    }
    break;

  case RIGHT_KEY:		/* [->] KEY */
    if (*i < END_POS) {
      forward(++(*i));
    }
    break;
  default:			/* Another Key */
    /* ESC + 0x5b + @ + @ */
    GetWchar();
    break;
  }
  return (escape = OFF);
}

void
goto_origin(i)
     int             i;	/* current position */
{
  int             pos = prompt_len + i;
  if( pos / COLUMNS > 0 )
    CursorMove(CurUP, pos / COLUMNS);
  CursorMove(CurBEGIN_LINE,0);
}


void
goto_begin(i)
     int             i;	/* current position */
{
  goto_origin(i);

  /* goto begin text */
  CursorMove(CurFORWARD, prompt_len);
}

void
goto_pos(i, len)
     int    i;	/* current position */
     int  len;	/* target  position */
{
  int             pos = prompt_len + len;
  goto_origin(i);

  /* set  cursor position */
  i = pos / COLUMNS;
  while (i-- > 0)
    CursorMove(CurINDEX,0);
  i = pos % COLUMNS;
  if (i != 0)
    CursorMove(CurFORWARD, i);
}

void
move_to_eos()
{
  /* move to end of string */
  goto_pos(I, END_POS);
  flush();
}


void
forward(i)
     int  i;
{
  int   pos = prompt_len + i;
  if ((pos % COLUMNS) == 0) {
    CursorMove(CurINDEX,0);
    CursorMove(CurBEGIN_LINE,0);
  } else
    CursorMove(CurFORWARD, 1);
}

void
backward(i)
     int             i;
{
  int             pos = prompt_len + i;
  if ((pos % COLUMNS) == 0) {
    CursorMove(CurREV_INDEX,0);
    CursorMove(CurEND_LINE,0);
  } else
    CursorMove(CurBACKWARD, 1);
}

void
clear_forward(i, end)
     int             i, end;
{
  int             n, pos, pos2, lines;

  pos = prompt_len + i;
  pos2 = prompt_len + end - 1;
  lines = (pos2 / COLUMNS) - (pos / COLUMNS);
  ClearText(ClrFORWARD);
  if (lines == 0)
    return;

  CursorPush();
  for (n = 0; n < lines; n++) {
    CursorMove(CurINDEX,0);
    CursorMove(CurBEGIN_LINE,0);
    ClearText(ClrFORWARD);
  }
  CursorPop();
}

void
del_backward(cp, back)
     int             cp, back;
{
  int             pos = cp - back;
  goto_pos(cp, pos);
  clear_forward(pos, END_POS);
}

void
clear_lines(i)
     int             i;
{
  int             pos = prompt_len + i;
  int             n = pos / COLUMNS;

  while (n-- > 0) {
    CursorMove(CurBEGIN_LINE,0);
    ClearText(ClrFORWARD);
    CursorMove(CurUP, 1);
  }
  CursorMove(CurBEGIN_LINE,0);
  ClearText(ClrFORWARD);
  prompt(1, NULL, -1);
}

void
clear_nextline()
{
  CursorPush();
  CursorMove(CurINDEX,0);
  CursorMove(CurBEGIN_LINE,0);
  ClearText(ClrFORWARD);
  CursorPop();
}

/* RETSIGTYPE */
static void
chwin()
{
  int columns;

  /* for Resize Window */
  GetSize(&LINES, &columns);
  if (columns != COLUMNS) {
    goto_pos(I, END_POS);
    clear_lines(END_POS);
    COLUMNS = columns;
    xprintf("%s", STR);
    goto_pos(END_POS - 1, I);
    flush();
  }
}

Key
getcon(str, lock, ipos)
     char           *str;
     int             lock, ipos;
{
  char            c, dum;
  int             i = ipos, j ;
  Toggle          escape = OFF;
  Key             code = ASCII;
  BOOLEAN         insert_mode = FALSE;
  RETSIGTYPE      (*istat) () =
    (RETSIGTYPE (*) ()) signal(SIGINT, (RETSIGTYPE (*)()) intcatch);

  STR = str;			/* for chwin() */
  
  goto_pos(strlen(str), ipos);	/* goto_pos(current_pos, target_pos) */

  
  /***** Change Terminal Input Mode *****/
  pushConsoleIO();
  GetSize(&LINES, &COLUMNS);
  signal(SIGWINCH, (RETSIGTYPE (*)()) chwin);
  
  do {
    flush();
    
    /* GLOBAL VALIABLES I & END_POS */
    I = i;
    END_POS = strlen(str);
    
    c = getc(stdin);
    if (!isprint(c))		/* */
      insert_mode = TRUE;
    
    switch (c) {
      
    case EOF:			/* End Of File  */
    case NL:			/* New Line     */
    case CR:			/* [RETURN] KEY */
      escape = ON;
      break;
      
    case BS:			/* backspace */
      if ( i <= lock ) {
	code = BS;
	escape = ON;
	break;
      }
      
      /*
	 if (i <= lock)
	 break;
	 */
      
      goto_begin(i);
      deletec(str, --i);
      xprintf("%s ", str);
      goto_pos(strlen(str), i);
      break;
      
    case CTL_A:			/* goto begin of line */
      goto_pos(i, lock);
      i = lock;
      break;
      
    case CTL_B:			/* move backward */
      if (i <= lock)
	break;
      backward(i--);
      break;
      
    case CTL_C:			/* interrupt */
    case CTL_G:			/* quit parameter input mode */
      code = QUIT;
      escape = ON;
      break;
      
    case CTL_D:			/* end of line & delete charactor */
      if (*str == '\0') {	/* end of file */
	str[0] = EOF, str[1] = '\0';
	code = QUIT;
	escape = ON;
	break;
      } else if (str[i] == '\0') {
	xprintf("\n");
	ls(str);
	/* reprint : lineno = -1 */
	prompt(1, NULL, -1);
	xprintf("%s", str);
	goto_pos(strlen(str)-1,strlen(str));
	break;
      }
      /* Throuth a 'case DEL' */
      
    case DEL:			/* delete charactor */
      if (str[i] != '\0') {	/* delete charactor */
	goto_begin(i);
	deletec(str, i);
	xprintf("%s ", str);
	goto_pos(strlen(str), i);
      }
      break;
      
    case CTL_E:			/* goto end of line */
      goto_pos(i, END_POS);
      i = strlen(str);
      break;
      
    case CTL_F:			/* move forward */
      if (i >= END_POS)
	break;
      forward(++i);
      break;
      
    case CTL_K:			/* Search for Keywords */
      strcpy(COPY_BUFFER, &str[i]);
      clear_forward(i, END_POS);
      str[i] = '\0';
      break;
      
    case CTL_L: /* take */
      goto_begin(i);
      xprintf("%s ", str);
      goto_pos(strlen(str), i);
      break;
      
    case CTL_N:			/* next history */
      code = NEXT;
      escape = ON;
      break;
      
    case CTL_P:			/* prev. history */
      code = PREV;
      escape = ON;
      break;

    case CTL_T:                 /* tcsh like. by okumura */
      if( END_POS > 1 && i > 0){
	char tmp;
	j=i;
	if(i == END_POS)  j--;
	tmp=str[j-1];
	str[j-1]=str[j];
	str[j]=tmp;
	goto_begin(i);
	i=j+1;
	xprintf("%s",str);
	goto_pos(strlen(str)-1,i);
      }
      break;

    case CTL_W:			/* Search for Keywords */
      if (i != END_POS)
	sl_beep(2, 1);
      else
	i = fullkeyword(str);
      break;
      
    case CTL_Y:			/* yank copy buffer */
      j = strlen(COPY_BUFFER);
      if ( j+END_POS < ONELINE ) {
	catstr(COPY_BUFFER,str+i);
	goto_begin(i);
	i+=j;
	xprintf("%s",str);
	goto_pos(strlen(str)-1,i);
      }
      break;

    case TAB:			/* search for file name */
      if (i != END_POS)
	sl_beep(2, 1);
      else
	i = fullname(str);
      break;
      
    case ESC:			/* ESC + @ */
      if ((dum = getc(stdin)) != 0x5b) {
	/* DOUBLE ESC : ESC + ESC */
	if (dum == ESC) {
	  if (i != END_POS)
	    sl_beep(2, 1);
	  else
	    i = fullname(str);
	}
	/* ANOTHER KEY ---> IGNORED */
	/* ESC + !0x5b */
      } else
	escape = functionkey(lock, &i, &code);
      break;
      
    default:			/* print type-charactor */
      if (isprint(c) && END_POS < ONELINE - 1) {
	if (insert_mode == TRUE && i != END_POS) {
	  goto_begin(i);
	  insertc(str, i++, c);
	  xprintf("%s", str);
	} else {
	  str[i++] = c;
	  str[i] = '\0';
	  xprintf("%c", c);
	}
	goto_pos(strlen(str)-1, i);
      }
      break;
    }
    
    
  } while (escape != ON);
  
  /* move to end of string */
  goto_pos(i, strlen(str));
  flush();
  
  /***** Restore Terminal Input Mode *****/
  popConsoleIO();
  signal(SIGWINCH, SIG_DFL);
  signal(SIGINT, istat);
  
  return (code);
}
