/******************************************************************
**                                                               **
**      File Name : search.c                                     **
**                                                               **
**                Console Input Procedure                        **
**                  ( Using ANSI ESC )                           **
**           ( This procedure is 4.xBSD & System V. )            **
**                                                               **
**      TEST PROGRAM:                                            **
**             cc (-DBSD) -DTEST key.c cursor.c file.c util.c    **
**	INCLUDE FILE :  cursor.h defs.h 			 **
**                                                               **
**                                      Coded by S.Hitomi        **
**                                                               **
******************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "defs.h"
#include "prototype.h"
#include "cursor.h"

extern char     PATH[ONELINE];

/************************************************************
 *                 Filename Processing                      *
 ************************************************************/
#define FIRST		1
#define CONTINUE	0
/* #define ARG		20 */


int
cut_of_last_part(str, path)
     char  *str, *path;
{
  int       len, n = 0, org;
  char      c, *argv[ARG], tmp[ONELINE];

  org = strlen(str);
  if (org >= ONELINE)
    execerror("too long string for keybuffer", NULL);
  strcpy(tmp, str);
  if (org == 0 || isspace(c = str[org - 1]) ||
      c == '=' || c == '\"' || c == '(') {
    strcpy(path, "");
    len = 0;
  } else if ((n = separate(tmp, argv, ARG, " \t=\"(")) > 0) {
    /* last-part into 'path' */
    len = strlen(strcpy(path, argv[n - 1]));
    del_backward(org, len);
    /*
     * CursorMove(BACKWARD, len); ClearText(ClrFORWARD);
     */
  } else
    return -1;

  str[org - len] = '\0';	/* cut of last part */

  return n;
}

int
is_oneword(path)
     char           *path;
{
  BOOLEAN         bool;
  char            tmp[ONELINE], *argv[ARG];

  strcpy(tmp, path);
  bool = (*path != '/' && path[strlen(path) - 1] != '/');
  return bool && separate(tmp, argv, ARG, "/") == 1;
}


int
fullname(str)
     char           *str;
{
  static int      len_bak, npath, total_path;
  static BOOLEAN  one_word;
  static char     tmp[ONELINE], *argv[ARG];
  int             len, number_of_part;
  char           *searchpath = NULL;
  char            filename[FILE_LENGTH], workspace[FILE_LENGTH];
  char           *path = filename, *work = workspace;
  BOOLEAN         status, inode;

  number_of_part = cut_of_last_part(str, path);
  if (number_of_part == -1)
    return strlen(str);
  len = strlen(path);

  if (len == 0) {
    if (one_word) {
      searchpath = argv[npath = 0];
    } else
      strcpy(path, "./");
  }
  status = (len == len_bak) ? CONTINUE : FIRST;
  if (status == FIRST) {
    one_word = is_oneword(path) && (number_of_part == 1);
    if (one_word) {
      strcpy(tmp, PATH);
      total_path = separate(tmp, argv, ARG, ":\t ");
      searchpath = argv[npath = 0];
    }
  }

  if (one_word) {
    inode = 0;
    while (inode == 0 && npath < total_path) {
      searchpath = argv[npath];
      /* test for presence of file */
      if (access(searchpath, 0) == 0) {
	sprintf(work, "%s/%s", searchpath, path);
	inode = filesearch(work, status);
      } else {
	*work = '\0';
	inode = 0;
      }

      if (inode == 0)
	npath++;
    }
    if (*work != '\0' && inode != 0 ) {
      /* +1 : for slash */
      path = work + strlen(searchpath) + 1;
    } /* else
	 path = ""; */ /* take */
  } else {
    filesearch(path, status);
    if (len == 0)
      path += strlen("./");
  }

  strcat(str, path);		/* append of last part */
  xprintf("%s", path), flush();
  len_bak = strlen(path);

  /* return full path-name length */
  return strlen(str);
}


int
fullkeyword(str)
     char  *str;
{
  static int      len_bak;
  static char     seed[FILE_LENGTH];
  int             len, number_of_part;
  char            keywd[FILE_LENGTH], *p;
  BOOLEAN         status;

  number_of_part = cut_of_last_part(str, keywd);
  if (number_of_part == -1)
    return strlen(str);

  if ((len = strlen(keywd)) == 0)
    return strlen(str);

  status = (len == len_bak) ? CONTINUE : FIRST;
  if (status == FIRST) {
    strcpy(seed, keywd);
  }
  p = keyword_search(seed, status);
  if (p != NULL)
    strcpy(keywd, p);
  else
    strcpy(keywd, seed);

  xprintf("%s", keywd), flush();
  strcat(str, keywd);
  len_bak = strlen(keywd);

  /* return full keyword-name length */
  return strlen(str);
}


void
ls(str)
     char  *str;
{
  int	n;
  char  c, *argv[ARG], tmp[ONELINE], cmd[ONELINE];

  strcpy(tmp, str);
  c = tmp[strlen(tmp) - 1];
  if (c == ' ') {
    strcpy(cmd, "ls -CF");
  } else if ((n = separate(tmp, argv, ARG, " \t=\"(")) > 0) {
    if(c == '/')
      sprintf(cmd, "ls -CF %s", argv[n - 1]);
    else {
      sprintf(cmd, "ls -CFd %s*", argv[n - 1]); 
    }
  }
  flush();
  system(cmd);
}
