#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "defs.h"
#include "prototype.h"

#define BELL	0x07
#define ESC	0x1b
#define CTL_M	0x0d


typedef char   *pointer;

extern int      errno;

#if defined(HAVE_DECL_SYS_NERR) && !HAVE_DECL_SYS_NERR
extern int sys_nerr;
#endif

#ifdef HAVE_STRERROR
#if defined(sun) && !defined(SOLARIS)
/* SunOS 4.1.3_U1 doesn't have strerror().  Use sys_errlist
 * instead. */
#undef HAVE_STRERROR
#endif
#endif

#ifndef HAVE_STRERROR
extern const char *const sys_errlist[];
# define strerror(x) (sys_errlist[x])
#endif

void
xtitle(icon, tbar)
	char           *icon, *tbar;
{
  if ( getenv("SL_FIXED_TITLE") == NULL ) {
    if (icon != NULL)
      printf("%c]1;%s%c", ESC, icon, BELL);
    if (tbar != NULL)
      printf("%c]2;%s%c", ESC, tbar, BELL);
    fflush(stdout);
  }
}


void
syserr(msg)
	char           *msg;
{
	fprintf(stderr, "ERROR: %s (%d", msg, errno);
	if (errno > 0 && errno < sys_nerr)
		fprintf(stderr, "; %s)\n", strerror(errno));
	else
		fprintf(stderr, ")\n");
	exit(1);
}
