/**********************************************************************
        path.c : Parts of Utility 
			(UNIX parts)

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/

#include <stdio.h>
#include <string.h>
#include <pwd.h>

#include "defs.h"

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "prototype.h"

#ifndef TRUE
#define TRUE		(1)
#define FALSE		(0)
#endif

#define PROGNAME	"SATELLITE Language"
/* #define equal(a,b)	!strcmp(a,b) */


/*******************************************************************/
#define	 NAMELEN 64

#define PARTS	2

static char   *term = NULL;
static char    home_dir[PATHLEN];
static char    hostname[NAMELEN];
static char    username[NAMELEN];

char           current_dir[PATHLEN];
char          *cwd;
char           PATH[ONELINE];
/*******************************************************************/

static char   *
partof(path)
     char           *path;
{
  char           *p, *tail = &path[strlen(path) - 1];
  short           cnt = PARTS;

  for (p = tail; p > path; --p) {
    if (*p == '/')
      if (--cnt == 0)
	return p + 1;
  }
  return p;
}

static void
putpwd()
{
  static char    *pwd = NULL;

  if (pwd != NULL)
    efree(pwd);
  pwd = (char *) malloc(strlen(current_dir) + 5); /* +5 for "PWD=" */
  if (pwd == NULL) {
    perror("failed to set PWD");
    return;
  }
#ifdef HAVE_PUTENV
  strcpy(pwd, "PWD=");
  strcat(pwd, current_dir);
  if (putenv(pwd) != 0)
    perror("<<SL:Error>> Environment Value Can't Set.");
#else
  strcpy(pwd, current_dir);
  if (setenv("PWD", current_dir, 1) != 0)
    perror("<<SL:Error>> Environment Value Can't Set.");
#endif

  change_xtitle();
}


int
change_xtitle()
{
  static char  *title = NULL;
  static char  *icon  = NULL;

  if (term == NULL) {
    if((term = getenv("TERM")) == NULL)
      return FALSE;
  }

  if (!equal(term, "xterm") && 
      !equal(term, "kterm") && 
      !equal(term, "DECterm") &&
      !equal(term, "tigr40"))
    return FALSE;

  if (title != NULL) efree(title);
  if (icon  != NULL) efree(icon);

  title = (char*)emalloc(strlen(PROGNAME)+strlen(hostname)
			+strlen(current_dir)+7);
  icon  = (char*)emalloc(strlen(username)+strlen(hostname)+12);
  
  if (title != NULL)
    sprintf(title, "%s:  %s ! %s", PROGNAME, hostname, current_dir);
  if (icon != NULL)
    sprintf(icon, "%s@%s-SATELLITE",  username, hostname );
  xtitle(icon, title);

  return TRUE;
}

int
free_xtitle()
{
  char            *title = NULL;
  char            *icon  = NULL;

  if(term == NULL)
    return FALSE;
  if (!equal(term, "xterm"  ) && 
      !equal(term, "kterm"  ) && 
      !equal(term, "DECterm") &&
      !equal(term, "tigr40" ))
    return FALSE;

  title = (char*)malloc(strlen(hostname)+strlen(term)+3);
  icon  = title;

  if (title != NULL) {
    sprintf(title, "%s: %s", hostname, term);
    xtitle(icon, title);
    efree(title);
  }
  return TRUE;
}

int
init_path()
{
  char           *path, *getenv();

  gethostname(hostname, NAMELEN);
  getusername(username, NAMELEN);

#ifdef HAVE_GETCWD
  if(getcwd(home_dir,sizeof(home_dir)-1) == NULL)
    return -1;
#else
  if(getwd(home_dir) == NULL)
    return -1;
#endif
  home_dir[sizeof(home_dir)-1] = '\0';
  strcpy(current_dir, home_dir);

  cwd = partof(current_dir);
  putpwd();			/* putenv() or setenv() system call */

  path = getenv("PATH");
  if (path == NULL)
    strcpy(PATH, ".:/bin");
  else
    strncpy(PATH, path, sizeof(PATH) - 1);
  return 0;
}


int
change_dir(argv)
     char           *argv[];
{
  if (argv[0] == NULL)
    return (0);

  /* Internal Command */
  if (equal(argv[0], "cd")) {

    if (argv[1] == NULL && chdir(home_dir) == 0) {
      strcpy(current_dir, home_dir);
      cwd = partof(current_dir);
    } else if (chdir(argv[1]) == 0) {
#ifdef HAVE_GETCWD
      if(getcwd(current_dir,sizeof(current_dir)-1) == NULL)
	return (-1);
#else
      if(getwd(current_dir) == NULL)
	return (-1);
#endif
      cwd = partof(current_dir);
    } else {
      puts("  Faild to change directory");
      return (-1);
    }

    /***** Setting Environment Value *****/
    putpwd();
    return (1);
  }
  return (0);
}
/**********************************************************************
	End of Stack Machine Code (UNIX parts)
***********************************************************************/
