/**********************************************************************
        pipe.c : Parts of Utility for SATELLITE-LANGUAGE
			(UNIX parts)

			Coded by Shigeru Hitomi  Sep. 23, 1992
***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include "defs.h"
#include "prototype.h"

#define BEGIN	0
#define IN	1

#ifdef  Bzero
#undef  Bzero
#endif

#ifdef HAVE_MEMSET
#define Bzero(buf, siz) memset((char *)(buf), 0, siz)
#else
#define Bzero(buf, siz) bzero((char *)(buf), siz)
#endif

/* added by take */
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if 0
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
#ifdef HAVE_VFORK
#define FORK_FUNC vfork()
#define FORK "vfork"
#else
#define FORK_FUNC fork()
#define FORK "fork"
#endif
#else
#define FORK_FUNC fork()
#define FORK "fork"
#endif

#if 0
main(argc, argv)
char          **argv;
{
  int             in, pid;
  in = pipeline(argv + 1, BEGIN, 1);
  close(in), dup(0);
  while ((pid = wait(0)) != -1);
}
#endif


#if 0
main(argc, argv)
char          **argv;
{
  int             out, in = 1, pid;
  char            c;

  argv++;
  if (*argv == NULL)
    goto END;
  fprintf(stderr, "[%s] | ", *argv);
  in = mkpipe(*argv++, in);
  if (*argv == NULL)
    goto END;
  fprintf(stderr, "[%s] | ", *argv);
  in = mkpipe(*argv++, in);
  if (*argv == NULL)
    goto END;
  fprintf(stderr, "[%s] | ", *argv);
  in = mkpipe(*argv++, in);
  if (*argv == NULL)
    goto END;
  fprintf(stderr, "[%s] | ", *argv);
  in = mkpipe(*argv++, in);
END:
  close(1), dup(in), close(in);
  while ((c = getchar()) != EOF)
    putchar(c);
  fflush(stdout);
  close(1);
  while ((pid = wait(0)) != -1);
}
#endif

#if 0
int
pipeline(argv, out)
     char  **argv;
     int     out;
{
#ifdef CORE
  char **p;
  fprintf(stderr,"in pipeline:");
  for ( p = argv; *p != NULL; p++ )
    fprintf(stderr,"[%s]",*p);
  fprintf(stderr,"\n");
#endif
/*
  return (*argv == 0) ? out : mkpipe(*argv, pipeline(argv + 1, out));
*/

  return (*argv == NULL) ? out : mkpipe(*argv);
}
#endif

int
mkpipe(bin)
     char  *bin;
{
  int             pfd[2];
  RETSIGTYPE  (*istat) (), (*qstat) (), (*tstat) ();
  
  if(*bin == '\0' || internal(bin))
    return 0;

  istat = (RETSIGTYPE (*) ()) signal(SIGINT,  SIG_IGN);
  qstat = (RETSIGTYPE (*) ()) signal(SIGQUIT, SIG_IGN); /* take */
  tstat = (RETSIGTYPE (*) ()) signal(SIGTERM, SIG_IGN); /* take */

  pipe(pfd);
  switch (FORK_FUNC) {
  case -1:
    signal(SIGINT, istat);
    signal(SIGQUIT, qstat); /* take */
    signal(SIGTERM, tstat); /* take */

    perror("fork failed");

    return -1;	/* stdout */
  case 0:	/* child process */
    
#ifdef CORE
    fprintf(stderr,"%sed in mkpipe,", FORK);
    fprintf(stderr,"execute >> %s\n",bin);
#endif
    close(0), dup(pfd[0]);
    close(pfd[0]), close(pfd[1]);

    signal(SIGINT,  SIG_DFL); /* take */
    signal(SIGQUIT, SIG_DFL); /* take */
    signal(SIGTERM, SIG_DFL); /* take */

    execlp("/bin/sh", "sh", "-c", bin, (char *)0);
    perror("failed to execute child");
    _exit(0); /* take */
  default: /* parent process */
    signal(SIGINT, istat);
    signal(SIGQUIT, qstat); /* take */
    signal(SIGTERM, tstat); /* take */
    break;
  }
  close(pfd[0]);

  return pfd[1];
}


#define ERROR() {efree(str); str = 0; n = 0; total = -1;}
char    *
readpipe(fd)
     int	fd;
{
/*  char           *malloc(), *realloc(); */
  int             n, total = 0, len = 0;
  char            buf[BUFSIZ + 1];
  char           *str = NULL;

  do {
    Bzero(buf, BUFSIZ + 1);
    switch (n = read(fd, buf, BUFSIZ)) {
    case 0:
      break;
    case -1:
      ERROR();
      break;
    default:
#if 0
      total += n;
      tmp = (str == 0) ? malloc(total) : realloc(str, total);
      if (tmp != NULL) {
	Bzero(tmp + total - n, n);
	str = tmp;
	strcat(str, buf);
      } else
	ERROR();
#else
      total += n;
      if ( str == NULL ) {
	len = BUFSIZ;
	str = emalloc(len+1);
	*str = '\0';
      } else {
	if ( len < total ) {
	  len += BUFSIZ;
	  str = erealloc(str, len+1);
	}
      }
      if ( str != NULL)
	strcat(str,buf);
      else
	ERROR();
#endif
      break;
    }
  } while (n != 0);
  return str;
}

#define ERROR() {efree(str); str = 0; n = 0; total = -1;}
char    *
pread_sl(pfd)
     int             pfd[];
{
  int             n, total = 0, len = 0;
  char            buf[BUFSIZ + 1];
  char           *str = NULL;
#if 0
  char           *tmp = NULL;
#endif

  if (close(pfd[1]) == -1)
    perror("close");
  do {
    Bzero(buf, BUFSIZ + 1);
    switch (n = read(pfd[0], buf, BUFSIZ)) {
    case 0:
      break;
    case -1:
      ERROR();
      break;
    default:
      total += n;
      if ( str == NULL ) {
	len = BUFSIZ;
	str = emalloc(len+1);
	*str = '\0';
      } else {
	if ( len < total ) {
	  len += BUFSIZ;
	  str = erealloc(str, len+1);
	}
      }
      if ( str != NULL)
	strcat(str,buf);
      else
	ERROR();
      break;
    }
  } while (n != 0);
  if (close(pfd[0]) == -1)
    perror("close");
  return str;
}
