#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "defs.h"

#ifndef TRUE
#define TRUE	(1)
#define FALSE	(0)
#endif
#define BELL	0x07
#define ESC	0x1b
#define CTL_M	0x0d

#ifndef HAVE_STRCHR
#define strchr(s,c)     index(s,c)
extern char    *index();	/* 'strchr()' in some systems */
#endif


typedef char   *pointer;


int
argcount(sbuf, separator)
     char  *sbuf, *separator;
{
  register char  *p;
  register int    n;

  if (*sbuf == '\0')
    return 0;

  n = (strchr(separator, *sbuf) != NULL) ? -1 : 0;

  p = sbuf;
  while (*p != '\0') {
    if (strchr(separator, *p) != NULL) {
      n++;
      while (*p != '\0' && strchr(separator, *p) != NULL) 
        p++;
      continue;
    }
    if (*p == '"') {
      while (*++p != '"' && *p != '\0') /* quoted_string skip */ ;
      if (*p == '\0')
        return n + 1;
    }
    p++;
  }

  if (strchr(separator, sbuf[strlen(sbuf)-1]) != NULL)
    return n;
  return n + 1;
}


char *
nextarg(sbuf, separator)
    char           *sbuf, *separator;
{
  register int    i;
  register char  *p;
  
  for (p = sbuf; *p != '\0'; p++) {
    for (i = 0; separator[i] != 0; i++) {
      if (*p == separator[i])
	return p + 1;
    }
    if (*p == '"') {
      while (*++p != '"' && *p != '\0')
	/* quoted_string skip */ ;
    }
  }
  return NULL;
}


int
splits( sbuf, argv, argc )
    char *sbuf, **argv;
    int argc;
{
  int inBrace = 0;
  int n = 0, flag = 0;
  char *str = sbuf, *endpos;

  if ( sbuf != NULL ) {

#ifdef CORE
    printf("\nsplits[%s]\n",sbuf);
#endif

    endpos = sbuf+strlen(sbuf)+1;
    while( str < endpos && inBrace >= 0 && n < argc) {
      if ( isspace(*str) && flag == 0 ) {
	str++;
	continue;
      }
      if ( flag == 0 ) {
	argv[n++] = str;
	flag = 1;
      }
      switch(*str) {
      case ' ':
	*(str++) = '\0';
	break;
      case '(':
	inBrace++;
	str++;
	break;
      case ')':
	inBrace--;
	if ( inBrace < 0 )
	  *str = '\0';
	str++;
	break;
      case '"':
	for ( ++str; *str != '"' && str < endpos ; str++ );
	if ( str < endpos )
	  str++;
	break;
      case ',':
	if ( inBrace == 0 ) {
	  *str = '\0';
	  flag = 0;
	}
	str++;
	break;
      default:
	str++;
      }
    }
  }
  argv[n] = NULL;
  return n;
}


int
separate(str, argv, argc, separator)
	char           *str, **argv, *separator;
	int             argc;
{
	register int    i;

	/*
	 * if separator = ',' then  "A,B,C" ----> "A", "B", "C"
	 */
	for (i = 0; i < argc; i++) {
		argv[i] = NULL;
		if ((argv[i] = strtok(str, separator)) == NULL)
			break;
		str = NULL;
	}
	return (i);
}
