#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "defs.h"

#define BELL	0x07
#define ESC	0x1b
#define CTL_M	0x0d

char *
rmnl(str)
     char *str;
{
  int  tail;

  if(str == NULL)
    return NULL;
  tail = strlen(str) - 1;

  if ( tail >= 0 && str[tail] == '\n')
    str[tail] = '\0';
  return str;
}


void
tolowers(str)
     char  *str;
{
  register char  *p;

  for (p = str; *p != '\0'; p++)
    *p = isupper(*p) ? tolower(*p) : *p;
}

void
touppers(str)
     char  *str;
{
  register char  *p;

  for (p = str; *p != '\0'; p++)
    *p = islower(*p) ? toupper(*p) : *p;
}



int
any(s, c)
     register char  *s;
     register int    c;
{
  if (!s)
    return (0);			/* Check for nil pointer */
  while (*s)
    if (*s++ == c)
      return (1);
  return (0);
}


char *
strsft(str, sft)
     char *str;
     int   sft;
{
  register int    i;

  if (sft > 0) {
    for (i = strlen(str); i >= 0; --i)
      str[i + sft] = str[i];
  } else {
    for (i = 0; i <= strlen(str); i++)
      str[i + sft] = str[i];
  }

  return (str);
}

char *
catstr(str2, str1)
     char *str2, *str1;
{
  register int    i, sft;

  sft = strlen(str2);
  strsft(str1, sft);

  for (i = 0; i < sft; i++)
    str1[i] = str2[i];
  return (str1);
}

char *
insertc(str, pos, c)
     char *str, c;
     int   pos;
{
  register int    i;

  for (i = strlen(str); i >= pos; --i)
    str[i + 1] = str[i];

  str[pos] = c;
  return str;
}

char *
deletec(str, pos)
     char *str;
     int   pos;
{
  register int    i, len = strlen(str);

  for (i = pos; i < len; i++)
    str[i] = str[i + 1];

  return str;
}

/* * * * * * * * */


/* a ---> b */
char *
replace(str, a, b)
     char *str, *a, *b;
{
  char *ptr = str;
  int   alen, blen, i;

  alen = strlen(a);
  blen = strlen(b);

  while (*str != '\0') {
    if (!strncmp(str, a, alen)) {
      strsft(str + alen, strlen(b) - alen);
      for (i = 0; i < blen; i++)
	*str++ = b[i];
    }
    str++;
  }

  return (ptr);
}


char *
concat(argv, str, c)
     char  **argv, *str, c;
     /* Not *argv == str */
{
  register int    i;
  char            ch[2];

  ch[0] = c;
  ch[1] = *str = '\0';
  for (i = 0; argv[i] != NULL; i++) {
/*
    if (*str != '\0')
      (c != '\0') ? strcat(str, ch) : str;
*/
    if (( *str != '\0' ) && (c != '\0'))
      strcat(str, ch);
    strcat(str, argv[i]);
  }
  return (str);
}
