/**********************************************************************
        unix.c : Parts of Stack Machine Code
			(UNIX parts)

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#include "defs.h"

/*
 * Safer version of system for interactive programs
 */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#if 0
#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
#ifdef HAVE_VFORK
#define FORK_FUNC vfork()
#define FORK "vfork"
#else
#define FORK_FUNC fork()
#define FORK "fork"
#endif
#else

#define FORK_FUNC fork()
#define FORK "fork"

#endif

#include "prototype.h"

#ifndef X_OK
#define X_OK    1/* test for execute (search) permission */
#endif

#ifndef TRUE
#define TRUE            (1)
#define FALSE           (0)
#endif

#ifdef MAX_ARG
#undef MAX_ARG
#endif
#define MAX_ARG         ARG

int             tty = -1;
extern char	PATH[];

int
opentty()
{
  extern char    *progname;
  char           *tty_name;
  tty_name = (char *) ttyname(1);	/* ttyname(1) : /dev/ttyp? */
  if ((tty = open(tty_name, 2)) != -1)
    return tty;
  
  tty_name = "/dev/tty";
  if ((tty = open(tty_name, 2)) != -1)
    return tty;
  
  /* if could not get tty device, sl is running in non-interactive mode. */
  /* fprintf(stderr, "%s, can't open %s\n", progname, tty_name); */
  return -1;
}


char *
intersh(s, usepipe)
    char *s;
    int usepipe;
{
  RETSIGTYPE  (*istat)(), (*qstat)(), (*tstat)();
  int   pfd[2];
  int   status, pid, w;
  char *str = NULL;
  
  if (*s == '\0' || internal(s))
    return 0;
  if (tty == -1)
    opentty();
  if(usepipe)
    if (pipe(pfd) == -1) {
      perror("broken pipe");
      return NULL;
    }
  fflush(stdout);
  
  istat = (RETSIGTYPE (*) ()) signal(SIGINT,  SIG_IGN);
  qstat = (RETSIGTYPE (*) ()) signal(SIGQUIT, SIG_IGN); /* take */
  tstat = (RETSIGTYPE (*) ()) signal(SIGTERM, SIG_IGN); /* take */
  
  switch ( pid = FORK_FUNC ) {
  case -1:		/* fork system-call error */
    signal(SIGINT, istat);
    signal(SIGQUIT, qstat);
    signal(SIGTERM, tstat);

    perror("fork failed");
    return NULL;
  case 0:		/* Child Process */
#ifdef CORE
    fprintf(stderr,"%sed in intersh >> ", FORK);
    fprintf(stderr,"%s\n",s);
    fflush(stderr);
#endif
    if(usepipe)
      close(pfd[0]);
    close(0), dup(tty);
    close(1), (usepipe ? dup(pfd[1]) : dup(tty));
    close(2), dup(tty); close(tty);
    
    signal(SIGINT,  SIG_DFL); /* take */
    signal(SIGTERM, SIG_DFL); /* take */
    signal(SIGQUIT, SIG_DFL); /* take */
    
    execlp("/bin/sh", "sh", "-c", s, (char *) 0);
    perror("failed to execute child");
    _exit(0); /* take */
  default:		/* Parent Process */
    break;
  }
  
  if(usepipe)
    str = pread_sl(pfd);	/* pipe reading */

  while ((w = wait(&status)) != pid && w != -1)
    /* nothing */ ;

  if (w == -1)
    status = -1;
  
  /* restore old signal */
  signal(SIGINT,  istat);
  signal(SIGQUIT, qstat); /* take */
  signal(SIGTERM, tstat); /* take */
  
  return rmnl(str); /* remove newline */
}


int
internal(cmd_ptr)
    char           *cmd_ptr;
{
  char           *argv[MAX_ARG + 1];
  char            tmp[ONELINE];
  
#ifdef DEBUG
  fprintf(stderr,"internal: [%s]\n", cmd_ptr);
#endif

  tmp[ONELINE-1] = '\0';
  strncpy(tmp, cmd_ptr,ONELINE-1);
  separate(tmp, argv, MAX_ARG, " \n");
  
  return change_dir(argv) != 0;
  /* -1, 1 ----> TRUE  */
  /* 0     ----> FALSE */
}


int
executable(cmd)
    char	*cmd;
{
  register int	i;
  int		siz = strlen(cmd) + 1;
  char          tmp[ONELINE], *argv[128], path[FILE_LENGTH];
  
  if(equal(cmd, "cd"))
    return TRUE;
  
  strcpy(tmp, PATH);
  separate(tmp, argv, 127, ":");
  argv[127] = NULL; /* for fail-safe */

  for(i = 0; argv[i] != NULL; i++) {
    if((siz + strlen(argv[i]) + 1) >= FILE_LENGTH)
      continue;

    sprintf(path, "%s/%s", argv[i], cmd);
    if(access(path, X_OK) == 0)
      return TRUE;
  }
  return FALSE;
}
/**********************************************************************
	End of Stack Machine Code (UNIX parts)
***********************************************************************/
