
#include "defs.h"

#include <stdio.h>
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#define MAX_SIG 19
#define lowbyte(w)	((w) & 0377)
#define highbyte(w)	lowbyte((w) >> 8)
#if defined(vax)
#define ReturnCode(w)	((w) & 0x00ff)
#endif
#if defined(titan) || defined(luna88k) || defined(mc68000) || \
    defined(sparc) || defined(hpux)
#define ReturnCode(w)	(((w) & 0xff00) >> 8)
#endif
#if defined(__alpha) || defined(__i386__) || defined(__i486__)
#define ReturnCode(w)	(((w) & 0xff00) >> 8)
#endif

#ifndef ReturnCode
#define ReturnCode(w) (((w) & 0xff00) >> 8)
#endif

int
statusprt(pid, status)
     int             pid, status;
{
  int             code = 0;
  static char    *sigmsg[] = {
    "",
    "Hangup",
    "Interrupt",
    "Quit",
    "Illegal instruction",
    "Trace trap",
    "IOT instruction",
    "EMT instruction",
    "Floating point exception",
    "Kill",
    "Bus error",
    "Segmentation violation",
    "Bad arg to system call",
    "Write on pipe",
    "Alarm clock",
    "Terminate signal",
    "User signal 1",
    "User signal 2",
    "Death of child",
    "Power fail"
  };


#ifdef DEBUG
  fprintf(stderr,"code = %d, %x\n", status, status);
#endif

  if (status != 0 && pid != 0)
    fprintf(stderr, "Process %d: ", pid);
  if (lowbyte(status) == 0) {
    /*
       if ((code = highbyte(status)) != 0)
       fprintf(stderr, "Exit code %d\n", code);
       */
  } else {
    if ((code = (status & 0177)) <= MAX_SIG)
      fprintf(stderr, "%s", sigmsg[code]);
    else
      fprintf(stderr, "Signal #%d", code);
    if ((status & 0200) == 0200)
      fprintf(stderr, "-core dumped");
    fprintf(stderr, "\n");
  }
  return code;
}


int
waitfor(pid)
     int  pid;
{
  int   wpid, code = 0;
  int	status = 0;

  while ((wpid = wait(&status)) != pid && wpid != -1)
    code = statusprt(wpid, status);

  if (wpid == pid)
    code = statusprt(0, status);

  fflush(stderr);
  return (code != 0) ? -code : (int)ReturnCode(status);
}
