/*******************************************************************
        comment.c :  Comment Out Procedure

                                Coded by Shigeru Hitomi
                                Last Modified at Mar, 7, 1993
*******************************************************************/


/*******************************************************************
	INCLUDE FILES
*******************************************************************/
#include <ctype.h>
#include "defs.h"
#include "stream.h"
#include "prototype.h"

/*******************************************************************
	DIFINITIONS
*******************************************************************/
#define BELL	0x07

/*******************************************************************
	PRIVATE PROTOTYPES
*******************************************************************/
static int      c_like_comment _ANSI_ARGS_((void));

/*******************************************************************
 	GLOBAL VARIABLES
*******************************************************************/
short int       in_comment = 0;

/*******************************************************************
	FUNCTIONS
*******************************************************************/
static int
c_like_comment()
{
  char            str[ONELINE];
  register char   c, *p = str;
  BOOLEAN         in_wquote = FALSE;	/* toggle switch */

  c = GETC();
  if (c == '\\')
    return 0;

  while (c != '\0') {
    if (in_wquote ||
	(!in_comment && (c != '/' || LOOKUP() != '*'))) {
      if (c == '"')
	in_wquote = (!in_wquote);
      *p++ = c;
      c = GETC();
      continue;	/* normal statements */
    }
    do {		/* in comments */
      if (c == '/' && LOOKUP() == '*') {
	c = GETC();	/* remove '*' */
	in_comment++;
      } else if (c == '*' && LOOKUP() == '/') {
	c = GETC();	/* remove '/' */
	in_comment--;
      }
    } while ((c = GETC()) != '\0' && in_comment);
  }
  *p = '\0';
  strcpy(stream, str);

#if 0
  if (in_comment && fin == stdin && istty(0))
    printf("\n\t comment continued, \
\"type '*/', [%d times]\"", in_comment);
#endif
  return 1;
}


int
break_comment(echo)
     int echo;
{
  int comment_status = in_comment;
  in_comment = 0;
  if(comment_status &&  echo) {
    fprintf(stderr, "WARNING ...");
    fprintf(stderr, "Program ended befor \"*/\" was complete.\n");
  }	
  return comment_status;	
}


void
comment_proc()
{
  register char  *p;

  /* C like COMMENT  */
  if (fin != stdin || !istty(0)) 
    c_like_comment();

  /* COMMENT #  and mark of derimiter */
  p = nextarg(stream,";#");
  if ( p > stream )
    for (; p != NULL; p = nextarg(p, ";#")) {
      if (p[-1] == '#')	/* Comment out */
        p[-1] = '\0';
      else
        p[-1] = BELL;	/* ';' ----> 0x07 */
    }

  /* top of stream buffer */
  streamptr = stream;
}
/*******************************************************************
	END OF FUNCTIONS
*******************************************************************/
