/*********************************************************************
	defs.h :
**********************************************************************/

#ifndef _DEFS_H_
#define _DEFS_H_

#ifdef   HAVE_CONFIG_H
#include "config.h"
#endif

#include "version.h"

#undef HAVE_LIBTERMCAP

#include "macro.h"

#include <stdio.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#undef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#   define CONST const
#else
#   define _ANSI_ARGS_(x)       ()
#   define CONST
#endif

/* CODE */

#define NSTACK	256    /* normal size */
/* #define NSTACK	 512   * middle size stack */
/* #define NSTACK	1024   * large size stack  */

#ifdef SMALL_AREA /* for debugging small stack code area */
#define NPROG	        512
#define RELOCATION_SIZE 512
#else
/* #define NPROG	2048   */
#define NPROG	        4096
#define RELOCATION_SIZE 2048
#endif

#define START_COLLECT 64      /* start garbage collect when  64 undefines */
/* #define START_COLLECT 128   * start garbage collect when 128 undefines */
/* #define START_COLLECT 256   * start garbage collect when 256 undefines */

#define	NFRAME	128 /* number of stack frames */


#define Switch	switch
#define Case	break; case
#define Default	break; default
#define or	: case

#define STOP	(Inst)0

typedef int             (*Inst) ();	/* machine instruction */
typedef void            (*VoidFunc) ();
typedef void            (*VFUNC) ();
typedef double          (*DFUNC) ();
typedef char           *(*SFUNC) ();
typedef struct _Object *(*ObjFunc) ();
typedef ObjFunc        *ObjFuncTbl;
typedef int              BOOLEAN;

/*
 * typedef double  Buffer;
 */

typedef struct ring {
	int             lineno;
	char            time[10];
	char           *buf;
}               History;


typedef struct _Method {
	short           objtype;
	ObjFunc         new;
	ObjFunc         copy;
	VoidFunc        setvalue;
	VoidFunc        destroy;
	VoidFunc        print;
	ObjFunc        read;

	ObjFunc         opcode;
	ObjFunc         array;
	VoidFunc	array_asgn;
	ObjFunc         snap;
	VoidFunc        snap_asgn;
}               Method;

typedef struct _Object {
	unsigned char   link;
	unsigned char   dim;
	int            *index;
	void           *val;
	Method         *method;
}               Object;


typedef struct Symbol {		/* symbol table entry */
	char           *name;
	short           type;
	short		onstack;
	Object         *obj;
	struct Symbol  *next;	/* to link to another */
}               Symbol;

typedef union Datum {		/* interpreter stack type */
	Object         *obj;
	Symbol         *sym;
	int             n;
}               Datum;


typedef int	Relative;
typedef Inst	*Absolute;

typedef struct SubProg {
	Symbol		*begin_symbol;
	Symbol		*end_symbol;
	short		narg;
	short		nauto;		
	Relative	begin_code;
	Relative	end_code;
	int		time_stamp;
	char		*source;
}		SubProg;


typedef struct Frame {		/* proc/func call stack frame         */
	Symbol         *sp;	/* symbol table entry                 */
	Inst           *retpc;	/* where to resume after return       */
	Datum          *argn;	/* n-th argument on stack             */
	int             nargs;	/* number of arguments                */
}               Frame;

typedef struct acclist {
	Object         *obj;
	struct acclist *next;
}               Acc;

typedef struct _memory_io {
        unsigned int  len;
        unsigned char *ptr;
        unsigned char *base;
} MEMORY;

typedef struct _linear {
  char	*str;
  struct _linear *next;
} Linear;


typedef Object *(*OFUNC) ();
extern Object   Series, Scalar, String, Snapshot, Builtin;
extern Inst     *progp, *mainprogbase, *pc;
extern int	CatchSigCode;

#define TypeofOBJ(obj)	((obj)->method->objtype)


#endif				/* _DEFS_H_ */
/*********************************************************************
	End of defs
**********************************************************************/
