/***************************************************************************
        main.c : SATELLITE Language Main Program

                                Coded by Shigeru Hitomi
                                Modified at Mar, 7, 1993
                                Last Modified at Mar, 1, 2000 by Takebe
***************************************************************************/

/***************************************************************************
        INCLUDE FILES
***************************************************************************/
#include <stdio.h>
#include "defs.h"
#include <math.h>
#include "prototype.h"
#include "operator.h"
#include "y.tab.h"

/***************************************************************************
	DIFINITION OF STRUCTURE
***************************************************************************/
static struct {		/* Constans */
  char           *name;
  double          cval;
}  consts[] = {
  {"+1",	    1.0},
  {"BigEndian",	    0.0},
  {"LittleEndian",  1.0},
  {"FALSE",	    0.0},
  {"TRUE",	    1.0},
  {"PHI",	    1.61803398874989484820},
  {"GAMMA",	    0.57721566490153286060},
  {"DEG",	   57.29577951308232087680},
  {"E",		    2.71828182845904523536},
  {"PI",	    3.14159265358979323846},
  {0,               0.0}
};


static struct {
  char           *name;
  Object *      (*func) ();
} builtins[] = {
  /*	Utilitys		*/	
  {"history",	 history},
  {"alias",	 alias},
  {"Symbols",	 Symbols},
  {"GarCo", 	 GarCo},
  {"write_type", WriteType},
  {"length", 	lengthof},
  {"index",	indexof},
  {"typeof", 	Typeof},
  {"printf",	Printf},
  {"abort",	Abort},
  {"eval",	eval_program},
  {"welcome",	welcome},
  {"goodbye",    goodbye},

  /*	Strings Library		*/
  {"strlen",	Strlen},
  {0,		NULL}
};


#if defined(TITAN) || defined(titan)
static struct {
  char           *name;
  double          (*func) ();
} opcode[] = {
  /*	Mathematical Library	*/
  {"asin",	tasin},
  {"acos",	tacos},
  {"atan",	tatan},
  {"atan2",	tatan2},
  {"int",	integer},
  {"abs",	tfabs},
  {"sqrt",	tsqrt},	/* checks argument */
  {"exp",	texp},	/* checks argument */
  {"exp2",      Exp2},
  {"log2",	Log2},
  {"log10",	tlog10}, /* checks argument */
  {"log",	tlog},	 /* checks argument */
  {"tan",	ttan},
  {"cos",	tcos},
  {"sin",	sin},
  {"mod",	mod},
  {"pow",	tpow},

  {"sgn",       sign}, /* by take */

	/*	End of Builtin-Commands	*/
  {0,		NULL}
};
#else
static struct {
  char           *name;
  double        (*func) ();
} opcode[] = {
  /*	Mathematical Library	*/
  {"asin",	asin},
  {"acos",	acos},
  {"atan",	atan},
  {"atan2",	tatan2},
  {"int",	integer},
  {"abs",	fabs},
  {"sqrt",	sqrt},	/* checks argument */
  {"exp",	exp},	/* checks argument */
  {"exp2",      Exp2},
  {"log2",	Log2},
  {"log10",	log10},	/* checks argument */
  {"log",	log},	/* checks argument */
  {"tan",	tan},
  {"cos",	cos},
  {"sin",	sin},
  {"mod",	mod},
  {"pow",	tpow},

  {"sgn",       sign}, /* by take */

	/*	End of Builtin-Commands	*/
  {0,		NULL}
};
#endif

static struct {		/* Keywords */
  char           *name;
  int             kval;
} keywords[] = {

  {"exit",           0},

	/*	Define Module	*/
  {"Command_Path",   COM_DIR},
  {"Command_File",   COM_FILE},
  {"Message_File",   MSG_FILE},
  {"Error_File",     ERR_FILE},
  {"Setup_File",     SETUP},
  {"Clean_File",     CLEAN},
  {"module",         MODULE},
  {"define",         DEFINE},
  {"inline",         INLINE},
  {"set",            SET},

  /*	Object Type	*/
  {"const",          CONST_T},

  /*
	"series",	SERIES_T,
	"snapshot",	SNAPSHOT_T,
	"snap",		SNAPSHOT_T,
	"scalar",	SCALAR_T,
	"string",	STRING_T,
  */

  /*	Reserved Words	*/
  {"external",   EXTERNAL},  /* take */
  {"proc",	PROC},
  {"func",	FUNC},
  {"return",	RETURN},
  {"break",	BREAK},
  {"continue",	CONTINUE},
  {"if",	IF},
  {"else",	ELSE},
  {"while",	WHILE},
  {"do",	DO},
  {"for",	FOR},
  {"print",	PRINT},
  {"read",	READ},
  {"undef",	UNDEF_VAR},
  {"isdef",     ISDEF_VAR}, /* take */
  {"unix",	UNIX},
	
  /*	End of Keywors	*/
  {NULL, 0}
};

/***************************************************************************
	FUNCTIONS
***************************************************************************/
static void
init_table()
{			/* install constants and built-ins in table */
  register int  i;
  Symbol *sp;

  for (i = 0; consts[i].name; i++)
    install(consts[i].name, CONSTANT, &(consts[i].cval), &Scalar);
  for (i = 0; opcode[i].name; i++) 
    install(opcode[i].name, OPCODE, (void*)opcode[i].func, &Builtin);
  for (i = 0; builtins[i].name; i++) 
    install(builtins[i].name, BLTIN, (void*)builtins[i].func, &Builtin);
  for (i = 0; keywords[i].name; i++)
    install(keywords[i].name, keywords[i].kval, NULL, NULL);

  sp = install("series", SERIES_T, NULL, NULL);
  sp->obj = &Series;
  sp = install("snapshot", SNAPSHOT_T, NULL, NULL);
  sp->obj = &Snapshot;
  sp = install("scalar", SCALAR_T, NULL, NULL);
  sp->obj = &Scalar;
  sp = install("string", STRING_T, NULL, NULL);
  sp->obj = &String;
}


void
initialize()
{
  init_files();     /* initialize fin_stack & open some files         */
  init_syscom();    /* initialize system common structure             */
  init_path();      /* hostname, username, homedir, current_dir, PATH */
  init_temp();	    /* making temporary directory                     */
  init_table();     /* initialize symbolic table                      */
  init_module();    /* memory allocation for module information       */
  init_history();   /* memory allocation for history table            */
                    /* open system common area to the public          */

#ifdef HAVE_LIBTERMCAP
  TerminalInitialize();
#endif

  if(make_syscom() == -1) {
    perror("system common area can't create.");
    fatal("Emergency Terminated.");
  }
  write_syscom(); /* write to system common area                    */ 

  init_stackmachine();
}
/***************************************************************************
	END FUNCTIONS
***************************************************************************/
