/*******************************************************************
	main.c : SATELLITE Language Main Program

				Coded by Shigeru Hitomi
				Last Modified at Mar, 7, 1993
*******************************************************************/

/*******************************************************************
	INCLUDE FILES
*******************************************************************/
#include <stdio.h>
#include "defs.h"
#include "prototype.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#include <fcntl.h>
#include "code.h"
#include "y.tab.h"

#define JMPNEST		10

/*******************************************************************
	GLOBAL VARIABLES
*******************************************************************/
extern BOOLEAN  indef;		        /* in the difiniton of function */
extern FILE    *fin;		        /* input file pointer    */
extern int	lineno;		        /* number of line */

/*******************************************************************
	PRIVATE VARIABLES
*******************************************************************/
static sigjmp_buf begin[JMPNEST];      /* environment buffer for long jump */
static short   jmp_nest = 0;	       /* jump nest counter  */
static BOOLEAN ReadHistory = FALSE;    /* reading flag for history */

/*******************************************************************
	PRIVATE FUNCTIONS PROTOTYPES
*******************************************************************/
static void setSignal   _ANSI_ARGS_((void));
#if 0
static int  confirm     _ANSI_ARGS_((void)); 
#endif

/*******************************************************************
	FUNCTIONS
*******************************************************************/

int
main(argc, argv)		/* main function */
     int		argc;
     char           *argv[];
{
  setSignal();			/* setting of signals */

  setpgid(0,0); /* set new process group id */

  /* read arguments from unix-shell */
  read_arg(argc, argv);

  /* addition of setup, cleanup files */
  regist_setupfiles(); 

  /* 
   * Intialization : 
   *	open some files, system-common, path, tempdir, 
   *	symbolic-table, module, history, and so on 
   */
  initialize();

  while (moreinput()) {		/* loading `*gargv[]` files */
    if (fin == stdin && !ReadHistory) { /* standard input */
      lineno = read_history(history_file()) + 1;
      ReadHistory = TRUE;	/* one time only! */
    }
    run();			/* running */
    if (fin != stdin || istty(0) == FALSE)
      continue;

    /* console input only */
    /*
       if(confirm() != TRUE)
       redo();
       */
  }

  die(0);			/* normal terminated */
  return 0;			/* maybe not reached here */
}


typedef RETSIGTYPE      (*sigfunc_t)();
     
sigfunc_t
setsignal(sig, handler)
     int       sig;
     sigfunc_t handler;
{
#if defined(hpux) || defined(SYS5SIGNALS) || defined(BSD4_3) || \
    defined(_AUX_SOURCE) || defined(__sgi)

  return signal(sig, handler);

#else
  struct sigaction n, o;
  
  bzero((char*)&n, sizeof(struct sigaction)) ;
  bzero((char*)&o, sizeof(struct sigaction)) ;
  n.sa_handler = handler;
  if (sigaction(sig, &n, &o) < 0) {
    fprintf( stderr, "sig=%d ", sig ) ;
    perror( "setsignal()" ) ; 
    return (sigfunc_t) SIG_ERR;
  }
  return (sigfunc_t) o.sa_handler ;
#endif
}


void
core(sig) /* not core dump */
     int   sig;
{
  fprintf(stderr, "%c[7m Fatal system error occured %c[0m ... ",ESC,ESC);
  die(sig);
}


void
die(sig)	/* die in the last ditch */
     int   sig;
{
  setsignal(SIGINT,  SIG_IGN);  /* ignore signal (interrupt) */
  setsignal(SIGQUIT, SIG_IGN);  /* ignore signal (quit     ) */
  setsignal(SIGTERM, SIG_IGN);  /* ignore signal (terminate) */
  setsignal(SIGHUP,  SIG_IGN);  /* ignore signal (hungup   ) */
  setsignal(SIGSEGV, SIG_DFL);  /* ignore signal (segmentation) */

  if (ReadHistory == TRUE)	/* save history */
    write_history(history_file());

  if (push_console(TELL))	/* console status */
    popConsoleIO();	 

  free_child();			/* execute clearn-up command each module */
  free_syscom();		/* free system common area */
  free_temp();			/* free working area (remove temporary directory) */
  /*	free_xtitle();  rewrite X-titile bar */	

  kill(0, SIGQUIT);		/* send a signal to a group of processes */
  kill(0, SIGTERM);		/* send a signal to a group of processes */

  if (sig != 0) {	/* fatal system error */
    fprintf(stderr, "Emergency terminated. : ");
    fflush(stderr);
    statusprt(0, sig);
  }

  /* The system died */
  exit(sig != 0);	/* exit code 0 or 1 */
}


static void
setSignal()
{
  void die(), core(), nop() ;

  setsignal(SIGPIPE, (sigfunc_t) nop); /* Broken pipe              */
#ifndef COREDUMP
  setsignal(SIGBUS,  (sigfunc_t) core);	/* bus error                */
  setsignal(SIGSEGV, (sigfunc_t) core);	/* segmentation violation   */ 
  setsignal(SIGILL,  (sigfunc_t) core);	/* illegal instruction      */
#endif
  setsignal(SIGINT,  (sigfunc_t) die); /* interrupt (^C)           */
  setsignal(SIGQUIT, SIG_IGN);	/* quit (ASCII FS)  (^\)    */
  setsignal(SIGTERM, (sigfunc_t) die); /*software termination signal(kill)*/
  setsignal(SIGHUP,  (sigfunc_t) die); /*   hungup                 */
  setsignal(SIGTSTP, SIG_IGN);	/* stop signal from tty(^Z) */
  setsignal(SIGUSR1, SIG_IGN);	/* user-defined signal 1    */
  setsignal(SIGUSR2, SIG_IGN);	/* user-defined signal 2    */
#if 0
  sesignal(SIGTSTP, (sigfunc_t) tstp); /* stop signal from tty(^Z) */
#endif
}

#if 0
static int
confirm()
{
  char            s[100];
  fprintf(stderr, " Do you really want to exit? (yes or no) ");
  if (gets(s) == NULL) {
    free_xtitle();		/* rewrite X-titile bar */	  
    return TRUE;
  }
  if (equal(s, "yes")) {
    free_xtitle();		/* rewrite X-titile bar */	
    return TRUE;
  }
  clearerr(stdin);		/* reset EOF *//* cf.<stdio.h> */
  return FALSE;
}
#endif


void
run()
{				/* execute until EOF */
  if (jmp_nest >= JMPNEST)
    execerror("run()", "deep nested");
  sigsetjmp(begin[jmp_nest],1);	/* setjmp is macro */
  jmp_nest++;			/* nesting */

  setsignal(SIGFPE, (sigfunc_t)fpecatch);	/*  floating point exception */
  /* The best way to catch a signal for interruption. */
  setsignal(SIGINT, (sigfunc_t)intcatch);	/*  interrupt */

  initcode() ; 

#ifdef DEBUG
  fprintf(stderr,"run()\n");
#endif

  if (getstream(NULL) != 0)
    while (yyparse()) {
      if (!indef)
        execute(mainprogbase);

      if (getstream(NULL) == 0)
	break;
      initcode() ;
    }

  --jmp_nest;			/* decrement jump next counter */
}

void
recovery()
{
  register int i = 0, n;

  if (fp == frame + NFRAME)  fp--;
  n = fp - frame;
  for (i = 0; i < n; i++) ret();

  fflush(stdout);
  if(fin != (FILE *)0)
    fseek(fin, 0L, 2);		/* flush rest of file */

  if (jmp_nest > 0)		/* long jump to head of run() */ 
    siglongjmp(begin[--jmp_nest], 1);
  /* not return to caller function */
}

/******************************************************************
	End of FILE
*******************************************************************/
