/*******************************************************************
        memio.c : Memory Operation Procedure

                        Coded by Shigeru Hitomi  Mar, 1st, 1993
*******************************************************************/

/*******************************************************************
        INCLUDE FILES
*******************************************************************/

#include <stdio.h>
#include "defs.h"
#include "prototype.h"


/*******************************************************************
	Memory Operation Procedure: mopen, mclose, mgets
*******************************************************************/

MEMORY  *
mopen(str)
     char  *str;
{
  MEMORY  *mp = (MEMORY *) emalloc(sizeof(MEMORY));
  mp->len = strlen(str) + 1;
  mp->base = (unsigned char *) emalloc(mp->len * sizeof(char));
  strcpy((char*)(mp->base), str);
  mp->ptr = mp->base;
  return mp;
}

int
mclose(mp)
     MEMORY  *mp;
{
  if ( mp != NULL ) {
    efree((char*)(mp->base));
    efree((char*)mp);
  }
  return 0;
}

char    *
mgets(str, siz, mp)
     register char  *str;
     int             siz;
     MEMORY         *mp;
{
  register unsigned char *p = NULL;

  if (mp == NULL || mp->len <= 0)
    return NULL;

  p = mp->ptr;
  while (*p != '\n' && *p != '\0') {
    if (p - mp->ptr >= siz - 1)
      break;
    *str++ = *p++;
  }
  *str = '\0';		/* end of string */
  if (*p == '\n' || *p == '\0')
    p++;		/* skip newline */
  mp->len -= p - mp->ptr;
  mp->ptr = p;		/* set next point */
  return str;
}
/*******************************************************************
	End of Memory Operation Procedure
*******************************************************************/
