/*******************************************************************
  misc.c : SATELLITE Language Misc Functions
  
  Coded by Shigeru Hitomi
  Last Modified at Mar, 7, 1993
  *******************************************************************/

/*******************************************************************
  INCLUDE FILES
  *******************************************************************/

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <string.h>
#include "defs.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "prototype.h"
#include "misc.h"


/*******************************************************************
  DEFINITIONS
  *******************************************************************/
#define BELL             0x07

#define DEBUGF(a)	fprintf a


/*******************************************************************
  GLOBAL VARIABLES
  *******************************************************************/
#if 0
int	CatchSigCode = 0;	
#endif

/*******************************************************************
  FUNCTIONS
  *******************************************************************/
void
nop()
{
  /* nothing */
}

char    *
GetToken(oneline, token, siz)
     char *oneline, *token;
     int   siz;
{
  register char  *s = oneline, *p = token;

  /* Get a token */
  while (*s != '\0' && (isalnum(*s) || *s == '_')) {
    if (p >= token + siz - 1) {
      *p = '\0';
      execerror("name too long", token);
    }
    *p++ = *s++;
  }
  *p = '\0';			/* end of string */

  return s;			/* return next pointer */
}

char    *
ecalloc(nelem, elsize)
     unsigned	nelem;
     unsigned	elsize;
{
  static  char  *p ; 

  p = (char*)calloc(nelem, elsize);
  
  if (nelem * elsize == 0)
    execerror("calloc: illegal request size (0 byte)", (char *) 0);
  if (p == 0)
    execerror("out of memory", (char *) 0);
  return p;
}

char    *
emalloc(n)			/* check return from malloc */
     unsigned  n;
{
  char *p = (char*)malloc(n) ;

  if (n == 0)
    execerror("malloc: illegal request size (0 byte)", (char *) 0);
  if (p == 0)
    execerror("out of memory", (char *) 0);

  return p;
}

char    *
erealloc(p, n)			/* check return from malloc */
     char           *p;
     unsigned        n;
{
  char  *rp = (char*)realloc(p, n);

  if (n == 0)
    execerror("realloc: illegal request size (0 byte)", (char *) 0);
  if (rp == 0)
    execerror("out of memory", (char *) 0);
  return rp;
}

void
efree(p)
     char           *p;
{
  if (p != NULL)
    free(p);
}

void
free2d(p, n)
     char          **p;
     int             n;
{
  register int    i;
  if (p == 0)
    return;
  for (i = 0; i < n; i++)
    efree(p[i]);
  efree((char *) p);
}

void
hrule(c)
     char *c;
{
  register int    i;
  extern int      COLUMNS;

  for (i = 0; i < COLUMNS; i++)
    xprintf(c);
  xprintf("\n");
  flush();
}

void
sl_beep(times, interval)
     int             times;
     int             interval /* [msec] */ ;
{
  int             i;

  for (i = 0; i < times; i++) {
    putchar(BELL);
    fflush(stdout);
#if HAVE_USLEEP
    usleep(interval * 1000);
#endif
  }
}

void
free_linear(p)
     register Linear *p;
{
  register Linear *fast = p ; 

  for (; p != 0; p = p->next) {
    efree(p->str);
    /* 		efree((char *) p);*/
  }

  efree((char*)fast) ;
}


Linear   *
append_linear(top, nick)
     Linear          *top;
     char           *nick;
{
  Linear          *ln = (Linear *) emalloc(sizeof(Linear));
  ln->str = emalloc((unsigned) (strlen(nick) + 1));
  ln->next = top;
  strcpy(ln->str, nick);
  return ln;
}

int
used_in_linear(top, nick)
     Linear          *top;
     char           *nick;
{
  register Linear *p;
  for (p = top; p != 0; p = p->next) {
    if (equal(p->str, nick))
      return TRUE;
  }
  return FALSE;
}


#if 0

int
signalcatch(sig)
     int             sig;
{
  DEBUGF((stderr, "intcatch"));
  signal(sig, SIG_IGN);
  CatchSigCode = sig;
  return CatchSigCode;
}
#endif
/*******************************************************************
  FUNCTIONS
  *******************************************************************/
