/********************************************************************
	parse.y : Syntax Analizer  (YACC format)                              

			Coded by Shigeru Hitomi   Mar, 8, 1992
			Last Modified at	  Mar, 8, 1993
*********************************************************************/
%{
#include <stdio.h>
#include "defs.h"
#include "prototype.h"
#include <math.h>
#include "operator.h"

#ifdef __alpha
#define CASTtoINT long int
#else
#define CASTtoINT int
#endif

#define code1(c1)               code((Inst)c1)
#define code2(c1, c2)		code((Inst)c1); code((Inst)c2)
#define code3(c1, c2, c3)	code((Inst)c1); code((Inst)c2); code((Inst)c3)
#define code4(c1, c2, c3, c4)	\
  code((Inst)c1); code((Inst)c2); code((Inst)c3); code((Inst)c4)
#define RUN()	{ code((Inst)STOP); YYABORT; } 
#define BASE	(code_offset)
#define Progp	(progp + BASE)
extern		int code_offset;
BOOLEAN		doprint = TRUE;
BOOLEAN		inpipe  = FALSE;
static Symbol *	class;
%}
%union {			/* stack type */
	Symbol	*sym;		/* symbol table pointer */
	Inst	*inst;		/* machine instruction  */
	int	narg;		/* number of arguments  */
}
%token	<sym>	UNDEF VAR
%token	<sym>	NUMBER STRING CONSTANT
%token	<sym>	OPCODE BLTIN FUNCTION PROCEDURE MODULE_NAME 
		/* Keywords between WHILE and PRINT. */
%token	<sym>	WHILE DO FOR IF ELSE BREAK CONTINUE RETURN FUNC PROC 
%token  <sym>   EXTERNAL ISDEF_VAR
%token	<sym>	READ DEFINE SET MODULE UNDEF_VAR UNIX PRINT 
%token  <sym>	COMMAND  SAT_COM UNIX_COM INLINE
%token	<sym>	COM_FILE MSG_FILE ERR_FILE COM_DIR SETUP CLEAN	
%token  <sym>	CONST_T SCALAR_T SERIES_T STRING_T SNAPSHOT_T BUILTIN_T
%token	<inst>	INCDEC ASGN_OP
%type	<inst>	primary expr stmt asgn incdecop declaration
%type   <inst>  externalasgn
%type	<inst>	pstmt unix pipeline pipeasgn redirect
%type	<inst>	prlist stmtlist multi single dfnstmt dfnlist defn 
%type	<inst>	cond do whiledo while if begin end for for_st for_cond for_inc 
%type	<sym>	procname defname file types arguments undefname
%type   <sym>   symbolname
%type   <narg>  ext_list undef_list
%type	<narg>	exprlist varlist declist arrayindex
%right	LPIPE RPIPE
%right	'=' ASGN_OP 
%left	OR
%left	AND
%left	GT GE LT LE EQ NE
%left	'+'	'-'
%left	'*'	'/'	'%'
%left	'~'
%left	UNARYMINUS NOT
%nonassoc INCDEC	
%right	'^'			/* exponentiation */
%%

list:		/* nothing */
	| list		'\n'	{ RUN(); } 
	| defn		'\n'	{ RUN(); }
	| list	multi   '\n' 	{ RUN(); }
	| list	error	'\n'	{ yyerrok; RUN();}
	;


multi:    pstmt		{ $$ = Progp; }
	| multi	';'
	| multi ';' pstmt
	;

stmt:	  declaration  	{ /* nothing */ }	
        | externalasgn  { /* nothing */ }
	| dfnstmt	{ /* nothing */ }
	| expr
		{ if(doprint) code1(auto_print); doprint = TRUE; 
		  code1(POP); }
	| BREAK		{ $$ = code1(breaker); }
	| CONTINUE	{ $$ = code1(continuer); }
	| RETURN
		{ defnonly("return"); $$ = code1(procret); }
	| RETURN expr
		{ defnonly("return"); $$ = $2; code1(funcret); }
	| PROCEDURE begin  '(' exprlist ')' 
		{ $$ = $2; code3(call, (Symbol *)$1, (CASTtoINT)$4); }
	| PRINT prlist		{ $$ = $2; }
	| COMMAND  		{ $$ = code2(sh, (Symbol *)$1); } 
	| INLINE '(' STRING ')'	{ $$ = Progp; begin_inline((Symbol *)$3); } 
	| UNDEF_VAR '(' begin undef_list ')' { $$ = $3; }
	| MODULE '(' MODULE_NAME ')'
				{ $$ = code2(install_module, (Symbol *)$3); }
	| MODULE_NAME		{ $$ = code2(print_module, (Symbol *)$1); }
	| for  for_st for_cond for_inc {doprint = TRUE;} begin pstmt end {
		($1 - BASE)[1] = (Inst)($3 - $1); /* condition */ 
		($1 - BASE)[2] = (Inst)($4 - $1); /* increment */
		($1 - BASE)[3] = (Inst)($6 - $1); /* body of loop */
		($1 - BASE)[4] = (Inst)($8 - $1); /* end, if cond fails */
		}
	| while cond newlines begin pstmt end {
		($1 - BASE)[1] = (Inst)($4 - $1); /* body of loop */
		($1 - BASE)[2] = (Inst)($6 - $1); /* end, if cond fails */
		}	
	| do pstmt whiledo cond end {
		($1 - BASE)[1] = (Inst)($4 - $1); /* condition */
		($1 - BASE)[2] = (Inst)($5 - $1); /* end, if cond fails */
		}	
	| if cond newlines begin pstmt end {
	  /* else-less if */
		($1 - BASE)[1] = (Inst)($4 - $1); /* then part */
		($1 - BASE)[3] = (Inst)($6 - $1); /* end, if cond fails */
		}
	| if cond newlines begin pstmt end ELSE newlines begin pstmt end {
	  /* if with else */
		($1 - BASE)[1] = (Inst)($4 - $1); /* then part */
		($1 - BASE)[2] = (Inst)($9 - $1); /* else part */
		($1 - BASE)[3] = (Inst)($11 - $1); /* end, if cond fails */
		}
	| '{' stmtlist '}' { $$ = $2; doprint = TRUE;}
	;

pstmt:    stmt
	| pipeline { code1(close_pipe); inpipe = FALSE; }
	| pipeasgn { code1(close_pipe); inpipe = FALSE; }
	;

stmtlist: /* nothing */		{ $$ = Progp; }
	| pstmt
	| single
	| single pstmt 
	;

single:	  stmtlist	'\n'	{ getstream("+ "); }
	| stmtlist	';'
	;

newlines: /* nothing */
	| newlines '\n'		{ getstream("+ "); } 
	;

for:	  FOR { $$ = code3(forcode, STOP, STOP); code2(STOP, STOP); }
	;
for_st:   '(' expr
	{ $$ = $2; code2(POP, STOP); }
	;
for_cond: ';' expr
	{ $$ = $2; code1(STOP); }
	;
for_inc:  ';' expr ')' newlines
	{ $$ = $2; code2(POP, STOP); }
	;

cond:	  '(' expr ')' 	 { code1(STOP); $$ = $2; }
	;
while:	  WHILE	{ $$ = code3(whilecode, STOP, STOP); } 
	;
do:	  DO	{ $$ = code3(dowhilecode, STOP, STOP); } 
	;
whiledo:  WHILE	{ $$ = code1(STOP); } 
	;
if:	  IF	{ $$ = code4(ifcode, STOP, STOP, STOP); }
	;
begin:	  /* nothing */		{ $$ = Progp; }
	;
end:	  /* nothing */	        { code1(STOP); $$ = Progp; } 
        ;
asgn:	 VAR '=' expr
		{ $$ = $3; code3(varpush, (Symbol *)$1, assign); }
	| VAR ASGN_OP expr
		{ $$ = $3; code4(varpush, (Symbol *)$1, selfasgn, (Inst)$2); }
	| file  '=' expr 
		{ $$ = $3; code4(constpush, (Symbol *)$1, store, FALSE); }
	| file  ':' '[' expr ']' '=' expr 
		{ $$ = $4; code4(constpush, (Symbol *)$1, store, TRUE); }
	| VAR begin arrayindex '=' expr
                { $$ = $2; code4(varpush, (Symbol *) $1, array_asgn, (CASTtoINT)$3);}
	| VAR begin ':' '[' expr ']' '=' expr
		{ $$ = $2; code3(varpush, (Symbol *) $1, snapshot_asgn); }
	;

primary:  NUMBER	{ $$ = code2(constpush, (Inst)$1); }
	| STRING	{ $$ = code2(constpush, (Inst)$1); }
	| CONSTANT	{ $$ = code3(varpush, (Inst)$1, eval); }
	| VAR		{ $$ = code3(varpush, (Inst)$1, eval); }
	| file
		{ $$ = code4(constpush, (Symbol *)$1, load, (Inst)FALSE); }
	| file ':' '[' expr ']'
		{ $$ = $4; code4(constpush, (Symbol *)$1, load, (Inst)TRUE); }
	| VAR begin arrayindex 
		{ $$ = $2; code4(varpush, (Symbol *)$1, array, (CASTtoINT)$3); }
	| VAR begin ':' '[' expr ']'
		{ $$ = $2; code3(varpush, (Symbol *)$1, snapshot); }
	;

arrayindex:	'[' expr ']'		{ $$ = 1; }
	|	arrayindex '[' expr ']'	{ $$ = $1 + 1; }
        ;


incdecop: INCDEC VAR { $$ = code4(varpush, (Symbol *)$2,  prefix, (Inst)$1); }
	| VAR INCDEC { $$ = code4(varpush, (Symbol *)$1, postfix, (Inst)$2); }
	;

redirect: LPIPE stmt { doprint = TRUE; $$ = $2; }
	| LPIPE unix { code1(make_pipe); } redirect { $$ = $2; }
	;

pipeline: unix { code1(make_pipe); inpipe = TRUE; } redirect { $$ = $1; }
	;

pipeasgn: VAR begin 
		{ $$ = code2(varpush, (Symbol *)$1);
			code2(pipe2str, STOP); inpipe = TRUE; doprint = TRUE;}
	  redirect
		{ ($2 - BASE)[3] = (Inst)(Progp - ($2 + 2));
		 		/* relative address from pipe2str */}
	;

unix:     UNIX	'(' expr ')'	{ $$ = $3; }
	| UNIX_COM { $$ = code2(constpush, (Symbol *)$1); }
	;

expr:	  primary	
	| asgn		{ doprint = FALSE; }
	| READ '(' types ')'	
		{ $$ = code2(varread, (Symbol *)$3); } 
	| unix	{ if(inpipe) code1(make_pipe); else
		    code1(unix_system); }
	| SAT_COM begin { code1(InModule); } 
		 '(' exprlist ')'
		{ $$ = $2; code3(exec, (Symbol *)$1, (CASTtoINT)$5); }
	| FUNCTION begin  '(' exprlist ')' 
		{ $$ = $2; code3(call, (Symbol *)$1, (CASTtoINT)$4); }
	| OPCODE begin  '(' exprlist ')' 
		{ $$ = $2; code3(dispatch, (Symbol *)$1, (CASTtoINT)$4); }
	| ISDEF_VAR '(' symbolname ')'
		{ $$ = code2(isdef_var, (Symbol *)$3); } /* take */
	| BLTIN begin  '(' exprlist ')' 
		{ $$ = $2; code3(bltin, (Symbol *)$1, (CASTtoINT)$4); }
	| '(' begin exprlist ')' { $$ = $2; if($3 != 1) {code2(combin, (CASTtoINT)$3);} }
        | incdecop 		{ doprint = FALSE; }
	| expr  '+'  expr	{ code2(basic2, add); } 	
	| expr  '-'  expr	{ code2(basic2, sub); }
	| expr  '*'  expr	{ code2(basic2, mul); }
	| expr  '/'  expr	{ code2(basic2, Div); }
	| expr	'%'  expr	{ code2(basic2, mod); }	
	| expr  '^'  expr	{ code2(basic2, tpow); }
	| '-'  expr  %prec UNARYMINUS 
		       { $$ = $2; code2(basic1, negate); }
	| expr  GT   expr	{ code2(basic2, gt); } 
	| expr  GE   expr	{ code2(basic2, ge); }
	| expr  LT   expr	{ code2(basic2, lt); }
	| expr  LE   expr	{ code2(basic2, le); }
	| expr  EQ   expr	{ code2(basic2, eq); }
	| expr  NE   expr	{ code2(basic2, ne); }
	| expr  AND  expr	{ code2(basic2, logic_and); }
	| expr  OR   expr	{ code2(basic2, logic_or); }
	| 	NOT  expr	
		       { $$ = $2; code2(basic1, not); }
	| expr '~'   expr	{ code1(ramp); }	
	;

prlist:	  expr			{ code1(print); }
	| prlist ',' expr	{ code1(print); }
	;

externalasgn: EXTERNAL begin ext_list { $$ = $2; }
        ;

ext_list: VAR {code2(external,(Symbol *)$1); }
        | ext_list ',' VAR {code2(external,(Symbol *)$3 ); }
        ;

declaration: types { class = (Symbol *)$1; } begin declist { $$ = $3; }
	| CONST_T VAR '=' expr 
		{ $$ = $4; code3(varpush, (Symbol *)$2, constant); }
	| CONST_T CONSTANT '=' expr 
		{ $$ = $4; code3(varpush, (Symbol *)$2, constant); }
	;

types:	STRING_T | SCALAR_T | SNAPSHOT_T | SERIES_T
	;

declist:  VAR	{ code4(new, class, (Symbol *)$1, (CASTtoINT) 0); }
	| VAR arrayindex
		{ code4(new, class, (Symbol *)$1, (CASTtoINT)$2); }
        | declist ',' VAR	
		{ code4(new, class, (Symbol *)$3, (CASTtoINT) 0); }
	| declist ',' VAR arrayindex	
		{ code4(new, class, (Symbol *)$3, (CASTtoINT)$4); }
	;

varlist: /* nothing  */		{ $$ = 0; }
	| VAR			{ $$ = 1; }
	| varlist ',' VAR	{ $$ = $1 + 1; }
	;

arguments: '(' varlist ')'	
		{ $$ = GetSymbolTable(); /* begin of arguments */ }
	;

/* by take*/
defn:	  FUNC procname	{  beginSub((Symbol *)$2); }
	  arguments newlines pstmt 
          { code1(procret);
	    define((Symbol *)$2, (unsigned)FUNCTION, (Symbol *)$4); }
	| PROC procname	{  beginSub((Symbol *)$2); }
	  arguments newlines pstmt 
	  { code1(procret);
	    define((Symbol *)$2, (unsigned)PROCEDURE, (Symbol *)$4); }
	;

dfnstmt: DEFINE defname newlines 
		{ define_information((Symbol *)$2); }
	'{' dfnlist '}' 
		{ $2->type = MODULE_NAME; 
		  $$ = code3(define_module, (Symbol *)$1, (Symbol *)$2); }
	;

dfnlist: /* nothing */	{ $$ = Progp; }
	| dfnlist	'\n'	{ getstream("+ "); }
	| dfnlist	';'	
	| dfnlist dfnpart
	;

dfnpart:  SET COM_DIR   STRING  
		{ code3(define_module, (Symbol *)$2, (Symbol *)$3); }
	| SET COM_FILE  STRING 
		{ code3(define_module, (Symbol *)$2, (Symbol *)$3); }
	| SET MSG_FILE  STRING
		{ code3(define_module, (Symbol *)$2, (Symbol *)$3); }
	| SET ERR_FILE  STRING
		{ code3(define_module, (Symbol *)$2, (Symbol *)$3); }
	| SET SETUP     STRING
		{ code3(define_module, (Symbol *)$2, (Symbol *)$3); }
	| SET CLEAN     STRING
		{ code3(define_module, (Symbol *)$2, (Symbol *)$3); }
	;

defname:  VAR
	| MODULE_NAME
	;

file:   /* only STRING type object */
	  '$' VAR       { $$ = $2; }
	| '$' STRING    { $$ = $2; }
	;

undef_list: undefname {code2(undef_var,(Symbol *)$1); }
        | undef_list ',' undefname {code2(undef_var,(Symbol *)$3 ); }
        ;

undefname:  VAR
	| CONSTANT
	| FUNCTION
	| PROCEDURE
	;

symbolname: VAR
	| CONSTANT
	| FUNCTION
	| PROCEDURE
	| MODULE_NAME
	;

procname:  VAR
	| FUNCTION
	| PROCEDURE
	;

exprlist:  /* nothing */	{ $$ = 0; } 
	| expr		        { $$ = 1; } 
	| exprlist ',' expr	{ $$ = $1 + 1; }
	;

%%
	/* end of grammar */


