/*********************************************************************
	prototype.h :
**********************************************************************/

#ifndef _PROTOTYPE_H_
#define _PROTOTYPE_H_

#undef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#   define CONST const
#else
#   define _ANSI_ARGS_(x)       ()
#   define CONST
#endif

/* in blt.alias.c */
extern char    *a_replace       _ANSI_ARGS_((char *nickname));
extern void     a_clear         _ANSI_ARGS_((void));
extern Object  *alias           _ANSI_ARGS_((int nargs, Object *objs[]));

/* in blt.history.c */
extern void     init_history    _ANSI_ARGS_((void));
extern int      read_history    _ANSI_ARGS_((char *h_file));
extern int      write_history   _ANSI_ARGS_((char *h_file));
extern double   history_size    _ANSI_ARGS_((void));
extern void     h_append        _ANSI_ARGS_((char *str));
extern char    *h_search        _ANSI_ARGS_((char *key));
extern History *h_get           _ANSI_ARGS_((int n));
extern Object  *history         _ANSI_ARGS_((int nargs, Object *objs[]));

/* in blt.misc.c */
extern Object  *WriteType       _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *Symbols         _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *Typeof          _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *Printf          _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *Abort           _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *GarCo           _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *lengthof        _ANSI_ARGS_((int narg, Object *objs[]));
extern Object  *indexof         _ANSI_ARGS_((int narg, Object *objs[]));

/* in blt.string.c */
extern Object  *Strlen          _ANSI_ARGS_((int narg, Object *objs[]));

/* in blt.welcome.c */
extern Object  *welcome         _ANSI_ARGS_((int nargs, Object *objs[]));
extern Object  *goodbye         _ANSI_ARGS_((int nargs, Object *objs[]));

/* in code.array.c */
extern void     array           _ANSI_ARGS_((void));
extern void     array_asgn      _ANSI_ARGS_((void));
extern void     snapshot        _ANSI_ARGS_((void));
extern void     snapshot_asgn   _ANSI_ARGS_((void));
extern void     new             _ANSI_ARGS_((void));

/* in code.bltin.c */
extern void     basic1          _ANSI_ARGS_((void));
extern void     basic2          _ANSI_ARGS_((void));
extern void     dispatch        _ANSI_ARGS_((void));
extern void     bltin           _ANSI_ARGS_((void));

/* in code.comb.c */
extern void     ramp            _ANSI_ARGS_((void));
extern void     combin          _ANSI_ARGS_((void));

/* in code.core.c */
extern void     initcode        _ANSI_ARGS_((void));
extern void     push            _ANSI_ARGS_((Datum d));
extern Datum    pop             _ANSI_ARGS_((void));
extern void     push_obj        _ANSI_ARGS_((Datum d));
extern Datum    pop_obj         _ANSI_ARGS_((void));
extern void     POP             _ANSI_ARGS_((void));
extern void     constpush       _ANSI_ARGS_((void));
extern void     varpush         _ANSI_ARGS_((void));
extern void     eval            _ANSI_ARGS_((void));
extern void     constant        _ANSI_ARGS_((void));
extern void     assign          _ANSI_ARGS_((void));
extern void     selfasgn        _ANSI_ARGS_((void));
extern void     prefix          _ANSI_ARGS_((void));
extern void     postfix         _ANSI_ARGS_((void));
extern Inst    *code            _ANSI_ARGS_((Inst f));
extern void     undef_var       _ANSI_ARGS_((void));
extern void	isdef_var	_ANSI_ARGS_((void));
extern void     execute         _ANSI_ARGS_((Inst *p));

/* in code.eval.c */
extern Object  *eval_program    _ANSI_ARGS_((int nargs, Object *objs[]));

/* in code.file.c */
extern char    *write_type      _ANSI_ARGS_((char *format, char *type,
					     int byte));
extern void     load            _ANSI_ARGS_((void));
extern void     store           _ANSI_ARGS_((void));

/* in code.flow.c */
extern void     continuer       _ANSI_ARGS_((void));
extern void     breaker         _ANSI_ARGS_((void));
extern int      is_true         _ANSI_ARGS_((Object *obj));
extern void     forcode         _ANSI_ARGS_((void));
extern void     whilecode       _ANSI_ARGS_((void));
extern void     dowhilecode     _ANSI_ARGS_((void));
extern void     ifcode          _ANSI_ARGS_((void));

/* in code.func.c */
/* take */
extern void     beginSub        _ANSI_ARGS_((Symbol *proc));
/* extern void     beginSub        _ANSI_ARGS_((void)); */
#ifdef DEBUG
extern void     EndSub          _ANSI_ARGS_((SubProg *sub));
#endif
extern void     endSub          _ANSI_ARGS_((void));
extern void     define          _ANSI_ARGS_((Symbol *proc, unsigned type,
					     Symbol *arg));
extern void     call            _ANSI_ARGS_((void));
extern void     ret             _ANSI_ARGS_((void));
extern void     funcret         _ANSI_ARGS_((void));
extern void     procret         _ANSI_ARGS_((void));
extern Datum   *free_autovars   _ANSI_ARGS_((void));
extern void     external        _ANSI_ARGS_((void));
extern void     setobj          _ANSI_ARGS_((Symbol *sp, Object *obj));
extern Object  *getobj          _ANSI_ARGS_((Symbol *sp));

/* in code.memory.c */
extern void     init_stackmachine _ANSI_ARGS_((void));
extern int      incode            _ANSI_ARGS_((Symbol *sym));
extern int      incode2           _ANSI_ARGS_((Symbol *sym));
extern int      ResizeCodeArea    _ANSI_ARGS_((void));
extern int      relocate          _ANSI_ARGS_((void));

/* in code.stream.c */
extern void     varread         _ANSI_ARGS_((void));
extern void     auto_print      _ANSI_ARGS_((void));
extern void     print           _ANSI_ARGS_((void));
extern void     sh              _ANSI_ARGS_((void));
extern void     unix_system     _ANSI_ARGS_((void));
extern void     pipe2str        _ANSI_ARGS_((void));
extern void     read_pipe       _ANSI_ARGS_((int fd));
extern void     make_pipe       _ANSI_ARGS_((void));
extern void     close_pipe      _ANSI_ARGS_((void));

/* in code.trace.c */
#ifdef OUT_STACK
extern void     out_stack      _ANSI_ARGS_((FILE *fout));
#endif
#if defined(DEBUG) || defined(OUT_STACK_MACHINE_CODE) || \
    defined(SHOW_STACK_MACHINE_CODE)
extern char    *code_name      _ANSI_ARGS_((Inst p));
#ifdef SHOW_STACK_MACHINE_CODE
extern void     show_code      _ANSI_ARGS_((Inst *p));
#endif
#ifdef OUT_STACK_MACHINE_CODE
extern void     out_stack_code _ANSI_ARGS_((Inst *p, Inst f));
#endif
#endif

/* in mdl.defn.c */
extern void     init_module        _ANSI_ARGS_((void));
extern void     define_information _ANSI_ARGS_((Symbol *sp));
extern void     define_module      _ANSI_ARGS_((void));
extern void     print_module       _ANSI_ARGS_((void));
extern int      install_module     _ANSI_ARGS_((void));
extern void     free_child         _ANSI_ARGS_((void));

/* in mdl.exec.c */
extern void     InModule           _ANSI_ARGS_((void));
extern int      exec               _ANSI_ARGS_((void));

/* in mdl.file.c */
extern int      cmd_delete        _ANSI_ARGS_((int moduleNo));
extern int      cmd_read          _ANSI_ARGS_((FILE *fp, int no));
extern void     msg_read          _ANSI_ARGS_((FILE *fp, int no));
extern void     err_read          _ANSI_ARGS_((FILE *fp, int no));

/* in mdl.gets.c */
extern int      ismodule          _ANSI_ARGS_((char *comline, char *allline,
					       int first));
/* in mdl.mesg.c */
extern int      load_msg    _ANSI_ARGS_((int mdl_num, int msg_num, char *str));
extern int      load_err    _ANSI_ARGS_((int mdl_num, int msg_num, char *str));
extern void     ExecError   _ANSI_ARGS_((int mdl_num, char *bin, int msg_num));
extern void     disp_msg    _ANSI_ARGS_((char *str));

/* in net.ip.c */
extern int      passivesock  _ANSI_ARGS_((char *service, char *protocol,
				          int qlen));
extern int      PassiveTCP   _ANSI_ARGS_((char *service, int qlen));
extern int      PassiveUDP   _ANSI_ARGS_((char *service, int qlen));
extern int      ConnectTCP   _ANSI_ARGS_((char *host, char *service));
extern int      ConnectUDP   _ANSI_ARGS_((char *host, char *service));

/* in tools.c */
extern void     print_number _ANSI_ARGS_((char *fmt, char *def, double d));
extern Buffer  *getbuffer    _ANSI_ARGS_((Object *obj, int *dim, int *index));
extern void     index_header _ANSI_ARGS_((int i, int dim2, int index2[], 
					  char *fmt, Object *class));

/* in tty.cursor.c */
#ifdef HAVE_LIBTERMCAP
extern int      TerminalInitialize _ANSI_ARGS_((void));
#endif
#ifdef __STDC__
extern void     xprintf            _ANSI_ARGS_((char *fmt, ...));
#else
extern void     xprintf            _ANSI_ARGS_((va_decl va_alist));
#endif
extern void     put_line           _ANSI_ARGS_((char *sbuf));
extern void     flush              _ANSI_ARGS_((void));
extern void     errflush           _ANSI_ARGS_((FILE *fp));
extern void     ClearDisplayBuffer _ANSI_ARGS_((void));
/* other functions are declared in cursor.h */

/* in tty.file.c */
extern int      filecheck         _ANSI_ARGS_((char *path, char *name));
extern void     splitdir          _ANSI_ARGS_((char *path, char *dir));
extern int      filesearch        _ANSI_ARGS_((char *str, int first));

/* in tty.ioctl.c */
extern void     pushConsoleIO();
extern void     popConsoleIO();
extern BOOLEAN  push_console();
extern void     GetSize();
extern int      istty();

/* in tty.key.c */
extern void     goto_origin      _ANSI_ARGS_((int i));
extern void     goto_begin       _ANSI_ARGS_((int i));
extern void     goto_pos         _ANSI_ARGS_((int i, int len));
extern void     move_to_eos      _ANSI_ARGS_((void));
extern void     forward          _ANSI_ARGS_((int i));
extern void     backward         _ANSI_ARGS_((int i));
extern void     clear_forward    _ANSI_ARGS_((int i, int end));
extern void     del_backward     _ANSI_ARGS_((int cp, int back));
extern void     clear_lines      _ANSI_ARGS_((int i));
extern void     clear_nextline   _ANSI_ARGS_((void));

/* in tty.search.c */
extern int      cut_of_last_part _ANSI_ARGS_((char *str, char *path));
extern int      is_oneword       _ANSI_ARGS_((char *path));
extern int      fullname         _ANSI_ARGS_((char *str));
extern int      fullkeyword      _ANSI_ARGS_((char *str));
extern void     ls               _ANSI_ARGS_((char *str));

/* in utl.misc.c */
extern void     xtitle        _ANSI_ARGS_((char *icon, char *tbar));
extern void     syserr        _ANSI_ARGS_((char *msg));


/* in utl.path.c */
extern int      change_xtitle _ANSI_ARGS_((void));
extern int      free_xtitle   _ANSI_ARGS_((void));
extern int      init_path     _ANSI_ARGS_((void));
extern int      change_dir    _ANSI_ARGS_((char *argv[]));

/* in utl.pipe.c */
/* extern int   pipeline      _ANSI_ARGS_((char **argv, int out)); */
extern int      mkpipe        _ANSI_ARGS_((char *bin));
extern char    *readpipe      _ANSI_ARGS_((int fd));  
extern char    *pread_sl      _ANSI_ARGS_((int pfd[]));

/* in utl.split.c */
extern int      argcount _ANSI_ARGS_((char *sbuf, char *separator));
extern char    *nextarg  _ANSI_ARGS_((char *sbuf, char *spearator));
extern int      splits   _ANSI_ARGS_((char *sbuf, char **argv, int argc));
extern int      separate _ANSI_ARGS_((char *str,  char **argv, int argc,
				      char *separator));

/* in utl.string.c */
extern char    *rmnl            _ANSI_ARGS_((char *str));
extern void     tolowers        _ANSI_ARGS_((char *str));
extern void     touppers        _ANSI_ARGS_((char *str));
extern int      any             _ANSI_ARGS_((char *s, int c));
extern char    *strsft          _ANSI_ARGS_((char *str, int sft));
extern char    *catstr          _ANSI_ARGS_((char *str2, char *str1));
extern char    *insertc         _ANSI_ARGS_((char *str, int pos, char c));
extern char    *deletec         _ANSI_ARGS_((char *str, int pos));
extern char    *relpace         _ANSI_ARGS_((char *str, char *a, char *b));
extern char    *concat          _ANSI_ARGS_((char **argv, char *str, char c));

/* in utl.unixpart.c */
extern char    *intersh           _ANSI_ARGS_((char *s, int usepipe));
extern int      opentty           _ANSI_ARGS_((void));
extern int      executable        _ANSI_ARGS_((char *cmd));
extern int      internal          _ANSI_ARGS_((char *cmd_ptr));

/* in utl.waitfor.c */
extern int      statusprt         _ANSI_ARGS_((int pid, int status));
extern int      waitfor           _ANSI_ARGS_((int pid));

/* in comment.c */
extern int      break_comment     _ANSI_ARGS_((int echo));
extern void     comment_proc      _ANSI_ARGS_((void));

/* in error.c */
#ifdef __STDC__
extern void     ErrorExit         _ANSI_ARGS_((char *fmt, ...));
extern void     Sperror           _ANSI_ARGS_((char *fmt, ...));
#else
extern void     ErrorExit         _ANSI_ARGS_((va_decl va_alist));
extern void     Sperror           _ANSI_ARGS_((va_decl va_alist));
#endif

/* in infile.c */
extern void     init_files        _ANSI_ARGS_((void));
extern void     begin_inline      _ANSI_ARGS_((Symbol *sym));
extern int      end_inline        _ANSI_ARGS_((void));
extern int      moreinput         _ANSI_ARGS_((void));
extern void     redo              _ANSI_ARGS_((void));
extern int      regist_setupfiles _ANSI_ARGS_((void));
extern int      read_arg          _ANSI_ARGS_((int argc, char **argv));
extern char    *history_file      _ANSI_ARGS_((void));

/* in init.c */
extern void     initialize        _ANSI_ARGS_((void));

/* in lex.c */
extern int      yylex             _ANSI_ARGS_((void));

/* in main.c */
extern void     core              _ANSI_ARGS_((int sig));
extern void     die               _ANSI_ARGS_((int sig));
extern void     recovery          _ANSI_ARGS_((void));
extern void     run               _ANSI_ARGS_((void));

/* in memio.c */
extern MEMORY  *mopen             _ANSI_ARGS_((char *str));
extern int      mclose            _ANSI_ARGS_((MEMORY *mp));
extern char    *mgets             _ANSI_ARGS_((char *str, int siz,
					       MEMORY *mp));

/* in misc.c */
extern char    *GetToken          _ANSI_ARGS_((char *online, char *token,
					       int siz));
extern char    *emalloc           _ANSI_ARGS_((unsigned n));
extern char    *erealloc          _ANSI_ARGS_((char *p, unsigned n));
extern char    *ecalloc           _ANSI_ARGS_((unsigned nelem,
					       unsigned elsize));
extern void     efree             _ANSI_ARGS_((char *p));
extern void     free2d            _ANSI_ARGS_((char **p, int n));
extern void     nop               _ANSI_ARGS_((void));
extern void     hrule             _ANSI_ARGS_((char *c));
extern void     sl_beep           _ANSI_ARGS_((int times, int interval));

/* in parse.y */
extern int      yyparse           _ANSI_ARGS_((void));

/* in stream.c */
extern int      prompt            _ANSI_ARGS_((int dest, char *str, int no));
extern int      getstream         _ANSI_ARGS_((char *pp));

/* in symbol.c */
extern Symbol  *GetSymbolTable    _ANSI_ARGS_((void));
extern void     PutSymbolTable    _ANSI_ARGS_((Symbol *tableEntry));
extern void     FreeSymbols       _ANSI_ARGS_((void));
extern Symbol  *install           _ANSI_ARGS_((char *s, int t, void *val,
					       Object *super_class));
extern Symbol  *lookup            _ANSI_ARGS_((char *s));
extern void     listup            _ANSI_ARGS_((void));
extern int      undef             _ANSI_ARGS_((char *name));
extern char    *symbol_name       _ANSI_ARGS_((Inst p));
extern char    *keyword_search    _ANSI_ARGS_((char *s, BOOLEAN first));
extern Object  *newacc            _ANSI_ARGS_((void *val, int dim, int *index,
					       Object *super_class));
extern Object  *cpyacc            _ANSI_ARGS_((Object *super_class));
extern Object  *BufftoObj         _ANSI_ARGS_((int id, Object *super_class));


/* in tmpdir.c */
extern void     init_temp         _ANSI_ARGS_((void));
extern void     free_temp         _ANSI_ARGS_((void));

/* in warning.c */
extern void     intcatch          _ANSI_ARGS_((void));
extern void     fpecatch          _ANSI_ARGS_((void));
extern void     execerror         _ANSI_ARGS_((char *s, char *t));
extern void     defnonly          _ANSI_ARGS_((char *s));
extern void     yyerror           _ANSI_ARGS_((char *s));
extern void     fatal             _ANSI_ARGS_((char *msg));
extern void     warning           _ANSI_ARGS_((char *s, char *t));

/* in libsl.a */
#include "SL_prototype.h"

#endif				/* _PROTOTYPE_H_ */

/*********************************************************************
	End of prototype
**********************************************************************/
