/*******************************************************************
	stream.c : Stream Procedure

			Coded by Shigeru Hitomi  May, 20, 1992
			Last Modified            Mar, 1st,1993
*******************************************************************/

/*******************************************************************
	INCLUDE FILES
*******************************************************************/
#include "stream.h"		/* include stdio.h */
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include "defs.h"
#include "prototype.h"

#include "cursor.h"
#include "misc.h"

#define REPRINT	(1)
/*******************************************************************
 * GLOBAL VARIABLES
 *******************************************************************/
static void     reprint        _ANSI_ARGS_ ((char *str ));
static int      history_call   _ANSI_ARGS_ ((char *oneline));
static int      increment      _ANSI_ARGS_ ((int n, int inc, 
					     int nmin, int nmax));
static History *history_search _ANSI_ARGS_ ((int *n, int inc, char *skey));
static void     Redisplay      _ANSI_ARGS_ ((char *pp, int line_no));
static char    *print_hist     _ANSI_ARGS_ ((char *pp, BOOLEAN *first,
					     int inc));
static int      getty          _ANSI_ARGS_ ((char *str, char *pp));
static void     alias_proc     _ANSI_ARGS_ ((char *oneline, BOOLEAN first));
static int      prepro         _ANSI_ARGS_ ((char *oneline, BOOLEAN first));

/*******************************************************************
 * GLOBAL VARIABLES
 *******************************************************************/
extern BOOLEAN  top;
int      prompt_len;

/*******************************************************************
 * Micro Editor & Preprocessor
 *******************************************************************/


int
prompt(dest, str, no)
     int             dest;	/* destination    */
     char           *str;	/* prompt message */
     int	      no;	/* line number    */
{
#ifdef HAVE_LIBTERMCAP
  static char    *format = " %s%s:[%d]%% ";
#else
  static char    *format = "[%c[7m]SATELLITE[%c[0m]%s%s:[%d]%% ";
#endif
  static char     mprop[ONELINE];	/* prompt message buffer */

  flush();
  ClearText(ClrFORWARD);

  /* formatting prompt message */
  if (no >= 0) {
    if (str == NULL) {
      char           *tilde = (*cwd == '/') ? "" : "~";
#ifdef HAVE_LIBTERMCAP
      sprintf(mprop, format, tilde, cwd, no);
      prompt_len = strlen(mprop) +11;
#else
      sprintf(mprop, format, ESC, ESC, tilde, cwd, no);
      prompt_len = strlen(mprop) - 8;
#endif
    } else {
      sprintf(mprop, "%s", str);
      prompt_len = strlen(mprop);
    }
  } /* if no < 0 then reprint previous prompt */

  /* display prompt message */
#ifdef HAVE_LIBTERMCAP
  if ( str == NULL ) {
    CursorColor(CurREVERSE);
    put_line("[SATELLITE]");
    CursorColor(CurNORMAL);
  }
  if (dest == 1) {
    put_line(mprop);
  } else {
    put_line(mprop);
  }
#else
  if (dest == 1) {		/* destination is standard output */
    xprintf("%s", mprop);
  } else {			/* destination is `pout' */
    /* fprintf(pout, "%s", mprop), fflush(pout); */
    fprintf(stderr, "%s", mprop), fflush(stderr);
  }
#endif
  return TRUE;
}

static void
reprint(str)		/* print "(str)" */
     char           *str;
{
  char           *p;
  xprintf("\n(");
  for (p = str; *p != '\n' && *p != '\0'; p++)
    xprintf("%c", *p);
  xprintf(")");
  flush();
}

static int
history_call(oneline)	/* history call format: !! or !keyword */
     char           *oneline;
{
  char           *s, *next;
  char           *keyword;

  next = oneline + 1;		/* +1 : for `!' */
  while (*next != '\0' && !isspace(*next))
    ++next;
  /*
   * split up a `oneline' into two parts : keyword and next statements.
   */
  insertc(next++, 0, '\0');
  keyword = oneline + 1;	/* +1 : for `!' */

  if (*keyword == '\0')
    execerror("\nillegal history operation", "");

  if ((s = h_search(keyword)) == NULL) {
    fprintf(stderr, "\n\tEvent not found.");
    return FALSE;
  }
  /*
   * shift next-statement's head to top of `oneline' ( +2 --> '!' and a
   * NULL after 'keyword' )
   */
  strsft(next, -(strlen(keyword) + 2));

  /* insert a history(`s') in top of `online' */
  catstr(s, oneline);

  /* remove a '\n' (between history and next-statements) */
  deletec(oneline, strlen(s) - 1);
  return TRUE;
}

static int
increment(n, inc, nmin, nmax)
     int             n, inc, nmin, nmax;
{
  n += inc;

  if (n < nmin)			/* BEEP */
    n = nmin;
  if (n > nmax)			/* BEEP */
    n = nmax;
  return n;
}

static History *
history_search(n, inc, skey)
     int            *n, inc;
     char           *skey;
{
  History        *hp;
  char           *s = NULL;
  int             m, hsiz = (int) history_size();

  if (skey == NULL)
    return NULL;

  do {
    s = NULL;
    m = increment(*n, inc, 0, hsiz);
    hp = h_get(m);
    if (hp != NULL) {
      *n = m;
      s = hp->buf;
      while (isspace(*s))
	s++;
    }
  } while (hp != NULL && strncmp(s, skey, strlen(skey)) != 0);

  if ( m == 0 )
    *n = 0;		/* take */
	
  return hp;
}

static void
Redisplay(pp, line_no)
     char           *pp;
     int             line_no;
{
  extern int      COLUMNS;
  CursorMove(CurBEGIN_LINE,0);
  ClearText(ClrFORWARD);
  prompt(1, pp, line_no);
  xprintf("%s", stream);
  if ((prompt_len + strlen(stream)) == COLUMNS)
    xprintf("\n");
  flush();
}

static char   *
print_hist(pp, first, inc)
     char           *pp;
     BOOLEAN        *first;
     int             inc;
{
  History        *hp;
  int             nb, line_no = lineno;
  static int      n;
  static char     sbuf[ONELINE];

  if (*first) {
    strcpy(sbuf, stream);
    *first = FALSE;
    n = 0;
  }
  nb = n;
  hp = history_search(&n, inc, sbuf);

  if (nb == n) {
    sl_beep(1, 0);			/* end of history */
    return sbuf;
  }
  if (hp != NULL) {		/* hp == NULL : not found */
    strcpy(stream, hp->buf);
    rmnl(stream);		/* erase '\n' */
    line_no = hp->lineno;
  } else {
    strcpy(stream, sbuf );
  } /* take */

  Redisplay(pp, line_no);
  return NULL;
}

static int
getty(pp, str)
     char           *str, *pp;
{
  BOOLEAN         first = TRUE;
  int             key, inc = 0;
  char            oneline[ONELINE], *s;
  
  *str = '\0';
  while (1) {
    strcpy(oneline, str);
    key = getcon(str, 0, strlen(str));
    
    if (!equal(str, oneline))
      first = TRUE;
    switch (key) {
    case PREV:
      print_hist(pp, &first, inc = 1);
      break;
    case NEXT:
      s = print_hist(pp, &first, inc = -1);
      if (s != NULL) {
	strcpy(stream, s);
	Redisplay(pp, lineno);
      }
      break;
    case BS:
      continue;
    default:			/* ESCAPE WHILE LOOP */
      return inc;
    }
  }
}

static void
alias_proc(oneline, first)
     char           *oneline;
     BOOLEAN         first;
{
  static Linear  *seed = 0;
  char           *realname, nickname[100];
  char           *next = oneline;
  int             len;

  next = GetToken(oneline, nickname, sizeof(nickname));

  if (first) {
    free_linear(seed);
    seed = 0;
  }
  if (!used_in_linear(seed, nickname)) {
    seed = append_linear(seed, nickname);
    do {

      next = GetToken(oneline, nickname, sizeof(nickname));
      /*
       * `next' point to part of `oneline': Now, pointed to
       * next statements
       */
      realname = a_replace(nickname); /* auto memory alloc */
      if (realname == NULL)
	break;

      len = strlen(realname) + strlen(next) + 1;
      if (len >= ONELINE)
	execerror("alias", "too long line");

      /* remove `nickname' from a `oneline' */
      strsft(next, -strlen(nickname));
      /* insert `realname' in a `oneline' */
      catstr(realname, oneline);
      efree(realname);
    } while (realname != NULL);
  }
  a_clear();			/* clear : alias-loop check flag */
}

static int
prepro(oneline, first)
     char           *oneline;
     BOOLEAN         first;
{
  char           *p, car[ONELINE], tmp[ONELINE], *cdr;
  BOOLEAN         status = !REPRINT;
  static char     separator[] = {BELL, ';', '\0'};

  if (oneline == NULL)		/* end of recursive */
    return !REPRINT;

  strcpy(tmp, oneline);
  *oneline = '\0';		/* Initialize */

  cdr = nextarg(tmp, separator);
  if (cdr != NULL) {		/* separate two strings by a NULL */
    if (cdr[-1] == BELL)
      cdr[-1] = ';';
    insertc(cdr++, 0, '\0');
  }
  if (strlen(tmp) >= sizeof(car))
    execerror("a statement too long", 0);
  strcpy(car, tmp);

  for (p = car; isspace(*p); p++)
    /* space skip */ ;

  /* History Call */
  if (*p == '!') {
    if (history_call(p) == FALSE)
      return !REPRINT;
    status = REPRINT;
  } else if (isalpha(*p)) {
    char           *s;
    alias_proc(p, first);
    s = nextarg(p, separator);
    if (s != NULL && s[-1] == BELL) {
      s[-1] = ';';
      first = TRUE;
    } else {
      first = FALSE;
    }
    if (s != NULL) {
      if (cdr == NULL) {
	cdr = tmp;
	*cdr = '\0';
      }
      insertc(s++, 0, '\0');
      if (*cdr != '\0')
	strcat(s, " ");
      catstr(s, cdr);
    }
    /* SATELLITE (external functions) ? */
    ismodule(p,p,1);
  }
  status = (status || prepro(cdr, first));
  strcpy(oneline, car);
  if (cdr != NULL)
    strcat(oneline, cdr);
  return status;
}

int
getstream(pp)
     char           *pp;
{
  BOOLEAN  first = TRUE;

  streamptr = stream;		/* beginning of stream */
  top = TRUE;			/* set line-top flag */

  /* end of line */
  if (fin == stdin && istty(0)) {
    /* Put a prompt */
    prompt(2, pp, lineno);	/* 2 is stderr */
    getty(pp, stream);	        /* get tty */
    if ( stream[0] == (char)EOF ) return 0; /* take for IRIX */
  } else if (fin != (FILE*) 0) {
    if (fgets(stream, MAXBUF, fin) == NULL) {
      break_comment(TRUE);      /* break comment block */
      return end_inline();	/* EOF : return 0 */
    }
  } else			/* if (fin == (char *) 0) */ {
    extern MEMORY *fin_mp;
    if (mgets(stream, MAXBUF, fin_mp) == NULL) {
      mclose(fin_mp);
      fin_mp = NULL; /* take */

      stream[0] = EOF;
      break_comment(TRUE);	/* break comment block */
      return 0;
    }
  }

  /* skipping comment */
  comment_proc();

  if (prepro(stream, first) == REPRINT)
    reprint(stream);

  rmnl(stream);			/* for file input */

#if 0
  fprintf( stderr, "stream: [%s]\n", stream ) ;
#endif

  strcat(stream, "\n");

  if(fin == stdin) {
    /* fprintf(pout, "\n"), fflush(pout); */
    fprintf(stderr, "\n"), fflush(stderr);
  }

  /* History Append */
  if (fin == stdin && istty(0)) {
    register char  *p = stream;
    if (*p != '\n' && *p != '\0' && *p != (char)EOF) {
      h_append(stream);
      lineno++;
    }
  } else
    lineno++;
    

  return 1;
}

/******************************************************************
	End of Stream Procedure
*******************************************************************/
