#include <stdio.h>
#include <string.h>
#include "defs.h"

/* System V format for mkdir() */
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#else
#include <sys/dir.h>
#include <sys/file.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "prototype.h"

char    WorkingArea[ONELINE];

static int rm _ANSI_ARGS_(( char *option, char *path ));


void
init_temp()
{
  extern char     current_dir[];
  char            temp_dir[FILE_LENGTH];

  /*****  Get My Process ID  *****/
  int             pid = getpid();
  /***** Setting Environment Value *****/
  if (set_mypid(pid) == -1)
    fatal("environment value can't set.");

  /*****  temp_dir[]  *****/
  if (WorkingArea[0] != '/')
    sprintf(temp_dir, "%s/%s/SL%d", current_dir, WorkingArea, pid);
  else
    sprintf(temp_dir, "%s/SL%d", WorkingArea, pid);

  /***** Making Temporary Directory *****/
  if (mkdir(temp_dir, 0755) != 0) {
    char            mes[ONELINE];
    sprintf(mes, "Working Area(%s) can't create.", temp_dir);
    fatal(mes);
  }
  strcat(temp_dir, "/");
  set_tmpdir(temp_dir);
}

void
free_temp()
{
  char temp_dir[FILE_LENGTH];

  strcpy(temp_dir, get_tmpdir());
  temp_dir[strlen(temp_dir) - 1] = '\0';	/* delete '/' */

  if (!equal(temp_dir, "") && strlen(WorkingArea) < strlen(temp_dir)) {
    /*    rm("-rf", temp_dir);*/
    char  command[ONELINE] ;
    sprintf( command, "rm -rf %s\n", temp_dir ) ;
    system( command ) ; 
  } 
}

/* nonfork remove routine -------------- by take */
static int
rm(option, path )
     char *option;
     char *path;
{
  DIR *dirp;
#ifdef HAVE_DIRENT_H
  struct dirent  *dp;
#else
  struct direct  *dp;
#endif

  char name[ONELINE];

  dirp = opendir(path) ; 
  fflush(stderr) ; 

  if ( (path == (char*)NULL) || (dirp == (DIR*)NULL) ) {
    sprintf(name, "sl : cannot open temporary directory(%s) ", path); 
    perror(name);
    return -1;
  }

  for ( dp = readdir(dirp); dp != NULL; dp = readdir(dirp))
    if ( dp->d_name != NULL ) {
      if (   strcmp( dp->d_name , "."  ) == 0 
	     || strcmp( dp->d_name , ".." ) == 0 )
	continue;
      strcpy( name, path );
      strcat( name, "/" );
      strcat( name, dp->d_name );
      if ( access(name,W_OK) == 0 ) 
	if ( unlink(name) != 0 ) {
	  if ( rm( NULL, name ) != 0 )
	    return -1;
	}
    }    
  closedir(dirp);

#ifdef CORE
  dirp = opendir(path) ;
  if ( dirp == NULL ) {
    sprintf(name, "sl : cannot open temporary directory(%s) ", path); 
    perror(name);
    return -1;
  }
  for ( dp = readdir(dirp); dp != NULL; dp = readdir(dirp))
    if ( dp->d_name != NULL ) {
      printf("%s\t",dp->d_name);
    }
  closedir(dirp);
  puts("");
#endif

  if ( rmdir(path) == 0 )
    return 0;

  sprintf(name, "sl : cannot erase temporary directory(%s) ", path);
  perror(name);
  return -1;
}  
