/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : cut            *
*    ( Ver 1.0 : 1993/03/10 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

int
main()
{
  int index1[MAX_INDEX], index2[MAX_INDEX];
  int index3[MAX_INDEX], index4[MAX_INDEX], index5[MAX_INDEX];
  int pos[MAX_INDEX], pos2[MAX_INDEX];
  int dim1, dim2, dim3, m, l, i, dpt, dpt2;
  Buffer  *x, *y, *z, *data;

  read_syscom();
  if (( x = GetSeries( 0, &dim1, index1 ) ) == NULL )
    exit(4);
  if (( y = GetSeries( 1, &dim2, index2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    index2[0] = 1;
  }
  if (( z = GetSeries( 2, &dim3, index3 ) ) == NULL ) {
    z = AllocBuffer(1);
    z[0] = GetScalar(2);
    index3[0] = 1;
  }
  if ( index2[0] != dim1 || index3[0] != index2[0] )
    exit(16);

  for ( i = 0; i < dim1; i++ ) {
    if ( (int)z[i] < (int)y[i] || index1[i] <= (int)z[i] )
      exit(7);
    index4[i] = (int)y[i];
  }

  for ( i = 0; i < dim1; i++ )
    index5[i] = (int)z[i]-(int)y[i]+1;
  data = AllocBuffer( IndexSize( dim1, index5 ) );

  if ( dim1 == 1 ) {
    m = index4[0]+index5[0];
    for ( l = 0, i = index4[0]; i < m; i++, l++ )
      data[ l ] = x[ i ];
  } else {
    for ( i = 0; i < dim1; i++ ) {
      pos [i] = index4[i];
      pos2[i] = 0;
    } 
    do {
      dpt  = Index( pos , dim1, index1 );
      dpt2 = Index( pos2, dim1, index5 );
      m = dpt+index5[dim1-1];
      for ( l = dpt2, i = dpt; i < m; i++, l++ )
	data[ l ] = x[ i ];

      pos2[dim1-2]++;
      pos [dim1-2]++;
      for ( i = dim1-2; i > 0; i-- )
	if ( pos2[i] >= index5[i] || pos[i] >= index1[i] ) {
	  pos2[i-1]++;
	  pos [i-1]++;
	  pos2[i] = 0;
	  pos [i] = (int)y[i];
	}
    } while ( pos2[0] < index5[0] );
  }
  ReturnSeries( data, dim1, index5 );
  FreeBuffer( x );
  FreeBuffer( y );
  FreeBuffer( z );
  FreeBuffer( data );
  return 0;
}
