/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : fill           *
*    ( Ver 1.0 : 1993/04/10 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

int
main()
{
  int index1[MAX_INDEX], index2[MAX_INDEX], index3[MAX_INDEX];
  int index4[MAX_INDEX], index5[MAX_INDEX];
  int pos[MAX_INDEX];
  int dim1, dim2, dim3, m, i, dpt;
  Buffer  *x, *y, *z;
  double v;

  read_syscom();
  if (( x = GetSeries( 0, &dim1, index1 ) ) == NULL )
    exit(4);
  if (( y = GetSeries( 1, &dim2, index2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    index2[0] = 1;
  }
  if (( z = GetSeries( 2, &dim3, index3 ) ) == NULL ) {
    z = AllocBuffer(1);
    z[0] = GetScalar(2);
    index3[0] = 1;
  }
  v = GetScalar( 3 );

  if ( index2[0] != dim1 || index3[0] != index2[0] )
    exit(16);

  for ( i = 0; i < dim1; i++ ) {
    if ( (int)z[i] < (int)y[i] || index1[i] <= (int)z[i] )
      exit(7);
    index4[i] = (int)y[i];
    index5[i] = (int)z[i]-(int)y[i]+1;
  }

  if ( dim1 == 1 ) {
    m = index4[0]+index5[0];
    for ( i = index4[0]; i < m; i++ )
      x[ i ] = v;
  } else {
    for ( i = 0; i < dim1; i++ )
      pos [i] = index4[i];
    do {
      dpt = Index( pos, dim1, index1 );
      m = dpt + index5[dim1-1];
      for ( i = dpt; i < m; i++ )
	x[ i ] = v;

      pos [dim1-2]++;
      for ( i = dim1-2; i > 0; i-- )
	if ( pos[i] > z[i] ) {
	  pos [i-1]++;
	  pos [i] = y[i];
	}
    } while ( pos[0] <= z[0] );
  }
  ReturnSeries( x, dim1, index1 );
  FreeBuffer( x );
  FreeBuffer( y );
  FreeBuffer( z );
  return 0;
}
