#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
/************************************************
*      FIND   IB, VAL, NUM, IOUT                *
*             IB   : buffer number              *
*             VAL  : value                      *
*             IOUT : output                     *
************************************************/

int
main()
{
	register int    i, j;
	Buffer         *data, *positions;
	float          *points, *diff;
	int             num, nn, p, dmaxlen, imaxlen;
	double          val;
	int             dim1, index1[MAX_INDEX];
	int             dim2, index2[MAX_INDEX];
	char		tmp[6];

	/*-------< Load System Parameter >---------------*/

	read_syscom();
	data = GetSeries(0, &dim1, index1);
	val = GetScalar(1);
	num = (int) GetScalar(2);

	/*-------< Check Parameter >-----------------------*/
	if (data == NULL)
		exit(17);
	if (num < 1)
		exit(2);

	nn = IndexSize(dim1, index1);
	diff = (float *) malloc(nn * sizeof(float));
	points = (float *) malloc(nn * sizeof(float));
	if (diff == NULL || points == NULL)
	  exit(8);

	/*-------< Exection >----------------------------*/

	/* Sorting */
	for (i = 0; i < nn; i++)
		diff[i] = (float) fabs(data[i] - val);

	sort(diff, points, nn);

	/* Points to Positions */
	positions = AllocBuffer(num * dim1);
	for (i = 0; i < num; i++) {
		rIndex((int) points[i], index2, dim1, index1);
		for (j = 0; j < dim1; j++)
			positions[i * dim1 + j] = (Buffer) index2[j];
	}

	/* Caluculation of Pirint Width */
	imaxlen = dmaxlen = 0;
	for (i = 0; i < num; i++) {
		p = (int) points[i];
		sprintf(tmp, "%g", data[p]);
		if(dmaxlen < strlen(tmp))
			dmaxlen = strlen(tmp);

		rIndex(p, index2, dim1, index1);
		for (j = 0; j < dim1; j++) {
			sprintf(tmp, "%d", index2[j]);
			if(imaxlen < strlen(tmp))
				imaxlen = strlen(tmp);
		}
	}

	/* Print Value and Position */
	for (i = 0; i < num; i++) {
		p = (int) points[i];
		printf("\t DATA[ %*.7g ] -- POINT:", dmaxlen, data[p]);
		rIndex(p, index2, dim1, index1);
		for (j = 0; j < dim1; j++)
			printf("[%*d]", imaxlen, index2[j]);
		puts("");
	}

	/* Return Object to SATELLITE Language */
	if (num == 1 && dim1 == 1) {
		ReturnScalar(positions[0]);
	} else {
		dim2 = 2;
		index2[0] = num;
		index2[1] = dim1;
		ReturnSeries(positions, dim2, index2);
	}

	/* Free Memory */
	FreeBuffer(positions);
	FreeBuffer(data);
	free(diff);
	free(points);

	write_syscom();
	return 0;
}
