/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : get            *
*    ( Ver 1.0 : 1993/04/14 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

int
main()
{
  int index1[MAX_INDEX], index2[MAX_INDEX], index3[MAX_INDEX];
  int dim1, dim2, i, dpt;
  Buffer  *x, *y;

  read_syscom();
  
  if (( x = GetSeries( 0, &dim1, index1 )) == NULL )
    exit(4);
  if (( y = GetSeries( 1, &dim2, index2 )) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    index2[0] = 1;
  }
  if ( index2[0] != dim1 ) 
    exit(16);

  for ( i = 0; i < dim1; i++ )
    if ( (index3[i] = (int)y[i]) >= index1[i] )
      exit(7);

  dpt = Index( index3, dim1, index1 );

  ReturnScalar( x[dpt] );
  FreeBuffer( x );
  FreeBuffer( y );
  return 0;
}
