/**********************************************************
     file name : header.c

	Format ) HEADER FILENAME,TY
            TY : Operation
               = 0  : Print Only
               = 1  : Print & Modify

	                      Coded by Shigeru HITOMI
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define TWOBYTE  0
#define ONEBYTE  1
typedef short boolean;



char *
getstr(str, siz)
    char *str;
    int   siz;
{
  static char tmp[ONE_LINE];
  printf("            ---------> ");
  fgets(tmp, siz, stdin);
  tmp[strlen(tmp) - 1] = '\0';
  if(*tmp == '\0')
    strcpy(tmp,str);
  return tmp;
}

int
getint(n)
    int n;
{
  char  str[ONE_LINE];
  printf("            ---------> ");
  fgets(str, ONE_LINE-1, stdin);
  return (*str != '\n') ? atoi(str) : n;
}

double
getreal(d)
    double d;
{
  char  str[ONE_LINE];
  printf("            ---------> ");
  fgets(str, ONE_LINE-1, stdin);
  return (*str != '\n') ? atof(str) : d;
}

void
modify_date(date, onebyte)
    char    *date;
    boolean onebyte;
{
  short	int i, tmp[3];
  char      str[ONE_LINE];
  printf("            ---------> ");
  fgets(str, ONE_LINE-1, stdin);
  if (*str != '\n') {
    sscanf(str,"%4hd%*1c%2hd%*1c%2hd", tmp, tmp + 1, tmp + 2);
    if(onebyte) {
      date[0] = (char)(tmp[0]-1900);
      for(i=1;i<3;i++)
	date[i] = (char)tmp[i];
    } else {
      ((short *)date)[0] = tmp[0]-1900;
      for(i=1;i<3;i++)
	((short *)date)[i] = tmp[i];
    }
  }
}

void
new_header(f_name,modify)
    char    *f_name;
    boolean modify;
{
  Header head;
  int	 i;
  
  printf("   ****  NEW FILE TYPE ****");
  LoadHeader(f_name, &head);
  puts("");
  printf("   Byte order        : %s \n",
	 (head.type_flag == BigEndian) ? "BigEndian" : "LittleEndian");
  printf("   Data size         : %d byte\n", head.data_size);
  
  printf("   Owner             : %-20s \n", head.opr_name);
  if(modify) strcpy(head.opr_name, getstr(head.opr_name, 19));
  
  printf("   Date              : %4d/%2d/%2d \n",
	 head.date[0]+1900, head.date[1], head.date[2]);
  if(modify) modify_date(head.date, ONEBYTE);
  
  printf("   Comment           : %-50s \n", head.comment);
  if(modify) strcpy(head.comment, getstr(head.comment, 128));
  
  printf("   Sampling frequncy : %.1f [Hz]\n", head.samf);
  if(modify) head.samf = (float)getreal((float)head.samf);
  
  printf("   Dimension         : %d \n", head.dim);
  if(modify) head.dim = getint(head.dim);
  
  printf("   Index             : ");
  printf("[%d] x ", head.index[0]);
  for(i=1; i<head.dim; i++) {
    printf("[%d]", head.index[i]);
  }
  puts("");
  
  if(modify) StoreHeader(f_name, &head);
}


void
old_header(f_name,modify)
    char    *f_name;
    boolean modify;
{
  h_type head;
  
  printf("   ****  OLD FILE TYPE ****");
  load_header(f_name, &head);
  puts("");
  printf("   FILE FORMAT       : %s Format\n",
	 (head.type_flag != 0) ? "MS-DOS" : "UNIX");
  printf("   DATA TYPE         : %s Data\n",
	 (head.data_flag != 0) ? "INTEGER" : "FLOAT");
  
  printf("   OWNER             : %-20s \n", head.opr_name);
  if(modify) strcpy(head.opr_name, getstr(head.opr_name, 19));
  
  printf("   DATE              : %2d/%2d/%2d \n",
	 head.date[0], head.date[1], head.date[2]);
  if(modify) modify_date(head.date, TWOBYTE);
  
  printf("   COMMENT           : %-50s \n", head.comment);
  if(modify) strcpy(head.comment, getstr(head.comment, 256));
  
  printf("   SAMPLING FREQUNCY : %.1f [Hz]\n", head.samf);
  if(modify) head.samf = getreal(head.samf);
  
  printf("   RECORD LENGTH     : %d [blocks/record] \n", head.rec_leng);
  if(modify) head.rec_leng = getint(head.rec_leng);
  
  printf("   TOTAL RECORDS     : %d [records]\n", head.rec_num);
  if(modify) head.rec_num = getint(head.rec_num);
  printf("   DATA POINTS       : %d [data/record] \n", head.data_num);
  if(modify) head.data_num = getint(head.data_num);
  
  if(modify) stor_header(f_name, &head);
}

int
main()
{
  Header new_head;
  int    modify;
  char   *f_name;
  
  read_syscom();

  f_name = GetString(0);
  modify = (int)GetScalar(1);
  
  if( LoadHeader(f_name, &new_head) == -1 )
    exit(2);
  
  switch(new_head.type_flag) {
  case 0: 
  case 1:
    old_header(f_name, modify);
    break;
  default:
    new_header(f_name, modify);
    break;
  }
  return 0;
}
