#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef  USE_ENV
#define SL_HELP_ENV       "SL_HELP_VIEWER"
#endif

#define MANUAL_SKIP_PAGE  8

#ifndef DEFAULT_VIEWER
#define DEFAULT_VIEWER    "xdvi +%page% %dvi% -expert"
/* #define DEFAULT_VIEWER "xdvi -s 8 +%page% %dvi% -expert -ps" */
/* #define DEFALUT_VIEWER "gv -page +%page% %ps% -antialias" */
#endif

#define MANUAL_NAME       "reference-jp"

void
touppers(s)
    register char  *s;
{
  for (; *s != 0; s++)
    *s = (char)toupper((int)*s);
}

char *
strswap(s,f,t)
     const char *s;
     const char *f;
     const char *t;
{
  int s_len,f_len,t_len;
  char *ret;
  s_len=strlen(s); f_len=strlen(f); t_len=strlen(t);
#if 0
  printf("s: %s %d\n",s,s_len);
  printf("f: %s %d\n",f,f_len);
  printf("t: %s %d\n",t,t_len);
#endif
  ret=(char *)malloc(s_len-f_len+t_len+1);
  strncpy(ret,s,s_len-f_len);
  strcpy(&ret[s_len-f_len],t);
  return ret;
}

char *
inttostr(i)
     int i;
{
  int j,order;
  char *ret;
  for(j=i,order=1;j>=10;j/=10)order++;
#if 0
  printf("order :%d\n",order);
#endif
  ret=(char *)malloc(order+1);
  sprintf(ret,"%d",i);
  return ret;
}

char **
setviewcmd(page,path)
     int page;
     char *path;
{
  int cols,i,len,prev;
  char *viewer,**ret,*tmp;
#ifdef USE_ENV
  viewer=getenv(SL_HELP_ENV);
  if(viewer==NULL) viewer=DEFAULT_VIEWER;
#else
  viewer=DEFAULT_VIEWER;
#endif
  cols=0;
  /* count of viewer command arguments */
  for(i=0;viewer[i]!='\0';i++){
    if(viewer[i]!=' '){
      /* string skip */
      while(viewer[i+1]!='\0' && viewer[i+1]!=' ') i++;
      cols++;
    }
  }
  ret=(char **)malloc(sizeof(char*)*cols+1);

  /* prev offset */
  for(prev=0;viewer[prev]!='\0' && viewer[prev]==' ';prev++);

  /* read parts from viewer string */
  for(i=0;i<cols;i++){
    for(len=0; viewer[prev+len]!=' ' && viewer[prev+len]!='\0'; len++);
    tmp=(char *)malloc(len+1);
    strncpy(tmp,&viewer[prev],len);
    tmp[len]='\0';
    ret[i]=tmp;
    /* fixed %page% strings */
    if(strstr(ret[i],"%page%")!=NULL){
      char *p;
      p=inttostr(page+MANUAL_SKIP_PAGE);
      ret[i]=strswap(tmp,"%page%",p);
      free(p);
      free(tmp);
    }
    /* fixed %dvi% strings */
    else if(strstr(ret[i],"%dvi%")!=NULL){
      char *p;
      p=(char *)malloc(strlen(SL_MAN_DIR)+strlen(MANUAL_NAME)
		       +strlen(".dvi")+2);
      sprintf(p,"%s/%s.dvi",SL_MAN_DIR,MANUAL_NAME);
      ret[i]=strswap(tmp,"%dvi%",p);
      free(p);
      free(tmp);
    }
    /* fixed %ps% strings */
    else if(strstr(ret[i],"%ps%")!=NULL){
      char *p;
      p=(char *)malloc(strlen(SL_MAN_DIR)+strlen(MANUAL_NAME)
		       +strlen(".ps")+2);
      sprintf(p,"%s/%s.ps",SL_MAN_DIR,MANUAL_NAME);
      ret[i]=strswap(tmp,"%ps%",p);
      free(p);
      free(tmp);
    }
    /* fixed %pdf% strings */
    else if(strstr(ret[i],"%pdf%")!=NULL){
      char *p;
      p=(char *)malloc(strlen(SL_MAN_DIR)+strlen(MANUAL_NAME)
		       +strlen(".pdf")+2);
      sprintf(p,"%s/%s.pdf",SL_MAN_DIR,MANUAL_NAME);
      ret[i]=strswap(tmp,"%pdf%",p);
      free(p);
      free(tmp);
    }
#if 0
    printf("len[%d]: %d  off: %d str:(%s)\n",i,len,prev,ret[i]);
#endif
    while(viewer[prev+len]==' ') prev++;
    prev+=len;
  }
  ret[cols]=NULL;
  return ret;
}

void
execute_viewer(page)
    int page;
{
  char **viewcmd;
  switch (fork()) {
  case -1:
    printf("fork: cannot execute process\n");
    break;
  case 0:
    viewcmd=setviewcmd(page);
    close(1);
    execvp(viewcmd[0],viewcmd);
    fprintf(stderr,"help: cannot execute %s\n",viewcmd[0]);
    _exit(0);
    break;
  default:
    break;
  }
}

int
main( argc, argv )
    int argc;
    char *argv[];
{
  register int    c, n;
  int             page;
  char           *keyword, word[100];
  FILE           *fin;
  char           fname[FILE_LENGTH];
  
  if (argc != 2)
    return 0;
  keyword = argv[1];
  
#if 0
  resat();
  keyword = GetString(0);
#endif
  
  sprintf(fname, "%s/%s.idx", SL_MAN_DIR, MANUAL_NAME);
  fin = fopen(fname, "r");
  if(fin == 0) {
    puts("not found contents of manual.");
    return 0;
  }

  if ( keyword[0] == '\"' )
    keyword++;
  if ( keyword[strlen(keyword)-1] == '\"' )
    keyword[strlen(keyword)-1] = '\0';

  touppers(keyword);
  n = 0;
  while ((c = getc(fin)) != EOF) {
    switch (c) {
    case '(':
      while(getc(fin)!=')');break;
    case '{':
      n++;
      switch (n) {
      case 1:
	fscanf(fin, "%s", word);
	if (strcmp(word, keyword) != 0) {
	  while (getc(fin) != '\n')
	    /* nothing */ ;
	  n = 0;
	}
	break;
      case 2:
	fscanf(fin, "%d", &page);
	execute_viewer(page);
	fclose(fin);
	return 0;
	break;
      }
      break;
    case '\n':
      n = 0;
      break;
    default:
      break;
    }
  }
  printf("not found keyword %s.\n", keyword);
  fclose(fin);
  return 0;
}
