#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/******************************************
*      MABI  B1,B2,I                      *
*            B1 : INPUT BUFFER            *
*            I  : INTERVAL                *
*					  *
*	     Coding by I.Akagi            *
*		~~~     1991.Oct.22th	  *
*            Modified by K.Takebe         *
*			1993, 4,16	  *
*******************************************/
 
int
main()
{
  Buffer *data, *Data, *dat, *Dat, *max, *step;
  int j, dpt, dpt2, i, k, st;
  int dim1, index1[MAX_INDEX], dim2, index2[MAX_INDEX];
  int dim3, index3[MAX_INDEX];
  
  /*** Read Data ***/
  read_syscom() ;
  
  if (( data = GetSeries( 0, &dim1, index1 ) ) == NULL )
    exit(4);
  if ( dim1 > 0 ) {
    if (( step = GetSeries( 1, &dim3, index3 )) == NULL ) {
      step = AllocBuffer(1);
      step[0] = GetScalar(1);
      dim3 = 1;
      index3[0] = 1;
    }
    if ( dim1 != index3[0] )
      exit(16);

    for ( i = 0; i < index3[0]; i++ ) {
      if ( (int)step[i]  == 0 )
	step[i] = 1.0;
      else if ( (int)step[i] < 0 || (int)step[i] >= index1[i] ) {
	exit(2);
      }
      index2[i] = ( index1[i] + (int)step[i]-1 )/(int)step[i];
    }
    dim2 = dim1;
  } else
    exit(16);

  for ( i = 0; i < index3[0]; i++ )
    printf("[%d]",index1[i]);
  printf("->");
  for ( i = 0; i < index3[0]; i++ )
    printf("[%d]",index2[i]); 
  printf("\n");

  dpt  = IndexSize( dim1, index1 );
  dpt2 = IndexSize( dim2, index2 );

  if ((Data = AllocBuffer( dpt2 )) == NULL )
    exit(8);

  st = (int)step[dim1-1];
  k = index2[dim1-1];
  for ( Dat = Data, i = 0; i < dpt2; i+= k ) {
    rIndex( i, index3, dim1, index2 );
    for ( j = 0; j < dim1-1; j++ )
      index3[j] *= (int)step[j];
    dat = data+Index(index3,dim1,index1);
    max = dat+index1[dim1-1];
    for( ; dat < max; dat+= (int)st , Dat++ ) {
      *Dat = *dat;
    }
  }    

  ReturnSeries( Data, dim2, index2 );

  FreeBuffer( step );
  FreeBuffer( Data );
  FreeBuffer( data );
  return 0;
}
