#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/****************************************************
*   FIND POSITION OF MAXIMUM VALUE                  *
*---------------------------------------------------*
*     maxpos( x, num )                              *
*             x    : Input Buffer                   *
*             num  : get data number                *
*---------------------------------------------------*
*                 K.Takebe                          *
*                       1993 , 4 , 17               *
****************************************************/

int
main()
{
  Buffer *x, *xx;
  float  *dst, *idx, *ds, *id, *min, *max;
  int    leng, num, *ind, *maxi;
  int    dim, index1[MAX_INDEX], index2[MAX_INDEX];

  read_syscom();
  
  if (( x = GetSeries( 0, &dim, index1 ) ) == NULL )
    exit(4);

  leng = IndexSize( dim, index1 );

  if ( ( num =(int)GetScalar(1) ) >= leng )
    num = leng;

  dst = (float*)malloc( leng*sizeof(float) );
  idx = (float*)malloc( leng*sizeof(float) );

  if ( dst == NULL || idx == NULL )
    exit(8);

  max = dst + leng;

  for ( xx = x, ds = dst; ds < max; ds++, xx++ ) {
    *ds = (float)(*xx);
  }

  sort( dst, idx, leng );

  min = idx+leng-num;
  xx = x;
  for ( id = idx+(leng-1); id >= min; id-- ) {
    rIndex( (int)(*id), index2, dim, index1 );
    maxi = index2+dim;
    for ( ind = index2; ind < maxi; ind++, xx++ )
      *xx = (double)(*ind);
  }

  if ( num == 1 && dim == 1 )
    ReturnScalar( x[0] );
  else {
    index1[0] = num;
    index1[1] = dim;
    ReturnSeries( x, 2, index1 );
  }

  FreeBuffer( x );
  free( dst );
  free( idx );
  write_syscom();
  return 0;
}
