#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/**************************************
*        buffer merge                 *
**************************************/
int
main()
{
  register int    i, j, k, l;
  Buffer         *data1, *data2, *output;
  static int      dim1, index1[MAX_INDEX];
  static int      dim2, index2[MAX_INDEX];
  int             siz, aBlockSize;
  
  /***** Load System Parameter *****/
  read_syscom();

  data1 = GetSeries(0, &dim1, index1);
  data2 = GetSeries(1, &dim2, index2);
  if (data1 == NULL || data2 == NULL) 
    exit(4);

  if (dim1 != dim2)
    exit(19);

  if (!EqualIndex(SubIndex(index1), SubIndex(index2), dim1-1))
    exit(24);

  aBlockSize = IndexSize(dim1 - 1, SubIndex(index1));
  if (aBlockSize == 0)
    aBlockSize = 1;
  siz = IndexSize(dim1, index1) + IndexSize(dim2, index2);
  if (( output = AllocBuffer(siz) ) == NULL )
    exit(8);
  
  for (i = 0; i < index1[0]; i++) {
    for (j = 0; j < aBlockSize; j++) {
      k = i * aBlockSize + j;
      output[k] = data1[k];
    }
  }
  for (i = 0; i < index2[0]; i++) {
    for (j = 0; j < aBlockSize; j++) {
      k = (i + index1[0]) * aBlockSize + j;
      l = i * aBlockSize + j;
      output[k] = data2[l];
    }
  }
  index1[0] += index2[0];
  ReturnSeries(output, dim1, index1);
  return 0;
}
