/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : put            *
*    ( Ver 1.0 : 1993/03/09 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

int
main()
{
  int idx[MAX_INDEX], idx2[MAX_INDEX];
  int idx3[MAX_INDEX], idx4[MAX_INDEX];
  int pos[MAX_INDEX], pos2[MAX_INDEX];
  int dim, dim2, dim3, dim_const, m, l, dpt, dpt2, i, st;
  Buffer  *x, *y, *z;

  read_syscom();
  if (( x = GetSeries( 0, &dim, idx ) ) == NULL )
    exit(4);
  if (( z = GetSeries( 1, &dim3, idx3 ) ) == NULL ) {
    z = AllocBuffer(1);
    z[0] = GetScalar( 1 );
    dim3 = 1;
    idx3[0] = 1;
  }
  if (( y = GetSeries( 2, &dim2, idx2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(2);
    idx2[0] = 1;
  }
  if ( idx2[0] != dim || dim3 > dim )
    exit(16);

  for ( i = 0; i < dim; i++ )
    if ( ( idx4[i] = (int)y[i] ) >= idx[i] ) {
      exit(7);
    }
  if ( dim3 != dim ) {
    idx3[dim-1] = idx3[dim3-1];
    for ( i = 0; i < (dim-dim3); i++ )
      idx3[i] = 1;
    dim3 = dim;
  }

  if ( dim == 1 ) {
    m = idx4[0]+idx3[0];
    if ( m > idx[0] ) 
      m = idx[0];
    for ( l = 0, i = idx4[0]; i < m; i++, l++ )
      x[ i ] = z[ l ];
  } else {
    dim_const = dim-1;

    m = ((idx4[dim_const]+idx3[dim_const]) > idx[dim_const] )? 
      ( idx[dim_const] - idx4[dim_const] ) : idx3[dim_const];

    for ( i = 0; i < dim; i++ ) {
      pos [i] = idx4[i];
      pos2[i] = 0;
    } 

    do {
      dpt  = Index( pos , dim , idx );
      dpt2 = Index( pos2, dim3, idx3 );
      st   = m + dpt;
      for ( l = dpt2, i = dpt; i < st; i++, l++ )
	x[ i ] = z[ l ];
      
      pos2[dim-2]++;
      pos [dim-2]++;
      
      for ( i = dim-2; i > 0; i-- )
	if ( pos2[i] >= idx3[i] || pos[i] >= idx[i] ) {
	  pos2[i-1]++;
	  pos [i-1]++;
	  pos [i] = idx4[i];
	  pos2[i] = 0;
	}
    } while ( pos2[0] < idx3[0] && pos[0] < idx[0] );
  }
  ReturnSeries( x, dim, idx );
  FreeBuffer( x );
  FreeBuffer( y );
  FreeBuffer( z );
  return 0;
}
